/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import nextapp.echo2.app.Component;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;
import org.openvpms.web.workspace.admin.system.openoffice.OpenOfficeStatus;

public class OpenOfficeViewer
extends AbstractDiagnosticTab {
    private final OpenOfficeStatus status;
    private String[][] snapshot;
    private static final String[] COLUMNS = new String[]{"Name", "Value"};

    OpenOfficeViewer() {
        super("admin.system.openoffice.title");
        OpenOfficeService officeService = (OpenOfficeService)ServiceHelper.getBean(OpenOfficeService.class);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        this.status = new OpenOfficeStatus(officeService, (ArchetypeService)service);
    }

    @Override
    public Document getDocument() {
        Document result = null;
        String[][] data = this.getData();
        if (data != null) {
            result = this.toCSV("openoffice.csv", COLUMNS, data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        Component component = null;
        try {
            this.status.refresh();
            component = this.status.getComponent();
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        return component;
    }

    private String[][] getData() {
        if (this.snapshot == null) {
            try {
                this.snapshot = new String[4][];
                this.snapshot[0] = this.getProperty(this.status.getHome());
                this.snapshot[1] = this.getProperty(this.status.getPorts());
                this.snapshot[2] = this.getProperty(this.status.getMaxTasksPerProcess());
                this.snapshot[3] = this.getProperty(this.status.getRunning());
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
        return this.snapshot;
    }

    private String[] getProperty(Property property) {
        return new String[]{property.getDisplayName(), property.getString()};
    }
}

