/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import nextapp.echo2.app.Component;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.workspace.admin.system.cache.Memory;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;

class MemoryViewer
extends AbstractDiagnosticTab {
    private final Memory memory = new Memory(true);
    private String[][] snapshot;
    private static final String[] COLUMNS = new String[]{"Name", "Value"};

    MemoryViewer() {
        super("admin.system.diagnostic.memory");
    }

    @Override
    public Document getDocument() {
        String[][] data = this.getData(false);
        Document result = null;
        if (data != null) {
            return this.toCSV("memory.csv", COLUMNS, data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        this.getData(true);
        return this.memory.getComponent();
    }

    private String[][] getData(boolean refresh) {
        if (this.snapshot == null || refresh) {
            this.snapshot = new String[5][2];
            this.memory.refresh();
            this.populate(this.snapshot, 0, this.memory.getTotalMemory());
            this.populate(this.snapshot, 1, this.memory.getFreeMemory());
            this.populate(this.snapshot, 2, this.memory.getMemoryUse());
            this.populate(this.snapshot, 3, this.memory.getAllocatedTotal());
            this.populate(this.snapshot, 4, this.memory.getAllocatedFree());
        }
        return this.snapshot;
    }

    private void populate(String[][] data, int index, Property property) {
        data[index][0] = property.getDisplayName();
        data[index][1] = property.getString();
    }
}

