/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.web.component.bound.BoundCheckBox;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.table.TableEx;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;
import org.openvpms.web.workspace.admin.system.diagnostics.LogReader;

public class LogViewer
extends AbstractDiagnosticTab {
    private final Property pageSelector;
    private final ModifiableListener pageListener;
    private final Property search;
    private final Property matchCase;
    private final Button first;
    private final Button previous;
    private final Button next;
    private final Button last;
    private final Label size;
    private final TextField input;
    private final Button forward;
    private final Button backward;
    private final TableEx table;
    private final List<Integer> matches = new ArrayList<Integer>();
    private int currentMatch = -1;
    private LogReader reader;
    private int currentPage = 0;
    private static final int MAX_LINES = 100;
    private static final String MATCH_BACKGROUND = "#0078d7";
    private static final String MATCH_FOREGROUND = "#ffffff";

    LogViewer() {
        super("admin.system.diagnostic.log");
        this.pageSelector = new SimpleProperty("page", (Object)this.currentPage, Integer.class);
        this.pageListener = modifiable -> this.show(this.pageSelector.getInt() - 1);
        this.pageSelector.addModifiableListener(this.pageListener);
        this.search = new SimpleProperty("search", String.class);
        ModifiableListener searchListener = modifiable -> this.onSearch(this.currentPage, true);
        this.search.addModifiableListener(searchListener);
        this.matchCase = new SimpleProperty("matchCase", (Object)false, Boolean.class, Messages.get((String)"admin.system.diagnostic.log.matchcase"));
        this.matchCase.addModifiableListener(searchListener);
        this.first = ButtonFactory.create(null, (String)"navigation.first", this::onFirst);
        this.input = BoundTextComponentFactory.create((Property)this.pageSelector, (int)5);
        this.previous = ButtonFactory.create(null, (String)"navigation.previous", this::onPrevious);
        this.next = ButtonFactory.create(null, (String)"navigation.next", this::onNext);
        this.last = ButtonFactory.create(null, (String)"navigation.last", this::onLast);
        this.size = LabelFactory.create();
        this.forward = ButtonFactory.create(null, (String)"button.down", this::onSearchForward);
        this.forward.setToolTipText(Messages.get((String)"admin.system.diagnostic.log.nextmatch"));
        this.backward = ButtonFactory.create(null, (String)"button.up", this::onSearchBackward);
        this.backward.setToolTipText(Messages.get((String)"admin.system.diagnostic.log.previousmatch"));
        DefaultTableModel model = new DefaultTableModel(new Object[0][2], new Object[2]);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(0));
        columnModel.addColumn(new TableColumn(1));
        this.table = new TableEx((TableModel)model, (TableColumnModel)columnModel);
        this.table.setBorder(new Border(0, Color.WHITE, 0));
        this.table.setHeaderVisible(false);
        this.table.setInsets(new Insets(2));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer & Serializable)(table, o, i, i1) -> {
            if (o instanceof Component) {
                return (Component)o;
            }
            if (o instanceof Integer) {
                return TableHelper.rightAlign((String)(o + ": "));
            }
            return null;
        });
    }

    public List<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        String fileName = this.getDefaultFileName();
        if (fileName != null && Files.isReadable(Paths.get(fileName, new String[0]))) {
            files.add(fileName);
        }
        boolean done = false;
        int suffix = 1;
        while (!done) {
            String path = fileName + "." + suffix;
            if (Files.isReadable(Paths.get(path, new String[0]))) {
                files.add(path);
                ++suffix;
                continue;
            }
            done = true;
        }
        return files;
    }

    @Override
    public Document getDocument() {
        Document result = null;
        LogReader reader = this.getReader();
        if (reader != null) {
            result = this.getDocument(reader.getPath());
        }
        return result;
    }

    public Document getDocument(String file) {
        Document result = null;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(bytes);
             FileInputStream in = new FileInputStream(file);){
            int count;
            while ((count = in.read(buffer)) > 0) {
                gzip.write(buffer, 0, count);
            }
            in.close();
            gzip.finish();
            gzip.close();
            byte[] content = bytes.toByteArray();
            result = this.toDocument(file + ".gz", content, content.length, "application/gzip");
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        Label log;
        List<String> files = this.getFiles();
        if (!files.isEmpty()) {
            this.read(files.get(0));
            final SelectField fileSelector = SelectFieldFactory.create((Object[])files.toArray());
            fileSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    Object selectedItem = fileSelector.getSelectedItem();
                    if (selectedItem instanceof String) {
                        LogViewer.this.read(selectedItem.toString());
                        LogViewer.this.show(0);
                    }
                }
            });
            log = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{fileSelector, this.size});
        } else {
            log = LabelFactory.create((String)"admin.system.diagnostic.lognotfound");
        }
        BoundCheckBox matchCaseCheckBox = new BoundCheckBox(this.matchCase);
        matchCaseCheckBox.setText(this.matchCase.getDisplayName());
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.first, this.previous, this.input, this.next, this.last, LabelFactory.create((String)"query.search"), BoundTextComponentFactory.create((Property)this.search, (int)20), this.forward, this.backward, matchCaseCheckBox});
        SplitPane pane = SplitPaneFactory.create((int)5, (String)"LogViewer", (Component[])new Component[0]);
        pane.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{log, row})}));
        pane.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.table}));
        this.enablePaging(this.reader != null);
        this.show(this.currentPage);
        return pane;
    }

    private void read(String fileName) {
        this.reader = new LogReader(fileName, 100);
    }

    private LogReader getReader() {
        List<String> paths;
        if (this.reader == null && !(paths = this.getFiles()).isEmpty()) {
            this.read(paths.get(0));
        }
        return this.reader;
    }

    private void enablePaging(boolean enable) {
        this.first.setEnabled(enable);
        this.last.setEnabled(enable);
        this.input.setEnabled(enable);
        this.previous.setEnabled(enable);
        this.next.setEnabled(enable);
    }

    private void enableSearchControls() {
        if (this.reader != null && !StringUtils.isEmpty((CharSequence)this.search.getString())) {
            this.forward.setEnabled(true);
            this.backward.setEnabled(this.currentPage > 0 || this.currentMatch > 0);
        } else {
            this.forward.setEnabled(false);
            this.backward.setEnabled(false);
        }
    }

    private String getDefaultFileName() {
        String fileName = null;
        Appender appender = (Appender)LoggerContext.getContext().getConfiguration().getAppenders().get("fullout");
        if (appender instanceof RollingFileAppender) {
            fileName = ((RollingFileAppender)appender).getFileName();
        }
        return fileName;
    }

    private void onFirst() {
        this.show(0);
    }

    private void onPrevious() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.show(this.currentPage);
    }

    private void onNext() {
        this.show(this.currentPage + 1);
    }

    private void onLast() {
        LogReader.Page content = null;
        try {
            content = this.reader.readLast();
            if (content == null) {
                content = this.reader.readLast();
            }
        }
        catch (IOException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.show(content);
    }

    private void show(int pageNumber) {
        LogReader.Page page = null;
        try {
            if (this.getReader() != null && (page = this.reader.read(pageNumber)) == null) {
                page = this.reader.readLast();
            }
        }
        catch (IOException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.show(page);
    }

    private void show(LogReader.Page page) {
        this.show(page, this.getSearch(), true);
    }

    private LogReader.Search getSearch() {
        String criteria = this.search.getString();
        return criteria != null ? new LogReader.Search(criteria, this.matchCase.getBoolean()) : null;
    }

    private void show(LogReader.Page page, LogReader.Search search, boolean forward) {
        this.matches.clear();
        this.currentMatch = 0;
        this.size.setText(NumberFormatter.getSize((long)this.getLength()));
        if (page != null) {
            this.populate(page, search);
        } else {
            this.table.setModel((TableModel)new DefaultTableModel());
        }
        this.pageSelector.removeModifiableListener(this.pageListener);
        this.pageSelector.setValue(page != null ? Integer.valueOf(page.getPage() + 1) : null);
        this.pageSelector.addModifiableListener(this.pageListener);
        if (!forward && this.matches.size() > 0) {
            this.currentMatch = this.matches.size() - 1;
        }
        this.currentPage = page != null ? page.getPage() : 0;
        this.showCurrentMatch();
    }

    private void populate(LogReader.Page page, LogReader.Search search) {
        int lineNo = page.getFirstLine();
        List<String> lines = page.getLines();
        Object[][] data = new Object[lines.size()][2];
        for (int i = 0; i < lines.size(); ++i) {
            StringBuilder builder = new StringBuilder();
            builder.append("<div style='white-space:pre-wrap'>");
            String line = lines.get(i);
            data[i][0] = ++lineNo;
            if (search != null) {
                int start;
                int previous = 0;
                while ((start = search.indexOf(line, previous)) != -1) {
                    if (start > previous) {
                        builder.append(this.escape(line.substring(previous, start)));
                    }
                    this.matches.add(i);
                    builder.append("<span style='background-color:#0078d7;color:#ffffff'>");
                    int end = start + search.length();
                    builder.append(this.escape(line.substring(start, end)));
                    builder.append("</span>");
                    previous = end;
                }
                if (previous < line.length()) {
                    builder.append(this.escape(line.substring(previous)));
                }
            } else {
                builder.append(this.escape(line));
            }
            builder.append("</div>");
            data[i][1] = LabelFactory.html((String)builder.toString(), (boolean)true);
        }
        this.table.setModel((TableModel)new DefaultTableModel(data, new Object[2]));
    }

    private String escape(String text) {
        return StringEscapeUtils.escapeXml10((String)text);
    }

    private void showCurrentMatch() {
        if (this.currentMatch >= 0 && this.currentMatch < this.matches.size()) {
            this.scrollToLine(this.currentMatch);
        }
        this.enableSearchControls();
    }

    private void scrollToLine(int match) {
        if (match >= 0 && match < this.matches.size()) {
            this.table.setScrollToRow(this.matches.get(match).intValue());
        }
    }

    private void onSearchForward() {
        while (this.currentMatch + 1 < this.matches.size() && this.matches.get(this.currentMatch).equals(this.matches.get(this.currentMatch + 1))) {
            ++this.currentMatch;
        }
        if (this.currentMatch + 1 >= this.matches.size()) {
            this.onSearch(this.currentPage + 1, true);
        } else {
            ++this.currentMatch;
            this.showCurrentMatch();
        }
    }

    private void onSearchBackward() {
        while (this.currentMatch - 1 > 0 && this.matches.get(this.currentMatch).equals(this.matches.get(this.currentMatch - 1))) {
            --this.currentMatch;
        }
        if (this.currentMatch > 0) {
            --this.currentMatch;
            this.showCurrentMatch();
        } else if (this.currentPage > 0) {
            this.onSearch(this.currentPage - 1, false);
        }
    }

    private void onSearch(int pageNumber, boolean forward) {
        LogReader.Search search = this.getSearch();
        if (search != null && this.getReader() != null) {
            try {
                LogReader.Page page = this.reader.read(pageNumber);
                if (page == null) {
                    page = this.reader.readLast();
                }
                if (page != null) {
                    pageNumber = page.getPage();
                    while (page != null && !page.contains(search)) {
                        if (forward) {
                            page = this.reader.read(++pageNumber);
                            continue;
                        }
                        if (pageNumber > 0) {
                            page = this.reader.read(--pageNumber);
                            continue;
                        }
                        page = null;
                    }
                    if (page != null) {
                        this.show(page, search, forward);
                    }
                }
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    private long getLength() {
        try {
            return this.reader.getLength();
        }
        catch (Throwable exception) {
            return 0L;
        }
    }
}

