/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.cache;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;

class EditCacheDialog
extends MessageDialog {
    private final SimpleProperty currentSize;
    private final SimpleProperty suggestedSize;
    private final SimpleProperty newSize;
    private final RadioButton suggestedButton;
    private final RadioButton newButton;

    public EditCacheDialog(String cacheName, long maxCount, long suggested, HelpContext help) {
        super(Messages.get((String)"admin.system.cache.edit.title"), Messages.format((String)"admin.system.cache.edit.message", (Object[])new Object[]{cacheName}), OK_CANCEL, help);
        this.currentSize = new SimpleProperty("current", (Object)maxCount, Long.class, Messages.get((String)"admin.system.cache.edit.current"), true);
        this.suggestedSize = new SimpleProperty("suggested", (Object)suggested, Long.class, Messages.get((String)"admin.system.cache.edit.suggested"), true);
        this.newSize = new SimpleProperty("new", null, Long.class, Messages.get((String)"admin.system.cache.edit.new"));
        ButtonGroup group = new ButtonGroup();
        this.suggestedButton = ButtonFactory.create((String)"admin.system.cache.edit.suggested", (ButtonGroup)group, this::enableOK);
        this.newButton = ButtonFactory.create((String)"admin.system.cache.edit.new", (ButtonGroup)group);
        this.newSize.addModifiableListener(modifiable -> {
            this.newButton.setSelected(true);
            this.enableOK();
        });
        this.enableOK();
    }

    public long getCount() {
        return this.suggestedButton.isSelected() ? this.suggestedSize.getLong() : (this.newButton.isSelected() ? this.newSize.getLong() : -1L);
    }

    protected void doLayout() {
        Label content = LabelFactory.create((boolean)true, (boolean)true);
        content.setText(this.getMessage());
        TextField current = BoundTextComponentFactory.create((Property)this.currentSize, (int)10);
        current.setEnabled(false);
        TextField suggested = BoundTextComponentFactory.create((Property)this.suggestedSize, (int)10);
        suggested.setEnabled(false);
        ComponentGrid grid = new ComponentGrid();
        grid.add(new ComponentState[]{new ComponentState((Component)current, (Property)this.currentSize)});
        TextField input = BoundTextComponentFactory.create((Property)this.newSize, (int)10);
        grid.add(new Component[]{this.suggestedButton, suggested});
        grid.add(new Component[]{this.newButton, input});
        FocusGroup group = this.getFocusGroup();
        group.add((Component)suggested);
        group.add((Component)this.newButton);
        group.add((Component)input);
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{content, grid.createGrid()});
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
    }

    private void enableOK() {
        boolean enabled = this.suggestedButton.isSelected() || this.newButton.isSelected() && this.newSize.getLong() > 0L;
        this.getButtons().setEnabled("ok", enabled);
    }
}

