/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.cache;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.cache.CacheBrowser;
import org.openvpms.web.workspace.admin.system.cache.CacheState;
import org.openvpms.web.workspace.admin.system.cache.EditCacheDialog;

public class CacheDialog
extends ModalDialog {
    private final CacheBrowser browser;
    private final EhcacheManager manager;
    private static final String EDIT_ID = "button.edit";
    private static final String CLEAR_CACHE_ID = "button.clearcache";

    public CacheDialog(HelpContext help) {
        super(Messages.get((String)"admin.system.cache.title"), new String[0], help);
        this.resize("CacheDialog.size");
        this.browser = new CacheBrowser();
        this.manager = (EhcacheManager)ServiceHelper.getBean(EhcacheManager.class);
        this.addButton(EDIT_ID, this::edit);
        this.addButton("button.refresh", this::refreshStatistics);
        this.addButton("button.resetstatistics", this::resetStatistics);
        this.addButton(CLEAR_CACHE_ID, this::clearCache);
        this.addButton("close");
        this.enableButtons();
        this.browser.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                CacheDialog.this.enableButtons();
            }
        });
    }

    protected void doLayout() {
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{this.browser.getComponent()}));
        this.getFocusGroup().add(this.browser.getFocusGroup());
    }

    private void refreshStatistics() {
        this.browser.refresh();
        this.enableButtons();
    }

    private void resetStatistics() {
        this.browser.resetStatistics();
        this.enableButtons();
    }

    private void clearCache() {
        this.browser.clear();
        this.enableButtons();
    }

    private void edit() {
        final CacheState cache = this.browser.getSelected();
        if (cache != null) {
            long suggestedSize = this.browser.getSuggestedSize(cache);
            final EditCacheDialog dialog = new EditCacheDialog(cache.getDisplayName(), cache.getMaxCount(), suggestedSize, this.getHelpContext().subtopic("edit"));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    long count = dialog.getCount();
                    if (count > 0L) {
                        CacheDialog.this.manager.setMaxElements(cache.getCache(), cache.getName(), count);
                    }
                    CacheDialog.this.refreshStatistics();
                }
            });
            dialog.show();
        }
    }

    private void enableButtons() {
        ButtonSet buttons = this.getButtons();
        boolean enabled = this.browser.getSelected() != null;
        buttons.setEnabled(EDIT_ID, enabled);
        buttons.setEnabled(CLEAR_CACHE_ID, enabled);
    }
}

