/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.style;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.action.Action;
import org.openvpms.web.component.action.ActionBuilder;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.echo.dialog.SelectionDialog;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.echo.style.StyleSheetCache;
import org.openvpms.web.echo.style.ThemeResources;
import org.openvpms.web.echo.style.Themes;
import org.openvpms.web.echo.style.UserStyleSheets;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.style.ThemeListModel;
import org.openvpms.web.workspace.admin.style.ThemeRenderer;

public class ChangeThemeDialog
extends SelectionDialog {
    private final Party practice;
    private final ActionFactory factory;
    private final StyleSheetCache styleSheetCache;
    private final UserStyleSheets userStyleSheets;
    private static final String THEME = "theme";

    private ChangeThemeDialog(Party practice, ActionFactory factory) {
        super(Messages.get((String)"stylesheet.theme.title"), Messages.get((String)"stylesheet.theme.message"), ChangeThemeDialog.getThemes(practice));
        this.setCloseOnSelection(false);
        this.practice = practice;
        this.factory = factory;
        this.styleSheetCache = (StyleSheetCache)ServiceHelper.getBean(StyleSheetCache.class);
        this.userStyleSheets = (UserStyleSheets)ServiceHelper.getBean(UserStyleSheets.class);
    }

    public static void display() {
        PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        ActionFactory factory = (ActionFactory)ServiceHelper.getBean(ActionFactory.class);
        factory.newAction().withLatest("party.organisationPractice", () -> ((PracticeService)practiceService).getPractice()).call(practice -> {
            ChangeThemeDialog dialog = new ChangeThemeDialog((Party)practice, factory);
            dialog.show();
        }).runOnce();
    }

    protected void onSelected() {
        super.onSelected();
        String selected = (String)this.getSelected();
        if (selected != null) {
            this.updateTheme(selected);
        } else {
            this.close("ok");
        }
    }

    private static ListBox getThemes(Party practice) {
        int index;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        ThemeResources themes = (ThemeResources)ServiceHelper.getBean(ThemeResources.class);
        themes.load();
        ThemeListModel model = new ThemeListModel((Themes)themes);
        IMObjectBean bean = service.getBean((IMObject)practice);
        String theme = bean.getString(THEME);
        ListBox listBox = new ListBox((ListModel)model);
        if (theme != null && (index = model.indexOf(theme)) != -1) {
            listBox.setSelectedIndex(index);
        }
        listBox.setCellRenderer((ListCellRenderer)new ThemeRenderer((Themes)themes));
        ComponentFactory.setDefaultStyle((Component)listBox);
        return listBox;
    }

    private void updateTheme(String newTheme) {
        Action action = this.factory.newAction().action((IMObject)this.practice, ActionBuilder.update((String)THEME, (Object)newTheme)).onSuccess(() -> {
            this.close("ok");
            this.styleSheetCache.reset();
            this.userStyleSheets.reset();
            ContextApplicationInstance.getInstance().setStyleSheet();
        }).onFailure(() -> this.close("cancel")).build();
        action.run();
    }
}

