/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.style;

import java.awt.Dimension;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.OpenVPMSApp;
import org.openvpms.web.workspace.admin.style.ResolutionSelectField;
import org.openvpms.web.workspace.admin.style.StyleHelper;

public class ChangeResolutionDialog
extends PopupDialog {
    private final SimpleProperty width;
    private final SimpleProperty height;
    private final ResolutionSelectField field;

    public ChangeResolutionDialog(Dimension[] resolutions) {
        super(Messages.get((String)"stylesheet.changeResolution"), OK_CANCEL);
        this.setModal(true);
        this.field = new ResolutionSelectField(resolutions);
        this.width = new SimpleProperty("width", Integer.class);
        this.width.setRequired(true);
        this.width.setMaxLength(4);
        this.height = new SimpleProperty("height", Integer.class);
        this.height.setRequired(true);
        this.height.setMaxLength(4);
        this.field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                Dimension selected = (Dimension)ChangeResolutionDialog.this.field.getSelectedItem();
                ChangeResolutionDialog.this.setResolution(selected);
            }
        });
    }

    protected void doLayout() {
        Grid grid = GridFactory.create((int)2);
        grid.add((Component)LabelFactory.create((String)"stylesheet.resolution"));
        grid.add((Component)this.field);
        StyleHelper.addProperty(grid, (Property)this.width);
        StyleHelper.addProperty(grid, (Property)this.height);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid}));
    }

    protected void onOK() {
        if (this.width.isValid() && this.height.isValid()) {
            int w = this.width.getInt();
            int h = this.height.getInt();
            OpenVPMSApp.getInstance().createWindow(w, h);
            super.onOK();
        }
    }

    protected void setResolution(Dimension selected) {
        this.width.setValue((Object)selected.getWidth());
        this.height.setValue((Object)selected.getHeight());
    }
}

