/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.role;

import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class RoleEditor
extends AbstractIMObjectEditor {
    private final UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);

    public RoleEditor(SecurityRole object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
    }

    public void setName(String name) {
        this.getNameProperty().setValue((Object)name);
    }

    public String getName() {
        return this.getNameProperty().getString();
    }

    public IMObjectEditor newInstance() {
        return new RoleEditor((SecurityRole)this.reload((IMObject)((SecurityRole)this.getObject())), this.getParent(), this.getLayoutContext());
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateUniqueRoleName(validator);
    }

    private Property getNameProperty() {
        return this.getProperty("name");
    }

    private boolean validateUniqueRoleName(Validator validator) {
        boolean valid = true;
        Property property = this.getNameProperty();
        String name = property.getString();
        IMObject object = this.getObject();
        if (name != null && this.rules.roleExists(name, object.getId())) {
            String message = Messages.format((String)"admin.role.duplicate", (Object[])new Object[]{name});
            ValidatorError error = new ValidatorError(object.getArchetype(), property.getName(), message);
            validator.add((Modifiable)property, error);
            valid = false;
        }
        return valid;
    }
}

