/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.plugin;

import echopointng.TabbedPane;
import echopointng.tabbedpane.TabModel;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.edit.Saveable;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.tabpane.TabPaneModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.mapping.MappingEditors;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class MappingEditDialog
extends ModalDialog {
    private final Editors mappingEditors = new Editors();

    public MappingEditDialog(List<Mappings<?>> mappings, int selected, LayoutContext context) {
        super(Messages.get((String)"mapping.edit.title"), APPLY_OK_CANCEL, context.getHelpContext());
        Column mappingContainer = ColumnFactory.create((String)"InsetY");
        TabPaneModel model = new TabPaneModel((Component)mappingContainer);
        for (Mappings<?> m : mappings) {
            MappingEditors editors = new MappingEditors(m, context);
            this.mappingEditors.add(editors);
            model.addTab(m.getDisplayName(), editors.getComponent());
        }
        TabbedPane pane = TabbedPaneFactory.create((TabModel)model);
        if (selected >= 0 && selected < mappings.size()) {
            pane.setSelectedIndex(selected);
        }
        this.getLayout().add((Component)ColumnFactory.create((String)"InsetY", (Component[])new Component[]{pane}));
        this.resize("MappingEditDialog.size");
    }

    protected void onApply() {
        this.save();
    }

    protected void onOK() {
        if (this.save()) {
            super.onOK();
        }
    }

    private boolean save() {
        boolean result = false;
        try {
            DefaultValidator validator = new DefaultValidator();
            if (this.mappingEditors.validate((Validator)validator)) {
                TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
                template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                        for (Saveable saveable : MappingEditDialog.this.mappingEditors.getModifiedSaveable()) {
                            saveable.save();
                        }
                    }
                });
                result = true;
            } else {
                ValidationHelper.showError((Validator)validator);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        return result;
    }
}

