/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.plugin;

import echopointng.TabbedPane;
import echopointng.tabbedpane.TabModel;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.service.MappingProvider;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.plugin.service.config.ConfigurableService;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectTabPane;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.tabpane.TabPaneModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.mapping.MappingTableModel;
import org.openvpms.web.workspace.admin.plugin.MappingEditDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappingPluginEditor
extends AbstractIMObjectEditor {
    private final Component mappingContainer = ColumnFactory.create((String)"InsetY");
    private TabbedPane pane;
    private static final Logger log = LoggerFactory.getLogger(AbstractMappingPluginEditor.class);

    public AbstractMappingPluginEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    protected void doSave() {
        super.doSave();
        this.refresh();
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.refresh();
    }

    protected void refresh() {
        int index = this.pane != null ? this.pane.getSelectedIndex() : -1;
        this.mappingContainer.removeAll();
        try {
            IMObject config = this.getObject();
            if (!config.isNew()) {
                List<Mappings<?>> mappingsList = this.getMappings();
                if (!mappingsList.isEmpty()) {
                    TabPaneModel model = new TabPaneModel(this.mappingContainer);
                    for (Mappings<?> mappings : mappingsList) {
                        PagedIMTable table = new PagedIMTable(new MappingTableModel(mappings));
                        table.setResultSet((ResultSet)new ListResultSet(mappings.getMappings(), 20));
                        ButtonRow row = new ButtonRow();
                        row.addButton("button.editmappings", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

                            public void onAction(ActionEvent event) {
                                AbstractMappingPluginEditor.this.editMappings();
                            }
                        });
                        Column content = ColumnFactory.create((String)"InsetY", (Component[])new Component[]{ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{RowFactory.create((String)"InsetX", (Component[])new Component[]{row}), table.getTable()})});
                        model.addTab(mappings.getDisplayName(), (Component)content);
                    }
                    this.pane = TabbedPaneFactory.create((TabModel)model);
                    if (index != -1 && index < this.pane.getModel().size()) {
                        this.pane.setSelectedIndex(index);
                    }
                    this.mappingContainer.add((Component)ColumnFactory.create((String)"InsetY", (Component[])new Component[]{this.pane}));
                } else {
                    Button button = ButtonFactory.create((String)"button.refresh", this::refresh);
                    this.mappingContainer.add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{RowFactory.create((String)"CellSpacing", (Component[])new Component[]{button, LabelFactory.create((String)"mapping.notfound")})}));
                }
            } else {
                String message = Messages.format((String)"mapping.save", (Object[])new Object[]{this.getDisplayName()});
                this.mappingContainer.add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{LabelFactory.text((String)message)}));
            }
        }
        catch (Throwable exception) {
            Label label = LabelFactory.create((boolean)true, (boolean)true);
            label.setText(ErrorFormatter.format((Throwable)exception));
            this.mappingContainer.add((Component)label);
        }
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    protected MappingProvider getMappingProvider() {
        MappingProvider result = null;
        IMObject config = this.getObject();
        Object pluginService = this.getPluginService(config);
        if (pluginService instanceof MappingProvider) {
            result = (MappingProvider)pluginService;
        }
        return result;
    }

    protected Object getPluginService(IMObject config) {
        ConfigurableService result = null;
        PluginManager manager = (PluginManager)ServiceHelper.getBean(PluginManager.class);
        for (ConfigurableService service : manager.getServices(ConfigurableService.class)) {
            try {
                if (!config.isA(service.getArchetype())) continue;
                result = service;
                break;
            }
            catch (Throwable exception) {
                log.warn(exception.getMessage(), exception);
            }
        }
        return result;
    }

    private void editMappings() {
        List<Mappings<?>> mappingsList = this.getMappings();
        if (!mappingsList.isEmpty()) {
            int selectedIndex = this.pane != null ? this.pane.getSelectedIndex() : 0;
            MappingEditDialog dialog = new MappingEditDialog(mappingsList, selectedIndex, this.getLayoutContext());
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    AbstractMappingPluginEditor.this.refresh();
                }
            });
            dialog.show();
        }
    }

    private List<Mappings<?>> getMappings() {
        MappingProvider provider = this.getMappingProvider();
        return provider != null ? provider.getMappings() : Collections.emptyList();
    }

    private class LayoutStrategy
    extends AbstractLayoutStrategy {
        private LayoutStrategy() {
        }

        protected void doComplexLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
            IMObjectTabPaneModel model = this.doTabLayout(object, properties, container, context, false);
            model.addTab(Messages.get((String)"mapping.title"), AbstractMappingPluginEditor.this.mappingContainer);
            IMObjectTabPane pane = new IMObjectTabPane(model);
            pane.setSelectedIndex(0);
            container.add((Component)pane);
        }
    }
}

