/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityLinkCollectionTargetPropertyEditor;
import org.openvpms.web.component.im.relationship.MultipleRelationshipCollectionTargetEditor;
import org.openvpms.web.component.im.relationship.RelationshipCollectionTargetPropertyEditor;
import org.openvpms.web.component.im.table.BaseIMObjectTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.print.BoundPrinterField;
import org.openvpms.web.component.print.PrintHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.organisation.AbstractOrganisationEditor;
import org.openvpms.web.workspace.admin.organisation.OrganisationLocationLayoutStrategy;
import org.openvpms.web.workspace.admin.organisation.printer.PrinterEditor;

public class OrganisationLocationEditor
extends AbstractOrganisationEditor {
    private final PrinterCollectionEditor printers;
    private final List<PrinterReference> printerReferences = PrintHelper.getPrinters();

    public OrganisationLocationEditor(Party object, IMObject parent, LayoutContext layoutContext) {
        super((Entity)object, parent, layoutContext);
        this.printers = new PrinterCollectionEditor(this.getCollectionProperty("printers"), (Entity)object, layoutContext);
        this.addEditor((Editor)this.printers);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LocationLayoutStrategy();
    }

    private class LocationLayoutStrategy
    extends OrganisationLocationLayoutStrategy {
        private LocationLayoutStrategy() {
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            Property defaultPrinter = properties.get("defaultPrinter");
            BoundPrinterField field = new BoundPrinterField(defaultPrinter, OrganisationLocationEditor.this.printerReferences);
            this.addComponent(new ComponentState((Component)field, defaultPrinter));
            this.addComponent(new ComponentState((PropertyEditor)OrganisationLocationEditor.this.printers));
            return super.apply(object, properties, parent, context);
        }

        @Override
        protected ComponentState getLogo(IMObject object, LayoutContext context) {
            return this.getLogo(OrganisationLocationEditor.this.getLogoEditor());
        }
    }

    private class PrinterTableModel
    extends BaseIMObjectTableModel<IMObject> {
        private final int statusIndex;

        public PrinterTableModel() {
            super(null);
            DefaultTableColumnModel model = (DefaultTableColumnModel)this.createTableColumnModel(false, false, true, false, false);
            this.statusIndex = this.getNextModelIndex((TableColumnModel)model);
            model.addColumn(PrinterTableModel.createTableColumn((int)this.statusIndex, (String)"printer.status"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        protected Object getValue(IMObject object, TableColumn column, int row) {
            Object result;
            if (column.getModelIndex() == this.statusIndex) {
                IMObjectBean bean = this.getBean(object);
                PrinterReference reference = PrinterReference.fromString((String)bean.getString("printer"));
                result = OrganisationLocationEditor.this.printerReferences.contains(reference) ? Messages.get((String)"printer.status.available") : Messages.get((String)"printer.status.unknown");
            } else {
                result = super.getValue(object, column, row);
            }
            return result;
        }
    }

    private class PrinterCollectionEditor
    extends MultipleRelationshipCollectionTargetEditor {
        PrinterCollectionEditor(CollectionProperty property, Entity entity, LayoutContext context) {
            super((RelationshipCollectionTargetPropertyEditor)new EntityLinkCollectionTargetPropertyEditor(property, entity, (IMObjects)context.getCache()), (IMObject)entity, context);
        }

        public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
            return new PrinterEditor(object, this.getObject(), this.getAvailablePrinters(object), context);
        }

        protected void setCurrentEditor(IMObjectEditor editor) {
            if (editor instanceof PrinterEditor) {
                ((PrinterEditor)editor).setAvailablePrinters(this.getAvailablePrinters(editor.getObject()));
            }
            super.setCurrentEditor(editor);
        }

        protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
            return new PrinterTableModel();
        }

        protected void enableNavigation(boolean enable) {
            boolean enableAdd = enable;
            if (enable) {
                List<PrinterReference> available = this.getAvailablePrinters(null);
                enableAdd = !available.isEmpty();
            }
            super.enableNavigation(enable, enableAdd);
        }

        List<PrinterReference> getAvailablePrinters(IMObject current) {
            HashSet<PrinterReference> allocated = new HashSet<PrinterReference>();
            for (IMObject object : this.getCurrentObjects()) {
                IMObjectBean bean;
                PrinterReference reference;
                if (current == null || object.equals(current) || (reference = PrinterReference.fromString((String)(bean = this.getBean(object)).getString("printer"))) == null) continue;
                allocated.add(reference);
            }
            ArrayList<PrinterReference> available = new ArrayList<PrinterReference>(OrganisationLocationEditor.this.printerReferences);
            available.removeAll(allocated);
            return available;
        }
    }
}

