/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.mapping;

import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.mapping.model.Mapping;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.table.TableColumnFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingTableModel<T extends IMObject>
extends AbstractIMTableModel<Mapping> {
    protected static final int SOURCE_INDEX = 0;
    protected static final int TARGET_INDEX = 1;
    private static final Logger log = LoggerFactory.getLogger(MappingTableModel.class);

    public MappingTableModel(Mappings<T> mappings) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(TableColumnFactory.create((int)0, (Object)mappings.getSourceDisplayName()));
        model.addColumn(TableColumnFactory.create((int)1, (Object)mappings.getTargetDisplayName()));
        this.setTableColumnModel((TableColumnModel)model);
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    protected Object getValue(Mapping object, TableColumn column, int row) {
        if (column.getModelIndex() == 0) {
            return IMObjectHelper.getName((Reference)object.getSource());
        }
        return this.getTargetName(object);
    }

    private String getTargetName(Mapping object) {
        String result = null;
        try {
            Target target = object.getTarget();
            if (target != null) {
                result = target.getName();
            }
        }
        catch (Throwable exception) {
            log.debug("Failed to target target name: " + exception.getMessage(), exception);
        }
        return result;
    }
}

