/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.LookupRelationshipCollectionEditor;
import org.openvpms.web.component.im.relationship.LookupRelationshipEditor;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.workspace.admin.lookup.AbstractLookupEditor;

public class SuburbLookupEditor
extends AbstractLookupEditor {
    private static final String POSTCODE = "postCode";
    private static final String STATE = "target";

    public SuburbLookupEditor(Lookup object, IMObject parent, LayoutContext context) {
        super((IMObject)object, parent, context);
        if (object.isNew()) {
            Property state;
            Property postCode = this.getProperty(POSTCODE);
            if (postCode != null) {
                postCode.addModifiableListener(modifiable -> this.updateCode());
            }
            if ((state = this.getProperty(STATE)) != null) {
                state.addModifiableListener(modifiable -> this.updateCode());
            }
        }
    }

    public String getPostcode() {
        Property property = this.getProperty(POSTCODE);
        return property != null ? property.getString() : null;
    }

    public void setPostcode(String postcode) {
        Property property = this.getProperty(POSTCODE);
        if (property != null) {
            property.setValue((Object)postcode);
        }
    }

    public String getState() {
        IMObjectBean bean = this.getBean(this.getObject());
        Lookup state = (Lookup)bean.getSource(STATE, Lookup.class);
        return state != null ? state.getCode() : null;
    }

    public void setState(Lookup lookup) {
        LookupRelationshipCollectionEditor collectionEditor = (LookupRelationshipCollectionEditor)this.getEditor(STATE, true);
        LookupRelationshipEditor editor = (LookupRelationshipEditor)collectionEditor.getCurrentEditor();
        editor.setSource((IMObject)lookup);
    }

    public IMObjectEditor newInstance() {
        return new SuburbLookupEditor((Lookup)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    @Override
    protected String createCode() {
        String result = super.createCode();
        String postcode = this.getPostcode();
        if (!StringUtils.isEmpty((CharSequence)postcode)) {
            result = result + "_" + postcode;
        } else {
            String state = this.getState();
            if (!StringUtils.isEmpty((CharSequence)state)) {
                result = result + "_" + state;
            }
        }
        return result;
    }
}

