/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openvpms.archetype.rules.util.MappingCopyHandler;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.cache.MapIMObjectCache;
import org.openvpms.web.system.ServiceHelper;
import org.springframework.transaction.support.TransactionTemplate;

class LookupReplaceHelper {
    private final IArchetypeService service = ServiceHelper.getArchetypeService();

    public void replace(Lookup source, Lookup target, boolean delete) {
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        template.execute(status -> {
            this.doReplace(source, target, delete);
            return null;
        });
    }

    private void doReplace(Lookup source, Lookup target, boolean delete) {
        boolean move;
        LookupService lookupService = ServiceHelper.getLookupService();
        boolean bl = move = !delete;
        if (this.mergeRelationships(source, target, move)) {
            if (move) {
                this.service.save(Arrays.asList(source, target));
            } else {
                this.service.save((IMObject)target);
            }
        }
        lookupService.replace(source, target);
        if (delete) {
            this.service.remove((IMObject)source);
        }
    }

    private boolean mergeRelationships(Lookup source, Lookup target, boolean moveSourceRelationships) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        MapIMObjectCache cache = new MapIMObjectCache((ArchetypeService)service);
        cache.add((IMObject)source);
        cache.add((IMObject)target);
        boolean result = false;
        if (!source.getLookupRelationships().isEmpty()) {
            IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new LookupRelationshipCopyHandler(), (ArchetypeService)service);
            Reference targetRef = target.getObjectReference();
            Set srcRels = source.getSourceLookupRelationships();
            for (LookupRelationship relationship : srcRels.toArray(new LookupRelationship[0])) {
                boolean found = false;
                for (Object check : target.getSourceLookupRelationships()) {
                    if (!Objects.equals(check.getTarget(), relationship.getTarget())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    LookupRelationship copy = this.copyRelationship(copier, relationship);
                    copy.setSource(targetRef);
                    target.addLookupRelationship(copy);
                }
                if (!moveSourceRelationships) continue;
                source.removeLookupRelationship(relationship);
                Lookup other = (Lookup)cache.get(relationship.getTarget());
                if (other == null) continue;
                other.removeLookupRelationship(relationship);
                this.service.save((IMObject)other);
            }
            Set tgtRels = source.getTargetLookupRelationships();
            for (LookupRelationship relationship : tgtRels.toArray(new LookupRelationship[0])) {
                boolean found = false;
                for (LookupRelationship check : target.getTargetLookupRelationships()) {
                    if (!Objects.equals(check.getSource(), relationship.getSource())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                LookupRelationship copy = this.copyRelationship(copier, relationship);
                copy.setTarget(targetRef);
                target.addLookupRelationship(copy);
            }
            if (!moveSourceRelationships) {
                this.service.save((IMObject)source);
            }
            result = true;
        }
        return result;
    }

    private LookupRelationship copyRelationship(IMObjectCopier copier, LookupRelationship relationship) {
        List list = copier.apply((IMObject)relationship);
        if (list.size() != 1) {
            throw new IllegalStateException("Expected 1 object from LookupRelationshipCopyHandler, got: " + list.size());
        }
        if (!(list.get(0) instanceof LookupRelationship)) {
            throw new IllegalStateException("Got a " + ((IMObject)list.get(0)).getClass().getName() + " instead of a LookupRelationship");
        }
        return (LookupRelationship)list.get(0);
    }

    private static class LookupRelationshipCopyHandler
    extends MappingCopyHandler {
        public LookupRelationshipCopyHandler() {
            this.setCopy(new Class[]{LookupRelationship.class});
            this.setDefaultTreatment(MappingCopyHandler.Treatment.REFERENCE);
        }
    }
}

