/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.action.FailureReason;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.delete.AbstractIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.IMObjectDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.lookup.LookupReplaceHelper;
import org.openvpms.web.workspace.admin.lookup.ReplaceLookupBrowser;

public class LookupCRUDWindow
extends ResultSetCRUDWindow<Lookup> {
    private static final String REPLACE_ID = "replace";

    public LookupCRUDWindow(Archetypes<Lookup> archetypes, Query<Lookup> query, ResultSet<Lookup> lookups, Context context, HelpContext help) {
        super(archetypes, query, lookups, context, help);
    }

    protected void delete(Lookup object) {
        IMObjectDeleter deletor = this.getDeleter();
        deletor.delete((IMObject)object, this.getContext(), this.getHelpContext().subtopic("delete"), (IMObjectDeletionListener)new LookupDeletorListener());
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(REPLACE_ID, this::replace);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(REPLACE_ID, enable);
    }

    private void replace() {
        final Lookup lookup = (Lookup)this.getObject();
        if (lookup != null) {
            String shortName = lookup.getArchetype();
            Query query = QueryFactory.create((String)shortName, (Context)this.getContext(), Lookup.class);
            query.setAuto(true);
            HelpContext help = this.getHelpContext().subtopic(REPLACE_ID);
            DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), help);
            final ReplaceLookupBrowser browser = new ReplaceLookupBrowser((Query<Lookup>)query, lookup, (LayoutContext)context);
            ReplaceLookupBrowserDialog dialog = new ReplaceLookupBrowserDialog(browser, help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    LookupCRUDWindow.this.confirmReplace(lookup, (Lookup)browser.getSelected(), browser.deleteLookup());
                }
            });
            dialog.show();
        }
    }

    private void confirmReplace(final Lookup source, final Lookup target, final boolean delete) {
        String title = Messages.get((String)"lookup.replace.title");
        String message = Messages.format((String)(delete ? "lookup.replace.confirmDelete" : "lookup.replace.confirm"), (Object[])new Object[]{source.getName(), target.getName()});
        ConfirmationDialog dialog = new ConfirmationDialog(title, message, this.getHelpContext().subtopic("confirmreplace"));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                LookupReplaceHelper admin = new LookupReplaceHelper();
                admin.replace(source, target, delete);
                LookupCRUDWindow.this.onRefresh((IMObject)source);
            }
        });
        dialog.show();
    }

    private static class ReplaceLookupBrowserDialog
    extends BrowserDialog<Lookup> {
        public ReplaceLookupBrowserDialog(ReplaceLookupBrowser browser, HelpContext help) {
            super(Messages.get((String)"lookup.replace.title"), OK_CANCEL, (Browser)browser, help);
            this.setCloseOnSelection(false);
            this.getButtons().setEnabled("ok", false);
        }

        protected void onSelected(Lookup object) {
            this.getButtons().setEnabled("ok", object != null);
            super.onSelected((Object)object);
        }
    }

    private class LookupDeletorListener
    extends AbstractIMObjectDeletionListener<Lookup> {
        private LookupDeletorListener() {
        }

        public void deleted(Lookup object) {
            LookupCRUDWindow.this.onDeleted((IMObject)object);
        }

        public void deactivated(Lookup object) {
            LookupCRUDWindow.this.onSaved((IMObject)object, false);
        }

        public void alreadyDeactivated(Lookup object) {
            LookupCRUDWindow.this.onRefresh((IMObject)object);
        }

        public void failed(Lookup object, FailureReason reason) {
            if (this.lookupInUse(reason.getException())) {
                this.reportLookupInUse();
            } else {
                super.failed((IMObject)object, reason);
            }
        }

        private boolean lookupInUse(Throwable cause) {
            if (cause instanceof ArchetypeServiceException) {
                ArchetypeServiceException exception = (ArchetypeServiceException)cause;
                ArchetypeServiceException.ErrorCode errorCode = exception.getErrorCode();
                return ArchetypeServiceException.ErrorCode.CannotDeleteLookupInUse.equals((Object)errorCode);
            }
            return false;
        }

        private void reportLookupInUse() {
            String title = Messages.get((String)"imobject.delete.failed.title");
            String message = Messages.get((String)"lookup.delete.inuse");
            ErrorHelper.show((String)title, (String)message);
        }
    }
}

