/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractListResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class DurationFormatResultSet
extends AbstractListResultSet<IMObject> {
    public DurationFormatResultSet(List<IMObject> objects, int pageSize) {
        super(objects, pageSize);
        this.sort();
    }

    public void sort(SortConstraint[] sort) {
    }

    public boolean isSortedAscending() {
        return true;
    }

    public SortConstraint[] getSortConstraints() {
        return new SortConstraint[0];
    }

    protected void sort() {
        final Date now = new Date();
        this.getObjects().sort(new Comparator<IMObject>(){

            @Override
            public int compare(IMObject o1, IMObject o2) {
                Date date1 = this.getTo(now, (Lookup)o1);
                Date date2 = this.getTo(now, (Lookup)o2);
                return date1.compareTo(date2);
            }

            private Date getTo(Date from, Lookup format) {
                IMObjectBean bean = IMObjectHelper.getBean((IMObject)format);
                int interval = bean.getInt("interval");
                DateUnits unit = DateUnits.valueOf((String)bean.getString("units"));
                return DateRules.getDate((Date)from, (int)interval, (DateUnits)unit);
            }
        });
    }
}

