/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.workspace.admin.lookup.AbstractLookupEditor;

public class CurrencyEditor
extends AbstractLookupEditor {
    private static final String CODE = "code";
    private static final String MIN_DENOMINATION = "minDenomination";
    private static final String MIN_PRICE = "minPrice";
    private static final Log log = LogFactory.getLog(CurrencyEditor.class);

    public CurrencyEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        Property code = this.getProperty(CODE);
        code.addModifiableListener(new ModifiableListener(){

            public void modified(Modifiable modifiable) {
                CurrencyEditor.this.initValues(true);
            }
        });
        this.initValues(object.isNew());
    }

    protected void initValues(boolean overwrite) {
        Property code = this.getProperty(CODE);
        Property minDenomination = this.getProperty(MIN_DENOMINATION);
        Property minPrice = this.getProperty(MIN_PRICE);
        if (code.getValue() != null) {
            try {
                org.openvpms.archetype.rules.math.Currency currency = new org.openvpms.archetype.rules.math.Currency(Currency.getInstance(code.getString()), RoundingMode.HALF_UP);
                if (overwrite || MathRules.isZero((BigDecimal)minDenomination.getBigDecimal(BigDecimal.ZERO))) {
                    minDenomination.setValue((Object)currency.getDefaultRoundingAmount());
                }
                if (overwrite || MathRules.isZero((BigDecimal)minPrice.getBigDecimal(BigDecimal.ZERO))) {
                    minPrice.setValue((Object)currency.getDefaultRoundingAmount());
                }
            }
            catch (IllegalArgumentException exception) {
                log.warn((Object)("Failed to locate currency=" + code.getString()), (Throwable)exception);
            }
        }
    }
}

