/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractLookupEditor
extends AbstractIMObjectEditor {
    protected static final String CODE = "code";
    protected static final String NAME = "name";
    private Component code;

    public AbstractLookupEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        Editor codeEditor;
        this.disableMacroExpansion(CODE);
        if (object.isNew() && this.getProperty(CODE) != null) {
            this.initCode();
        }
        if ((codeEditor = this.getEditor(CODE)) != null) {
            this.code = codeEditor.getComponent();
            this.code.setEnabled(object.isNew());
        }
    }

    public String getCode() {
        Property code = this.getProperty(CODE);
        return code != null ? code.getString() : null;
    }

    public boolean validate(Validator validator) {
        boolean valid = super.validate(validator);
        if (valid) {
            valid = this.validateCode(validator);
        }
        return valid;
    }

    public void save() {
        super.save();
        if (this.code != null) {
            this.code.setEnabled(false);
        }
    }

    protected void updateCode() {
        Property property;
        if (this.getObject().isNew() && (property = this.getProperty(CODE)) != null) {
            String code = this.createCode();
            property.setValue((Object)code);
        }
    }

    protected void initCode() {
        Property code;
        Property name = this.getProperty(NAME);
        if (name != null && (code = this.getProperty(CODE)).isHidden()) {
            name.addModifiableListener(new ModifiableListener(){

                public void modified(Modifiable modifiable) {
                    AbstractLookupEditor.this.updateCode();
                }
            });
        }
    }

    protected boolean validateCode(Validator validator) {
        String code;
        boolean result = true;
        Lookup lookup = (Lookup)this.getObject();
        if (lookup.isNew() && !StringUtils.isEmpty((CharSequence)(code = lookup.getCode()))) {
            String node = CODE;
            Property property = this.getProperty(node);
            String name = property != null ? property.getDisplayName() : node;
            String archetype = lookup.getArchetype();
            if (this.exists(archetype, code)) {
                String message = Messages.format((String)"lookup.validation.duplicate", (Object[])new Object[]{this.getDisplayName(), name, code});
                validator.add((Modifiable)this, new ValidatorError(archetype, node, message));
                result = false;
            }
        }
        return result;
    }

    protected String createCode() {
        String code = null;
        String name = this.getProperty(NAME).getString();
        if (name != null) {
            code = name.toUpperCase();
            code = code.replaceAll("[^A-Z0-9]+", "_");
        }
        return code;
    }

    private boolean exists(String shortName, String code) {
        return ServiceHelper.getLookupService().getLookup(shortName, code, false) != null;
    }
}

