/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.laboratory;

import java.util.List;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.style.Styles;

public class TestLayoutStrategy
extends AbstractLayoutStrategy {
    public static final String CODE = "code";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String INVESTIGATION_TYPE = "investigationType";
    public static final String GROUP = "group";
    public static final String USE_DEVICE = "useDevice";
    public static final String TURNAROUND = "turnaround";
    public static final String SPECIMEN = "specimen";

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        boolean labTest;
        ArchetypeNodes nodes = ArchetypeNodes.all().excludeIfEmpty(new String[]{CODE}).exclude(new String[]{SPECIMEN});
        IMObjectBean bean = this.getBean(object);
        boolean bl = labTest = bean.getObject(CODE) != null;
        if (context.isEdit()) {
            if (labTest) {
                MutablePropertySet set = new MutablePropertySet(properties);
                set.setReadOnly(NAME);
                set.setReadOnly(DESCRIPTION);
                set.setReadOnly(INVESTIGATION_TYPE);
                set.setReadOnly(TURNAROUND);
                set.setReadOnly(GROUP);
                set.setReadOnly(USE_DEVICE);
                set.setReadOnly(SPECIMEN);
                properties = set;
            } else {
                nodes.exclude(new String[]{GROUP, USE_DEVICE});
            }
        } else {
            nodes.excludeIfEmpty(new String[]{TURNAROUND});
            if (!labTest) {
                nodes.exclude(new String[]{GROUP, USE_DEVICE});
            }
        }
        Property specimen = properties.get(SPECIMEN);
        if (specimen != null && (context.isEdit() || specimen.getString() != null)) {
            this.addComponent(this.createMultiLineText(specimen, object, 5, 20, Styles.FULL_WIDTH, context));
        }
        this.setArchetypeNodes(nodes);
        return super.apply(object, properties, parent, context);
    }

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
        ComponentGrid grid = super.createGrid(object, properties, context);
        ComponentState specimen = this.getComponent(SPECIMEN);
        if (specimen != null) {
            grid.add(specimen, 2);
        }
        return grid;
    }
}

