/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import java.util.Date;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.PairListModel;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.IntegerPropertyTransformer;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.job.scheduledreport.DateOffset;
import org.openvpms.web.workspace.admin.job.scheduledreport.ExpressionType;

class DateParameter
extends AbstractPropertyEditor {
    private final Property expressionType;
    private final ModifiableListener expressionTypeListener;
    private final Property value;
    private final SimpleProperty date;
    private final Component dateField;
    private final SimpleProperty offset;
    private final Component offsetField;
    private final SelectField unitsField;
    private final Row component;
    private final FocusGroup group;
    private final Button addOffset;

    public DateParameter(String name, String displayName, Property expressionType, Property value, LayoutContext context) {
        super((Property)new SimpleProperty(name, null, Date.class, displayName));
        this.value = value;
        this.date = new SimpleProperty(name, null, Date.class, displayName);
        this.offset = new SimpleProperty(name, null, Integer.class, displayName);
        this.offset.setTransformer((PropertyTransformer)new IntegerPropertyTransformer((Property)this.offset));
        this.expressionType = expressionType;
        this.expressionTypeListener = modifiable -> this.onExpressionTypeChanged();
        this.expressionType.addModifiableListener(this.expressionTypeListener);
        String currentValue = StringUtils.trimToNull((String)value.getString());
        this.addOffset = ButtonFactory.create(() -> this.showDate(false, true));
        this.addOffset.setText(Messages.get((String)"scheduledreport.expression.date.offset"));
        this.addOffset.setToolTipText(Messages.get((String)"scheduledreport.expression.date.offset.tooltip"));
        this.offsetField = BoundTextComponentFactory.create((Property)this.offset, (int)3);
        this.unitsField = this.createDateUnitField();
        IMObjectComponentFactory factory = context.getComponentFactory();
        this.dateField = factory.create((Property)this.date);
        boolean showOffset = false;
        if (this.isValueExpression()) {
            this.date.setValue((Object)value.getDate());
        } else {
            DateOffset duration = DateOffset.parse(currentValue);
            if (duration != null) {
                showOffset = true;
                this.offset.setValue((Object)Integer.toString(duration.getOffset()));
                this.unitsField.setSelectedItem((Object)duration.getUnits());
            } else {
                this.unitsField.setSelectedIndex(0);
            }
        }
        SelectField expressionTypeField = this.createExpressionTypeField(expressionType);
        if (expressionTypeField.getSelectedItem() == null) {
            expressionTypeField.setSelectedItem((Object)ExpressionType.VALUE.toString());
        }
        if (context.isEdit()) {
            this.date.addModifiableListener(modifiable -> value.setValue(this.date.getValue()));
            this.offset.addModifiableListener(modifiable -> this.onDateOffsetChanged());
            this.unitsField.getSelectionModel().addChangeListener((ChangeListener)new org.openvpms.web.echo.event.ChangeListener(){

                public void onChange(ChangeEvent event) {
                    DateParameter.this.onDateOffsetChanged();
                }
            });
            this.unitsField.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                }
            });
        }
        this.showDate(this.isValueExpression(), showOffset);
        this.component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{expressionTypeField, this.dateField, this.addOffset, this.offsetField, this.unitsField});
        this.group = new FocusGroup("DateParameter", new Component[]{expressionTypeField, this.dateField, this.addOffset, this.offsetField, this.unitsField});
    }

    public Component getComponent() {
        return this.component;
    }

    public FocusGroup getFocusGroup() {
        return this.group;
    }

    public void dispose() {
        super.dispose();
        this.expressionType.removeModifiableListener(this.expressionTypeListener);
    }

    private SelectField createExpressionTypeField(Property expressionType) {
        PairListModel model = new PairListModel();
        for (ExpressionType type : ExpressionType.values()) {
            model.add((Object)type.toString(), (Object)Messages.get((String)("scheduledreport.expression." + type.name())));
        }
        SelectField result = BoundSelectFieldFactory.create((Property)expressionType, (ListModel)model);
        result.setCellRenderer(PairListModel.RENDERER);
        return result;
    }

    private SelectField createDateUnitField() {
        PairListModel model = new PairListModel();
        for (DateUnits units : new DateUnits[]{DateUnits.DAYS, DateUnits.WEEKS, DateUnits.MONTHS, DateUnits.YEARS}) {
            model.add((Object)units, (Object)Messages.get((String)("scheduledreport.dateunits." + units.name())));
        }
        SelectField result = SelectFieldFactory.create((ListModel)model);
        result.setCellRenderer(PairListModel.RENDERER);
        return result;
    }

    private void onDateOffsetChanged() {
        String offset = this.getDateOffset();
        this.value.setValue((Object)offset);
    }

    private String getDateOffset() {
        int value = this.offset.getInt();
        String result = null;
        if (value != 0) {
            result = Integer.toString(value);
            DateUnits units = (DateUnits)this.unitsField.getSelectedItem();
            if (units != null) {
                switch (units) {
                    case DAYS: {
                        result = result + "d";
                        break;
                    }
                    case WEEKS: {
                        result = result + "w";
                        break;
                    }
                    case MONTHS: {
                        result = result + "m";
                        break;
                    }
                    case YEARS: {
                        result = result + "y";
                        break;
                    }
                    default: {
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    private void onExpressionTypeChanged() {
        boolean isDate = this.isValueExpression();
        this.showDate(isDate, this.offset.getInt() != 0);
        if (isDate) {
            this.value.setValue((Object)this.date.getDate());
        } else {
            this.value.setValue((Object)this.getDateOffset());
        }
    }

    private void showDate(boolean isDate, boolean showOffset) {
        this.dateField.setVisible(isDate);
        boolean offset = !isDate && showOffset;
        this.addOffset.setVisible(!isDate && !showOffset);
        this.offsetField.setVisible(offset);
        this.unitsField.setVisible(offset);
    }

    private boolean isValueExpression() {
        return ExpressionType.VALUE.toString().equals(this.expressionType.getString());
    }
}

