/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.account;

import java.util.Date;
import java.util.HashSet;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.util.PeriodHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.admin.job.account.AccountReminderCollectionEditor;

public class AccountReminderJobEditor
extends AbstractIMObjectEditor {
    static final String IGNORE_INTERVAL = "ignoreInterval";
    static final String IGNORE_INTERVAL_UNITS = "ignoreIntervalUnits";
    private static final String REMINDERS = "reminders";

    public AccountReminderJobEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        this.addEditor((Editor)new AccountReminderCollectionEditor(this.getCollectionProperty(REMINDERS), object, layoutContext));
    }

    public IMObjectEditor newInstance() {
        return new AccountReminderJobEditor((Entity)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        AccountReminderCollectionEditor reminders = this.getReminders();
        strategy.addComponent(new ComponentState((PropertyEditor)reminders));
        return strategy;
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateIntervals(validator);
    }

    protected boolean validateIntervals(Validator validator) {
        boolean valid = true;
        Date now = DateRules.getToday();
        Period ignore = PeriodHelper.getPeriod((IMObjectBean)this.getBean(this.getObject()), (String)IGNORE_INTERVAL, (String)IGNORE_INTERVAL_UNITS);
        Date ignoreFrom = DateRules.minus((Date)now, (Period)ignore);
        AccountReminderCollectionEditor reminders = this.getReminders();
        HashSet<Date> dates = new HashSet<Date>();
        for (IMObject reminder : reminders.getObjects()) {
            DateUnits units;
            IMObjectEditor editor = reminders.getEditor(reminder);
            int interval = editor.getProperty("interval").getInt();
            Date date = DateRules.getDate((Date)now, (int)(-interval), (DateUnits)(units = DateUnits.fromString((String)editor.getProperty("units").getString(), (DateUnits)DateUnits.DAYS)));
            if (!dates.add(date)) {
                valid = false;
                validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"accountreminder.duplicateinterval", (Object[])new Object[]{DateFormatter.formatInterval((int)interval, (DateUnits)units)})));
                break;
            }
            if (date.compareTo(ignoreFrom) >= 0) continue;
            valid = false;
            String message = Messages.format((String)"accountreminder.ignoreintervalmustbegreater", (Object[])new Object[]{this.getProperty(IGNORE_INTERVAL).getDisplayName(), DateFormatter.formatInterval((int)interval, (DateUnits)units)});
            validator.add((Modifiable)this, new ValidatorError(message));
            break;
        }
        return valid;
    }

    private AccountReminderCollectionEditor getReminders() {
        return (AccountReminderCollectionEditor)this.getEditor(REMINDERS, false);
    }
}

