/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import java.util.Date;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.service.scheduler.JobScheduler;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.NameDescTableModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTableModel
extends NameDescTableModel<Entity> {
    private final JobScheduler scheduler = (JobScheduler)ServiceHelper.getBean(JobScheduler.class);
    private int nextRunIndex;
    private static final Logger log = LoggerFactory.getLogger(JobTableModel.class);

    public JobTableModel() {
    }

    public JobTableModel(Query<Entity> query) {
        super(query);
    }

    protected Object getValue(Entity object, TableColumn column, int row) {
        Object result = null;
        result = column.getModelIndex() == this.nextRunIndex ? this.getNextRuntime(object) : super.getValue((IMObject)object, column, row);
        return result;
    }

    protected TableColumnModel createTableColumnModel(boolean showId, boolean showArchetype, boolean showActive) {
        TableColumnModel model = super.createTableColumnModel(showId, showArchetype, showActive);
        this.nextRunIndex = this.getNextModelIndex(model);
        TableColumn column = new TableColumn(this.nextRunIndex);
        column.setHeaderValue((Object)Messages.get((String)"admin.job.nextrun"));
        model.addColumn(column);
        return model;
    }

    private String getNextRuntime(Entity object) {
        String result = null;
        try {
            Date time = this.scheduler.getNextRunTime(object);
            if (time != null) {
                result = DateFormatter.formatDateTimeAbbrev((Date)time);
            }
        }
        catch (Exception exception) {
            log.warn("Failed to get next run time for job={}: {}", new Object[]{object.getName(), exception.getMessage(), exception});
        }
        return result;
    }
}

