/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.List;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.resource.i18n.Messages;

public class HL7MessageQuery
extends DateRangeActQuery<Act> {
    public static final String INCOMPLETE = "INCOMPLETE";
    private static final ActStatuses STATUSES = new ActStatuses((LookupQuery)new StatusLookupQuery());
    private static final org.openvpms.component.model.lookup.Lookup INCOMPLETE_STATUS = new Lookup(new ArchetypeId("lookup.local"), "INCOMPLETE", Messages.get((String)"admin.hl7.status.incomplete"));

    public HL7MessageQuery(Entity connector) {
        super(connector, "connector", "participation.HL7Connector", new String[]{"act.HL7Message"}, STATUSES, Act.class);
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        org.openvpms.component.model.lookup.Lookup selected = this.getStatusSelector().getSelected();
        String[] statuses = selected == INCOMPLETE_STATUS ? new String[]{"PENDING", "ERROR"} : super.getStatuses();
        return new ActResultSet(this.getArchetypeConstraint(), this.getParticipantConstraint(), this.getFrom(), this.getTo(), statuses, false, this.getConstraints(), this.getMaxResults(), sort);
    }

    private static class StatusLookupQuery
    extends NodeLookupQuery {
        StatusLookupQuery() {
            super("act.HL7Message", "status");
        }

        public org.openvpms.component.model.lookup.Lookup getDefault() {
            return INCOMPLETE_STATUS;
        }

        public List<org.openvpms.component.model.lookup.Lookup> getLookups() {
            List lookups = super.getLookups();
            lookups.add(0, INCOMPLETE_STATUS);
            return lookups;
        }
    }
}

