/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.Date;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.hl7.HL7MessageQuery;

public class HL7MessageDialog
extends PopupDialog {
    private final Context context;
    private final Browser<Act> browser;
    private final boolean isSender;
    private Column messageContainer;
    private static final String RESUBMIT_ID = "button.resubmit";
    private static final String DEQUEUE_ID = "button.dequeue";

    public HL7MessageDialog(Entity connector, Context context, HelpContext help) {
        super(Messages.format((String)"admin.hl7.messages.title", (Object[])new Object[]{connector.getName()}), OK, help);
        this.setModal(true);
        this.setStyleName("BrowserDialog");
        this.context = context;
        HL7MessageQuery query = new HL7MessageQuery(connector);
        QueryFactory.initialise((Query)query);
        this.isSender = this.isSender(connector);
        if (this.isSender) {
            this.addButton(RESUBMIT_ID, this::onResubmit);
            this.addButton(DEQUEUE_ID, this::onDequeue);
        }
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(context, help);
        TableComponentFactory factory = new TableComponentFactory((LayoutContext)layoutContext){

            protected String getDateValue(Property property) {
                Date value = property.getDate();
                return value != null ? DateFormatter.formatDateTimeAbbrev((Date)value) : null;
            }

            protected Component createString(Property property, Hint hint) {
                return super.createLabel(property, true);
            }
        };
        layoutContext.setComponentFactory((IMObjectComponentFactory)factory);
        this.browser = BrowserFactory.create((Query)query, (LayoutContext)layoutContext);
        this.browser.addBrowserListener((BrowserListener)new BrowserListener<Act>(){

            public void selected(Act object) {
                HL7MessageDialog.this.onSelected(object);
            }

            public void browsed(Act object) {
            }

            public void query() {
            }
        });
    }

    protected void doLayout() {
        this.messageContainer = ColumnFactory.create((String)"Inset");
        SplitPane container = SplitPaneFactory.create((int)5, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{this.browser.getComponent(), this.messageContainer});
        this.getLayout().add((Component)container);
        super.doLayout();
    }

    private void onResubmit() {
        if (this.isSender) {
            DocumentAct act = (DocumentAct)IMObjectHelper.reload((IMObject)((IMObject)this.browser.getSelected()));
            if (act != null && "ERROR".equals(act.getStatus())) {
                ((MessageDispatcher)ServiceHelper.getBean(MessageDispatcher.class)).resubmit(act);
                act.setStatus("PENDING");
                SaveHelper.save((IMObject)act);
            }
            this.refresh();
        }
    }

    private void onDequeue() {
        if (this.isSender) {
            final DocumentAct act = (DocumentAct)IMObjectHelper.reload((IMObject)((IMObject)this.browser.getSelected()));
            if (act != null && "PENDING".equals(act.getStatus())) {
                String title = Messages.get((String)"admin.hl7.dequeue.title");
                String message = Messages.get((String)"admin.hl7.dequeue.message");
                ConfirmationDialog dialog = new ConfirmationDialog(title, message, ConfirmationDialog.YES_NO);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onYes() {
                        act.setStatus("CANCELLED");
                        SaveHelper.save((IMObject)act);
                        HL7MessageDialog.this.refresh();
                    }
                });
                dialog.show();
            } else {
                this.refresh();
            }
        }
    }

    private void refresh() {
        this.browser.query();
        this.onSelected((Act)this.browser.getSelected());
    }

    private void onSelected(Act object) {
        this.messageContainer.removeAll();
        ButtonSet buttons = this.getButtons();
        if (object != null) {
            IMObjectViewer viewer = new IMObjectViewer((IMObject)object, (LayoutContext)new DefaultLayoutContext(this.context, this.getHelpContext()));
            this.messageContainer.add(viewer.getComponent());
            if (this.isSender) {
                String status = object.getStatus();
                buttons.setEnabled(RESUBMIT_ID, "ERROR".equals(status));
                buttons.setEnabled(DEQUEUE_ID, "PENDING".equals(status));
            }
        } else if (this.isSender) {
            buttons.setEnabled(RESUBMIT_ID, false);
            buttons.setEnabled(DEQUEUE_ID, false);
        }
    }

    private boolean isSender(Entity connector) {
        return TypeHelper.isA((IMObject)connector, (String)"entity.HL7Sender*");
    }
}

