/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.esci;

import java.util.Arrays;
import java.util.Objects;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.client.SupplierServiceLocator;
import org.openvpms.esci.adapter.dispatcher.ESCIConfig;
import org.openvpms.esci.adapter.dispatcher.ESCIDispatcher;
import org.openvpms.esci.adapter.dispatcher.ErrorHandler;
import org.openvpms.esci.adapter.dispatcher.Inbox;
import org.openvpms.esci.service.InboxService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.esci.ESCIBrowser;
import org.openvpms.web.workspace.admin.esci.ESCIDocumentDialog;
import org.openvpms.web.workspace.supplier.order.ESCIErrorHandler;

class ESCICRUDWindow
extends ResultSetCRUDWindow<Party> {
    private final ESCIBrowser browser;
    private static final String CHECK_INBOX_ID = "button.checkInbox";
    private static final String CHECK_ALL_INBOXES_ID = "button.checkAllInboxes";
    private static final String MANAGE_INBOX_ID = "button.manageinbox";

    public ESCICRUDWindow(Archetypes<Party> archetypes, ESCIBrowser browser, Context context, HelpContext help) {
        super(archetypes, browser.getQuery(), browser.getResultSet(), context, help);
        this.browser = browser;
    }

    public void edit() {
        EntityRelationship config;
        Party object = (Party)this.getObject();
        if (object != null && Objects.equals(object, this.browser.getSelected()) && (config = this.browser.getConfig()) != null) {
            this.setSelectionPath(Arrays.asList(new Selection("stockLocations", null), new Selection(null, (IMObject)config)));
        }
        super.edit();
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createViewButton());
        buttons.add(this.createEditButton());
        buttons.add(CHECK_INBOX_ID, this::checkInbox);
        buttons.add(CHECK_ALL_INBOXES_ID, this::checkAllInboxes);
        buttons.add(MANAGE_INBOX_ID, this::onManageInbox);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(CHECK_INBOX_ID, enable);
        buttons.setEnabled(MANAGE_INBOX_ID, enable);
    }

    private void checkInbox() {
        Inbox inbox = this.getInbox();
        if (inbox != null) {
            ESCIErrorHandler handler = new ESCIErrorHandler();
            ESCIDispatcher dispatcher = (ESCIDispatcher)ServiceHelper.getBean(ESCIDispatcher.class);
            int count = dispatcher.dispatch(inbox, (ErrorHandler)handler);
            if (handler.getErrors() != 0) {
                this.showErrors(Messages.format((String)"admin.esci.checkinbox.error", (Object[])new Object[]{inbox.getSupplier().getName(), inbox.getStockLocation().getName()}), handler);
            } else {
                InformationDialog.show((String)Messages.get((String)"admin.esci.checkinbox.title"), (String)Messages.format((String)"admin.esci.checkinbox.message", (Object[])new Object[]{count}));
            }
        }
    }

    private void onManageInbox() {
        Inbox inbox = this.getInbox();
        if (inbox != null) {
            ESCIDocumentDialog dialog = new ESCIDocumentDialog(inbox, this.getContext(), this.getHelpContext().subtopic("inbox"));
            dialog.show();
        }
    }

    private void checkAllInboxes() {
        ESCIErrorHandler handler = new ESCIErrorHandler();
        ESCIDispatcher dispatcher = (ESCIDispatcher)ServiceHelper.getBean(ESCIDispatcher.class);
        int count = dispatcher.dispatch((ErrorHandler)handler);
        if (handler.getErrors() != 0) {
            this.showErrors(Messages.get((String)"admin.esci.checkallinboxes.error"), handler);
        } else {
            InformationDialog.show((String)Messages.get((String)"admin.esci.checkallinboxes.title"), (String)Messages.format((String)"admin.esci.checkinbox.message", (Object[])new Object[]{count}));
        }
    }

    private Inbox getInbox() {
        Inbox result = null;
        ESCIConfig config = this.getConfig();
        if (config != null) {
            SupplierServiceLocator locator = (SupplierServiceLocator)ServiceHelper.getBean(SupplierServiceLocator.class);
            InboxService inboxService = locator.getInboxService(config);
            result = new Inbox(config, inboxService);
        }
        return result;
    }

    private ESCIConfig getConfig() {
        ESCIConfig result = null;
        Party supplier = (Party)IMObjectHelper.reload((IMObject)((IMObject)this.browser.getSelected()));
        Party stockLocation = this.browser.getStockLocation();
        if (supplier != null && stockLocation != null) {
            result = ESCIConfig.create((Party)supplier, (Party)stockLocation, (ArchetypeService)ServiceHelper.getArchetypeService());
        }
        return result;
    }

    private void showErrors(String context, ESCIErrorHandler handler) {
        ((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().preamble(context)).message(handler.formatErrors())).show();
    }
}

