/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import echopointng.PopUp;
import echopointng.layout.TableLayoutDataEx;
import echopointng.table.TableCellRendererEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Date;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.layout.RowLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.echo.colour.ColourHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.workspace.admin.calendar.CalendarTableModel;

public class CalendarTableCellRenderer
implements TableCellRendererEx {
    private final CalendarTableModel model;
    private int previousRow = -1;
    private boolean newPrompt = false;

    public CalendarTableCellRenderer(CalendarTableModel model) {
        this.model = model;
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        Component component = value instanceof PropertySet ? this.getEvent((PropertySet)value, column, row) : this.getComponent(column, row);
        if (component != null) {
            if (this.isCut(column, row)) {
                this.cutCell(table, component);
            } else if (this.canHighlightCell(column, row, value)) {
                this.highlightCell(component);
            }
        }
        return component;
    }

    public boolean isSelectionCausingCell(Table table, int column, int row) {
        return true;
    }

    public boolean isActionCausingCell(Table table, int column, int row) {
        return true;
    }

    public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
        return null;
    }

    protected CalendarTableModel getModel() {
        return this.model;
    }

    protected Component getComponent(int column, int row) {
        if (this.previousRow != row) {
            this.newPrompt = false;
        }
        Component component = null;
        Cell cell = this.model.getSelected();
        if (cell != null && row == cell.getRow() && !this.newPrompt && this.renderNewPrompt(this.model, column)) {
            component = LabelFactory.create((String)"workflow.scheduling.table.new");
            int rows = this.model.getFreeRows(column, row);
            component.setLayoutData((LayoutData)TableFactory.rowSpan((int)rows));
            this.highlightCell(component);
            this.newPrompt = true;
        }
        if (component == null) {
            component = this.getFreeSlot(column, row);
        }
        this.previousRow = row;
        return component;
    }

    protected void styleEvent(Component component) {
        TableLayoutDataEx layout = TableHelper.getTableLayoutDataEx((String)"Calendar.Event");
        Color background = layout.getBackground();
        if (background != null) {
            this.setForegroundFromBackground(component, background);
        }
        TableHelper.mergeStyle((Component)component, (TableLayoutData)layout, (boolean)true);
    }

    protected boolean canHighlightCell(int column, int row, Object value) {
        boolean highlight = false;
        if (this.getModel().isSelected(column, row) && value instanceof PropertySet) {
            highlight = true;
        }
        return highlight;
    }

    protected boolean isCut(int column, int row) {
        return this.model.isCut() && this.model.isMarked(column, row);
    }

    protected void highlightCell(Component component) {
        TableHelper.mergeStyle((Component)component, (String)"ScheduleTable.Selected", (boolean)true);
        Color colour = component.getForeground();
        if (colour != null && component.getComponentCount() != 0) {
            this.setForeground(component, colour);
        }
    }

    protected void cutCell(Table table, Component component) {
        this.setStrikethroughFont(component, table);
    }

    protected Font getFont(Component component) {
        Font font = component.getFont();
        if (font == null && (font = (Font)component.getRenderProperty("font")) == null && component.getParent() != null) {
            font = this.getFont(component.getParent());
        }
        return font;
    }

    protected Component getEvent(PropertySet event, int column, int row) {
        Component result = this.getEvent(event);
        Label next = null;
        Label previous = null;
        Date startTime = event.getDate("act.startTime");
        int slot = column - 1;
        if (DateRules.compareDates((Date)startTime, (Date)this.model.getStartDate()) < 0) {
            previous = LabelFactory.create(null, (String)"navigation.previous");
        }
        int colSpan = this.model.getColumns(event, slot);
        int rowSpan = this.model.getRows(event, column, row);
        if (colSpan > 1 && column + colSpan > this.model.getColumnCount()) {
            next = LabelFactory.create(null, (String)"navigation.next");
            RowLayoutData newValue = new RowLayoutData();
            newValue.setAlignment(Alignment.ALIGN_RIGHT);
            newValue.setWidth(Styles.FULL_WIDTH);
            next.setLayoutData((LayoutData)newValue);
        }
        if (previous != null || next != null) {
            Row container = RowFactory.create();
            if (previous != null) {
                container.add((Component)previous);
            }
            container.add(result);
            if (next != null) {
                container.add((Component)next);
            }
            result = container;
        }
        if (colSpan > 1 || rowSpan > 1) {
            result.setLayoutData(TableFactory.span((int)colSpan, (int)rowSpan));
        }
        this.styleEvent(result);
        return result;
    }

    protected Component getFreeSlot(int column, int row) {
        CalendarTableModel model = this.getModel();
        Label result = TableHelper.createSpacer();
        TableLayoutDataEx layout = new TableLayoutDataEx();
        int rows = model.getFreeRows(column, row);
        layout.setRowSpan(rows);
        result.setLayoutData((LayoutData)layout);
        return result;
    }

    private Component getEvent(PropertySet event) {
        Label label;
        String text = event.getString("notes");
        if (text == null) {
            text = event.getString("act.name");
        }
        if (!StringUtils.isEmpty((CharSequence)text)) {
            label = LabelFactory.create((boolean)true);
            label.setText(text);
        } else {
            label = TableHelper.createSpacer();
        }
        return label;
    }

    private boolean renderNewPrompt(CalendarTableModel model, int column) {
        int selected;
        boolean result = false;
        Cell cell = model.getSelected();
        if (cell != null && (selected = cell.getColumn()) == column) {
            result = true;
        }
        return result;
    }

    private void setStrikethroughFont(Component component, Table table) {
        Font font = this.getFont((Component)table);
        if (font != null) {
            int style = 17;
            font = new Font(font.getTypeface(), style, font.getSize());
            this.setFont(component, font);
        }
    }

    private void setFont(Component component, Font font) {
        for (Component child : component.getComponents()) {
            this.setFont(child, font);
        }
        component.setFont(font);
    }

    private void setForegroundFromBackground(Component component, Color background) {
        this.setForeground(component, ColourHelper.getTextColour((Color)background));
    }

    private void setForeground(Component component, Color colour) {
        if (component instanceof Row) {
            for (Component child : component.getComponents()) {
                this.setForeground(child, colour);
            }
        } else if (!(component instanceof PopUp)) {
            component.setForeground(colour);
        }
    }
}

