/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import echopointng.table.TableActionEventEx;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.CalendarService;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.im.query.DateNavigator;
import org.openvpms.web.component.im.query.DateSelector;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableEx;
import org.openvpms.web.echo.util.DoubleClickMonitor;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.calendar.CalendarGrid;
import org.openvpms.web.workspace.admin.calendar.CalendarGridView;
import org.openvpms.web.workspace.admin.calendar.CalendarListener;
import org.openvpms.web.workspace.admin.calendar.CalendarTableModel;
import org.openvpms.web.workspace.admin.calendar.DefaultCalendarGrid;
import org.openvpms.web.workspace.workflow.appointment.TimeRange;
import org.openvpms.web.workspace.workflow.appointment.TimeRangeSelector;

public class CalendarEventViewer {
    private final Entity calendar;
    private final CalendarService service;
    private final DoubleClickMonitor click = new DoubleClickMonitor();
    private final DateSelector navigator;
    private final TimeRangeSelector timeSelector;
    private final Label selectedDate;
    private Component component;
    private CalendarTableModel model;
    private TableEx table;
    private CalendarListener listener;

    public CalendarEventViewer(Entity calendar) {
        this.calendar = calendar;
        this.service = (CalendarService)ServiceHelper.getBean(CalendarService.class);
        this.navigator = new DateSelector();
        this.timeSelector = new TimeRangeSelector();
        this.selectedDate = LabelFactory.create(null, (String)"bold");
        this.navigator.setNavigator(DateNavigator.MONTH);
        ActionListener refresh = new ActionListener(){

            public void onAction(ActionEvent event) {
                CalendarEventViewer.this.refresh();
            }
        };
        this.navigator.setListener(refresh);
        this.timeSelector.addActionListener((nextapp.echo2.app.event.ActionListener)refresh);
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = SplitPaneFactory.create((int)5, (String)"Calendar.View", (Component[])new Component[0]);
            this.doLayout(this.component);
        }
        return this.component;
    }

    public void refresh() {
        if (this.component == null) {
            this.getComponent();
        } else {
            this.component.removeAll();
            this.doLayout(this.component);
        }
    }

    public void setListener(CalendarListener listener) {
        this.listener = listener;
    }

    private void doLayout(Component container) {
        Date startDate = this.navigator.getDate();
        int daysInMonth = DateRules.getDaysInMonth((Date)startDate);
        Date endDate = DateRules.getDate((Date)startDate, (int)daysInMonth, (DateUnits)DateUnits.DAYS);
        List events = this.service.getEvents(this.calendar, startDate, endDate);
        AppointmentRules rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
        CalendarGrid grid = new DefaultCalendarGrid(this.calendar, startDate, daysInMonth, events, rules);
        TimeRange range = this.timeSelector.getSelected();
        if (range != TimeRange.ALL) {
            grid = new CalendarGridView(grid, range.getStartMins(), range.getEndMins());
        }
        this.model = new CalendarTableModel(grid);
        this.table = new TableEx((TableModel)this.model, this.model.getColumnModel());
        this.table.setStyleName("ScheduleTable");
        this.table.setHeaderFixed(true);
        this.table.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                TableActionEventEx ex = (TableActionEventEx)event;
                CalendarEventViewer.this.onSelected(new Cell(ex.getColumn(), ex.getRow()));
            }
        });
        this.selectedDate.setText(Messages.format((String)"calendar.date", (Object[])new Object[]{startDate}));
        Row time = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"workflow.scheduling.show"), this.timeSelector});
        Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.navigator.getComponent(), time, this.selectedDate});
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{row}));
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.table}));
    }

    private void onSelected(Cell cell) {
        this.table.getSelectionModel().clearSelection();
        if (cell.getColumn() != 0) {
            this.model.setSelected(cell);
            if (this.listener != null && this.click.isDoubleClick((Object)cell)) {
                PropertySet event = this.model.getEvent(cell);
                if (event != null) {
                    IMObjectReference actRef = event.getReference("act.objectReference");
                    Act act = (Act)IMObjectHelper.getObject((Reference)actRef);
                    if (act != null) {
                        this.listener.edit(act);
                    } else {
                        this.refresh();
                    }
                } else {
                    this.listener.create(this.model.getDatetime(cell));
                }
            }
        }
    }
}

