/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.calendar.CalendarEventSeries;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class CalendarEventEditor
extends AbstractCalendarEventEditor {
    public CalendarEventEditor(Act act, IMObject parent, LayoutContext context) {
        this(act, parent, false, context);
    }

    public CalendarEventEditor(Act act, IMObject parent, boolean editSeries, LayoutContext context) {
        super(act, parent, editSeries, context);
        this.addStartEndTimeListeners();
    }

    public IMObjectEditor newInstance() {
        boolean editSeries = this.getSeriesEditor() != null;
        return new CalendarEventEditor((Act)this.reload((IMObject)this.getObject()), this.getParent(), editSeries, this.getLayoutContext());
    }

    @Override
    protected void calculateEndTime() {
        Date start = this.getStartTime();
        if (start != null) {
            Date end = DateRules.getDate((Date)start, (int)1, (DateUnits)DateUnits.HOURS);
            this.setEndTime(end);
        }
    }

    @Override
    protected int getSlotSize(Entity schedule) {
        return 15;
    }

    @Override
    protected ScheduleEventSeries createSeries() {
        return new CalendarEventSeries(this.getObject(), (IArchetypeService)ServiceHelper.getArchetypeService());
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new AbstractCalendarEventEditor.LayoutStrategy(this);
    }
}

