/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.layout.RowLayoutData;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.prefs.PreferenceMonitor;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.ContextListener;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.help.HelpDialog;
import org.openvpms.web.component.help.HelpTopics;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.Workspace;
import org.openvpms.web.component.workspace.Workspaces;
import org.openvpms.web.component.workspace.WorkspacesFactory;
import org.openvpms.web.echo.button.ButtonColumn;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.ContentPaneFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.pane.ContentPane;
import org.openvpms.web.echo.util.ApplicationInstanceRunnable;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.echo.util.TaskQueues;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.ContextChangeListener;
import org.openvpms.web.workspace.OpenVPMSApp;
import org.openvpms.web.workspace.history.CustomerPatient;
import org.openvpms.web.workspace.history.CustomerPatientHistoryBrowser;
import org.openvpms.web.workspace.workflow.messaging.messages.MessageMonitor;

public class MainPane
extends SplitPane
implements ContextChangeListener,
ContextListener {
    private final List<Workspaces> workspaces = new ArrayList<Workspaces>();
    private final PropertyChangeListener summaryRefresher;
    private final MessageMonitor monitor;
    private final MessageMonitor.MessageListener listener;
    private final GlobalContext context;
    private final UserPreferences preferences;
    private final PreferenceMonitor preferenceMonitor;
    private final ApplicationInstanceRunnable preferenceListener;
    private final ButtonRow menu;
    private final Column leftMenu;
    private final ButtonColumn subMenu;
    private final ContentPane currentWorkspaces;
    private final User user;
    private Component summary;
    private Workspace<?> currentWorkspace;
    private Button messages;
    private static final String STYLE = "MainPane";
    private static final String BUTTON_COLUMN_STYLE = "ControlColumn";
    private static final String BUTTON_STYLE = "MainPane.Menu.Button";
    private static final String WORKSPACE_STYLE = "MainPane.Workspace";
    private static final String LEFTPANE_STYLE = "MainPane.Left";
    private static final String RIGHTPANE_STYLE = "MainPane.Right";

    public MainPane(MessageMonitor monitor, GlobalContext context, WorkspacesFactory factory, UserPreferences preferences) {
        super(1);
        this.setStyleName(STYLE);
        this.monitor = monitor;
        this.context = context;
        this.preferences = preferences;
        this.preferenceMonitor = new PreferenceMonitor((Preferences)preferences);
        this.preferenceMonitor.add("entity.preferenceGroupSummary");
        this.listener = this::updateMessageStatus;
        this.user = context.getUser();
        this.summaryRefresher = event -> this.refreshSummary();
        OpenVPMSApp.getInstance().setContextChangeListener(this);
        this.menu = new ButtonRow("ButtonRow", BUTTON_STYLE);
        this.menu.setLayoutData((LayoutData)SplitPaneFactory.layout((Alignment)new Alignment(4, 0)));
        this.subMenu = new ButtonColumn(BUTTON_COLUMN_STYLE, BUTTON_STYLE);
        this.leftMenu = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.subMenu});
        this.currentWorkspaces = ContentPaneFactory.create((String)WORKSPACE_STYLE);
        this.preferenceListener = new ApplicationInstanceRunnable(0, TaskQueues.QueueMode.QUEUE_LAST, this::onPreferencesChanged);
        Button button = null;
        if (context.getPractice() != null) {
            button = this.addWorkspaces(factory.createCustomerWorkspaces((Context)context, (Preferences)preferences));
            this.addWorkspaces(factory.createPatientWorkspaces((Context)context, (Preferences)preferences));
            this.addWorkspaces(factory.createSupplierWorkspaces((Context)context));
            this.addWorkspaces(factory.createWorkflowWorkspaces((Context)context, (Preferences)preferences));
            this.addWorkspaces(factory.createProductWorkspaces((Context)context));
            this.addWorkspaces(factory.createReportingWorkspaces((Context)context, (Preferences)preferences));
        }
        context.addListener((ContextListener)this);
        if (UserHelper.isAdmin((User)this.user)) {
            Button admin = this.addWorkspaces(factory.createAdminWorkspaces((Context)context));
            if (button == null) {
                button = admin;
            }
        }
        this.menu.addButton("help", () -> {
            String features = StyleSheetHelper.getProperty((String)"HelpBrowser.features");
            HelpDialog dialog = new HelpDialog((HelpTopics)ServiceHelper.getBean(HelpTopics.class), (IArchetypeService)ServiceHelper.getArchetypeService(), features);
            dialog.show();
        });
        this.menu.add((Component)this.getManagementRow());
        SplitPane left = SplitPaneFactory.create((int)5, (String)LEFTPANE_STYLE, (Component[])new Component[0]);
        SplitPane right = SplitPaneFactory.create((int)5, (String)RIGHTPANE_STYLE, (Component[])new Component[0]);
        left.add((Component)new Label());
        left.add((Component)this.leftMenu);
        right.add((Component)this.menu);
        right.add((Component)this.currentWorkspaces);
        this.add((Component)left);
        this.add((Component)right);
        String homePage = preferences.getString("entity.preferenceGroupGeneral", "homePage", "customer.information");
        boolean found = false;
        if (homePage != null) {
            block0: for (Workspaces spaces : this.workspaces) {
                for (Workspace workspace : spaces.getWorkspaces()) {
                    if (!StringUtils.equals((CharSequence)workspace.getId(), (CharSequence)homePage)) continue;
                    found = true;
                    spaces.setWorkspace(workspace);
                    this.select(spaces);
                    continue block0;
                }
            }
        }
        if (!found && button != null) {
            button.doAction();
        }
    }

    public void init() {
        super.init();
        if (this.user != null) {
            this.monitor.addListener(this.user, this.listener);
        }
        this.preferences.addListener((Runnable)this.preferenceListener);
    }

    public void dispose() {
        super.dispose();
        this.context.removeListener((ContextListener)this);
        if (this.user != null) {
            this.monitor.removeListener(this.user, this.listener);
        }
        this.preferences.removeListener((Runnable)this.preferenceListener);
        this.preferenceListener.dispose();
    }

    @Override
    public void changeContext(IMObject context) {
        String shortName = context.getArchetype();
        for (Workspaces workspaces : this.workspaces) {
            Workspace workspace = workspaces.getWorkspaceForArchetype(shortName);
            if (workspace == null) continue;
            workspace.getComponent();
            workspace.update(context);
            workspaces.setWorkspace(workspace);
            this.select(workspaces);
            break;
        }
    }

    @Override
    public void changeContext(String shortName) {
        for (Workspaces workspaces : this.workspaces) {
            Workspace workspace = workspaces.getWorkspaceForArchetype(shortName);
            if (workspace == null) continue;
            workspace.getComponent();
            workspace.update(shortName);
            workspaces.setWorkspace(workspace);
            this.select(workspaces);
            break;
        }
    }

    public void changed(String key, IMObject value) {
        if (this.currentWorkspace != null && (value != null && this.currentWorkspace.canUpdate(value.getArchetype()) || this.currentWorkspace.canUpdate(key))) {
            this.currentWorkspace.update(value);
        }
    }

    protected ButtonRow getMenu() {
        return this.menu;
    }

    protected void select(Workspaces workspaces) {
        this.currentWorkspaces.removeAll();
        this.subMenu.removeAll();
        List list = workspaces.getWorkspaces();
        for (Workspace workspace : list) {
            Button button = this.subMenu.addButton(workspace.getTitleKey(), true, () -> this.select(workspaces, workspace));
            button.setFocusTraversalParticipant(false);
        }
        Workspace current = workspaces.getWorkspace();
        if (current == null) {
            current = workspaces.getDefaultWorkspace();
        }
        if (current != null) {
            this.select(workspaces, current);
        }
    }

    protected void select(Workspaces workspaces, Workspace<?> workspace) {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.removePropertyChangeListener("summary", this.summaryRefresher);
            this.currentWorkspace.hide();
            this.currentWorkspace = null;
        }
        workspaces.setWorkspace(workspace);
        this.currentWorkspaces.removeAll();
        this.currentWorkspaces.add(workspace.getComponent());
        this.currentWorkspace = workspace;
        this.refreshSummary();
        this.currentWorkspace.addPropertyChangeListener("summary", this.summaryRefresher);
        this.currentWorkspace.show();
    }

    protected Button addWorkspaces(Workspaces workspaces) {
        Button button = this.menu.addButton(workspaces.getTitleKey(), () -> this.select(workspaces));
        button.setFocusTraversalParticipant(false);
        this.workspaces.add(workspaces);
        return button;
    }

    private void onPreferencesChanged() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.preferencesChanged();
            if (this.preferenceMonitor.changed()) {
                this.refreshSummary();
            }
        }
    }

    private void updateMessageStatus() {
        boolean update = false;
        if (this.user != null) {
            Date since = DateRules.getDate((Date)DateRules.getToday(), (int)-1, (DateUnits)DateUnits.MONTHS);
            update = this.monitor.hasNewMessages(this.user, since);
        }
        this.updateMessageStatus(update);
    }

    private void updateMessageStatus(Act message) {
        if ("PENDING".equals(message.getStatus())) {
            this.updateMessageStatus(true);
        } else {
            this.updateMessageStatus();
        }
    }

    private void updateMessageStatus(boolean newMessages) {
        if (newMessages) {
            this.messages.setStyleName("button.unreadMail");
            this.messages.setToolTipText(Messages.get((String)"messages.unread.tooltip"));
        } else {
            this.messages.setStyleName("button.mail");
            this.messages.setToolTipText(Messages.get((String)"messages.read.tooltip"));
        }
    }

    private Row getManagementRow() {
        ButtonRow row = new ButtonRow(null, BUTTON_STYLE);
        this.messages = ButtonFactory.create(null, (String)BUTTON_STYLE, () -> ContextApplicationInstance.getInstance().switchTo("act.userMessage"));
        this.updateMessageStatus();
        row.addButton(this.messages);
        Button newWindow = ButtonFactory.create(null, (String)"button.newWindow", this::onNewWindow);
        newWindow.setToolTipText(Messages.get((String)"newwindow.tooltip"));
        row.addButton(newWindow);
        row.addButton("recent", this::showHistory);
        row.addButton("logout", this::onLogout);
        RowLayoutData rightAlign = new RowLayoutData();
        rightAlign.setAlignment(new Alignment(5, 0));
        rightAlign.setWidth(new Extent(100, 2));
        row.setLayoutData((LayoutData)rightAlign);
        return row;
    }

    private void refreshSummary() {
        this.leftMenu.remove(this.summary);
        this.summary = null;
        try {
            Component newSummary;
            Component component = newSummary = this.currentWorkspace != null ? this.currentWorkspace.getSummary() : null;
            if (newSummary != null) {
                this.summary = ColumnFactory.create((String)"Inset", (Component[])new Component[]{newSummary});
                this.leftMenu.add(this.summary);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private void onNewWindow() {
        OpenVPMSApp.getInstance().createWindow();
    }

    private void onLogout() {
        OpenVPMSApp app = OpenVPMSApp.getInstance();
        int count = app.getActiveWindowCount();
        String msg = count > 1 ? Messages.format((String)"logout.activewindows.message", (Object[])new Object[]{count}) : Messages.get((String)"logout.message");
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"logout.title"))).message(msg)).okCancel()).ok(this::doLogout)).show();
    }

    private void doLogout() {
        OpenVPMSApp app = OpenVPMSApp.getInstance();
        app.logout();
    }

    private void showHistory() {
        if (this.currentWorkspace != null) {
            DefaultLayoutContext layout = new DefaultLayoutContext((Context)this.context, this.currentWorkspace.getHelpContext());
            final CustomerPatientHistoryBrowser browser = new CustomerPatientHistoryBrowser(this.context, (LayoutContext)layout);
            BrowserDialog dialog = new BrowserDialog(Messages.get((String)"history.title"), (Browser)browser, layout.getHelpContext());
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    CustomerPatient selected = (CustomerPatient)browser.getSelected();
                    if (selected != null) {
                        MainPane.this.context.setCustomer(selected.getCustomer());
                        MainPane.this.context.setPatient(selected.getPatient());
                        Party party = browser.getSelectedParty();
                        if (party != null) {
                            if (MainPane.this.currentWorkspace != null && MainPane.this.currentWorkspace.canUpdate(party.getArchetype())) {
                                MainPane.this.currentWorkspace.update((IMObject)party);
                            } else {
                                MainPane.this.changeContext((IMObject)party);
                            }
                        }
                    }
                }
            });
            dialog.show();
        }
    }
}

