/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.workflow.worklist.DefaultTaskActEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultTaskActEditorTestCase
extends AbstractIMObjectEditorTest<DefaultTaskActEditor> {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Entity worklist;
    private Entity taskType;
    private User user;

    public DefaultTaskActEditorTestCase() {
        super(DefaultTaskActEditor.class, "act.customerTask");
    }

    @Before
    public void setUp() {
        super.setUp();
        this.taskType = this.schedulingFactory.createTaskType();
        this.user = this.userFactory.createClinician();
        this.worklist = (Entity)this.schedulingFactory.newWorkList().addTaskType(this.taskType, 100, false).build();
    }

    @Test
    public void testSave() {
        DefaultTaskActEditor editor = (DefaultTaskActEditor)this.newEditor(this.newObject());
        editor.getComponent();
        Assert.assertFalse((boolean)editor.isValid());
        editor.setCustomer(this.customerFactory.createCustomer());
        editor.setWorkList(this.worklist);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setTaskType(this.taskType);
        Assert.assertFalse((boolean)editor.isValid());
        editor.setStartTime(new Date());
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
    }

    @Test
    public void testDefaultStartTime() {
        LocalContext context = new LocalContext();
        Date now = DateUtils.truncate((Date)new Date(), (int)12);
        DefaultTaskActEditor editor1 = (DefaultTaskActEditor)this.newEditor(this.newObject(), (Context)context);
        Assert.assertNull((Object)editor1.getStartTime());
        context.setWorkListDate(DateRules.getToday());
        DefaultTaskActEditor editor2 = (DefaultTaskActEditor)this.newEditor(this.newObject(), (Context)context);
        Assert.assertTrue((DateRules.compareTo((Date)now, (Date)editor2.getStartTime()) <= 0 ? 1 : 0) != 0);
        context.setWorkListDate(DateRules.getTomorrow());
        DefaultTaskActEditor editor3 = (DefaultTaskActEditor)this.newEditor(this.newObject(), (Context)context);
        Assert.assertEquals((Object)DateRules.getTomorrow(), (Object)editor3.getStartTime());
        context.setWorkListDate(DateRules.getYesterday());
        DefaultTaskActEditor editor4 = (DefaultTaskActEditor)this.newEditor(this.newObject(), (Context)context);
        Assert.assertEquals((Object)DateRules.getYesterday(), (Object)editor4.getStartTime());
    }

    @Test
    public void testTimes() {
        DefaultTaskActEditor editor = this.createEditor();
        editor.getComponent();
        Date start = DateRules.getToday();
        editor.setStartTime(start);
        Date end = DateRules.getDate((Date)start, (int)-1, (DateUnits)DateUnits.MINUTES);
        editor.setEndTime(end);
        Assert.assertEquals((Object)editor.getEndTime(), (Object)start);
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
    }

    @Test
    public void testInheritance() {
        Party customer1 = this.customerFactory.createCustomer();
        Party customer2 = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer2);
        Entity worklist2 = this.schedulingFactory.createWorkList();
        LocalContext context = new LocalContext();
        context.setCustomer(customer1);
        context.setWorkList(this.worklist);
        context.setUser(this.user);
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        Act act1 = (Act)this.create("act.customerTask", Act.class);
        DefaultTaskActEditor editor1 = new DefaultTaskActEditor(act1, null, (LayoutContext)layout);
        editor1.getComponent();
        editor1.setStartTime(new Date());
        Assert.assertEquals((Object)customer1, (Object)editor1.getCustomer());
        Assert.assertEquals((Object)this.worklist, (Object)editor1.getWorkList());
        Assert.assertNull((Object)editor1.getPatient());
        editor1.setTaskType(this.taskType);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        context.setCustomer(customer2);
        context.setPatient(patient);
        context.setWorkList(worklist2);
        DefaultTaskActEditor editor2 = new DefaultTaskActEditor(act1, null, (LayoutContext)layout);
        editor2.getComponent();
        Assert.assertEquals((Object)customer1, (Object)editor2.getCustomer());
        Assert.assertEquals((Object)this.worklist, (Object)editor2.getWorkList());
        Assert.assertNull((Object)editor2.getPatient());
    }

    private DefaultTaskActEditor createEditor() {
        LocalContext context = new LocalContext();
        Party customer = this.customerFactory.createCustomer();
        context.setCustomer(customer);
        context.setWorkList(this.worklist);
        context.setUser(this.user);
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        Act act = (Act)this.create("act.customerTask", Act.class);
        return new DefaultTaskActEditor(act, null, (LayoutContext)layout);
    }
}

