/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleViewExpressionEditor;

public class ScheduleViewExpressionEditorTestCase
extends AbstractAppTest {
    @Test
    public void testNullExpression() {
        String expected = null;
        String expression = null;
        this.checkExpression(expected, expression, true);
        this.checkExpression(expected, expression, false);
    }

    @Test
    public void testLiteralExpression() {
        String expected = "abc";
        String expression = "'abc'";
        this.checkExpression(expected, expression, true);
        this.checkExpression(expected, expression, false);
    }

    @Test
    public void testComplexExpression() {
        String expected = "Customer name-Patient name";
        String expression = "concat(openvpms:get(.,'customer.name'),'-',openvpms:get(.,'patient.name'))";
        this.checkExpression(expected, expression, true);
        this.checkExpression(expected, expression, false);
    }

    @Test
    public void testScheduleWaitingTime() {
        SimpleProperty property = new SimpleProperty("expression", String.class);
        ScheduleViewExpressionEditor editor = new ScheduleViewExpressionEditor((Property)property, true);
        editor.getComponent();
        property.setValue((Object)"openvpms:get(., 'waiting')");
        Assert.assertEquals((Object)"", (Object)editor.evaluate());
        this.setStatus(editor, "CHECKED_IN");
        Assert.assertEquals((Object)"(0:00)", (Object)editor.evaluate());
        this.setStatus(editor, "BILLED");
        Assert.assertEquals((Object)"", (Object)editor.evaluate());
    }

    @Test
    public void testConsultWaitingTime() {
        SimpleProperty property = new SimpleProperty("expression", String.class);
        ScheduleViewExpressionEditor editor = new ScheduleViewExpressionEditor((Property)property, false);
        editor.getComponent();
        property.setValue((Object)"openvpms:get(., 'waiting')");
        Assert.assertEquals((Object)"(0:00)", (Object)editor.evaluate());
    }

    private void checkExpression(String expected, String expression, boolean scheduleView) {
        SimpleProperty property = new SimpleProperty("expression", String.class);
        ScheduleViewExpressionEditor editor = new ScheduleViewExpressionEditor((Property)property, scheduleView);
        editor.getComponent();
        property.setValue((Object)expression);
        Assert.assertEquals((Object)expected, (Object)editor.evaluate());
    }

    private void setStatus(ScheduleViewExpressionEditor editor, String status) {
        boolean found = false;
        for (Property property : editor.getProperties()) {
            if (!property.getName().equals("act.status")) continue;
            found = true;
            property.setValue((Object)status);
            break;
        }
        Assert.assertTrue((boolean)found);
    }
}

