/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.query.AbstractQueryTest;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.workspace.workflow.messaging.sms.AbstractSMSQuery;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSMSQueryTest
extends AbstractQueryTest<Act> {
    @Autowired
    protected TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testQueryByLocation() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2, location3}).build(false);
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1, location2}).build();
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        context.setUser(user);
        AbstractSMSQuery query = this.createQuery((Context)context);
        Act sms1 = this.createSMS(location1);
        Act sms2 = this.createSMS(location2);
        Act sms3 = this.createSMS(location3);
        Act sms4 = this.createSMS(null);
        query.setLocation(null);
        this.checkSelects(true, (Query)query, (IMObject)sms1);
        this.checkSelects(true, (Query)query, (IMObject)sms2);
        this.checkSelects(false, (Query)query, (IMObject)sms3);
        this.checkSelects(true, (Query)query, (IMObject)sms4);
        query.setLocation(location1);
        this.checkSelects(true, (Query)query, (IMObject)sms1);
        this.checkSelects(false, (Query)query, (IMObject)sms2);
        this.checkSelects(false, (Query)query, (IMObject)sms3);
        this.checkSelects(true, (Query)query, (IMObject)sms4);
        query.setLocation(location2);
        this.checkSelects(false, (Query)query, (IMObject)sms1);
        this.checkSelects(true, (Query)query, (IMObject)sms2);
        this.checkSelects(false, (Query)query, (IMObject)sms3);
        this.checkSelects(true, (Query)query, (IMObject)sms4);
    }

    @Test
    public void testQueryByLocationAndContact() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2}).build(false);
        String name1 = this.getUniqueValue();
        String name2 = this.getUniqueValue();
        Act sms1 = this.createSMS(name1, location1);
        Act sms2 = this.createSMS(name1, location2);
        Act sms3 = this.createSMS(name1, null);
        Act sms4 = this.createSMS(name2, location1);
        Act sms5 = this.createSMS(name2, location2);
        Act sms6 = this.createSMS(name2, null);
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        AbstractSMSQuery query = this.createQuery((Context)context);
        query.getComponent();
        query.setLocation(null);
        query.setValue(name1);
        this.checkSelects(true, (Query)query, (IMObject)sms1);
        this.checkSelects(true, (Query)query, (IMObject)sms2);
        this.checkSelects(true, (Query)query, (IMObject)sms3);
        this.checkSelects(false, (Query)query, (IMObject)sms4);
        this.checkSelects(false, (Query)query, (IMObject)sms5);
        this.checkSelects(false, (Query)query, (IMObject)sms6);
        query.setLocation(location1);
        this.checkSelects(true, (Query)query, (IMObject)sms1);
        this.checkSelects(false, (Query)query, (IMObject)sms2);
        this.checkSelects(true, (Query)query, (IMObject)sms3);
        this.checkSelects(false, (Query)query, (IMObject)sms4);
        this.checkSelects(false, (Query)query, (IMObject)sms5);
        this.checkSelects(false, (Query)query, (IMObject)sms6);
        query.setLocation(location2);
        this.checkSelects(false, (Query)query, (IMObject)sms1);
        this.checkSelects(true, (Query)query, (IMObject)sms2);
        this.checkSelects(true, (Query)query, (IMObject)sms3);
        this.checkSelects(false, (Query)query, (IMObject)sms4);
        this.checkSelects(false, (Query)query, (IMObject)sms5);
        this.checkSelects(false, (Query)query, (IMObject)sms6);
    }

    protected AbstractSMSQuery createQuery() {
        return this.createQuery((Context)new LocalContext());
    }

    protected abstract AbstractSMSQuery createQuery(Context var1);

    protected abstract Act createObject(String var1, boolean var2);

    protected String getUniqueValue() {
        String value = this.getUniqueValue("Z");
        return value.length() <= 30 ? value : value.substring(0, 30);
    }

    protected Act createSMS(Party location) {
        return this.createSMS(this.getUniqueValue(), location);
    }

    protected abstract Act createSMS(String var1, Party var2);
}

