/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.message.MessageArchetypes;
import org.openvpms.archetype.test.builder.message.TestMessageFactory;
import org.openvpms.archetype.test.builder.message.TestUserMessageBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.workflow.messaging.messages.MessagingCRUDWindow;
import org.openvpms.web.workspace.workflow.messaging.messages.UserMessageEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class MessagingCRUDWindowTestCase
extends AbstractAppTest {
    @Autowired
    private TestMessageFactory messageFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testReply() {
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createUser();
        AuthenticationContextImpl authenticationContext = new AuthenticationContextImpl();
        authenticationContext.setUser(user1);
        Act message = (Act)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)this.messageFactory.newUserMessage().to(user2)).subject("test")).message("text")).reason("PHONE_CALL")).build();
        Assert.assertEquals((Object)user1.getObjectReference(), (Object)message.getCreatedBy());
        authenticationContext.setUser(user2);
        LocalContext context = new LocalContext();
        context.setUser(user2);
        MessagingCRUDWindow window = this.createCRUDWindow((Context)context);
        window.setObject((IMObject)message);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"reply");
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        Assert.assertEquals((Object)"Reply To Message", (Object)dialog.getTitle());
        UserMessageEditor editor = (UserMessageEditor)dialog.getEditor();
        Assert.assertEquals((Object)user1, (Object)editor.getTo());
        Assert.assertEquals((Object)"Re: test", (Object)editor.getSubject());
        EditorTestHelper.assertValid((Modifiable)editor);
        List<Act> replies1 = this.getMessages(user2, user1);
        Assert.assertEquals((long)0L, (long)replies1.size());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"send");
        List<Act> replies = this.getMessages(user2, user1);
        Assert.assertEquals((long)1L, (long)replies.size());
    }

    @Test
    public void testForward() {
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createUser();
        User user3 = this.userFactory.createUser();
        AuthenticationContextImpl authenticationContext = new AuthenticationContextImpl();
        authenticationContext.setUser(user1);
        Act message = (Act)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)this.messageFactory.newUserMessage().to(user2)).subject("test")).message("text")).reason("PHONE_CALL")).build();
        Assert.assertEquals((Object)user1.getObjectReference(), (Object)message.getCreatedBy());
        authenticationContext.setUser(user2);
        LocalContext context = new LocalContext();
        context.setUser(user2);
        MessagingCRUDWindow window = this.createCRUDWindow((Context)context);
        window.setObject((IMObject)message);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"forward");
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        Assert.assertEquals((Object)"Forward Message", (Object)dialog.getTitle());
        UserMessageEditor editor = (UserMessageEditor)dialog.getEditor();
        Act forwarded = editor.getObject();
        Assert.assertTrue((boolean)forwarded.isNew());
        Assert.assertEquals((Object)user2, (Object)editor.getFrom());
        Assert.assertNull((Object)editor.getTo());
        Assert.assertTrue((boolean)editor.getToUsers().isEmpty());
        Assert.assertTrue((boolean)editor.getMessage().contains("-------- Original Message --------"));
        editor.setTo(user3);
        EditorTestHelper.assertValid((Modifiable)editor);
        List<Act> acts1 = this.getMessages(user2, user3);
        Assert.assertEquals((long)0L, (long)acts1.size());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"send");
        Assert.assertTrue((boolean)editor.getObject().isNew());
        List<Act> acts2 = this.getMessages(user2, user3);
        Assert.assertEquals((long)1L, (long)acts2.size());
    }

    private MessagingCRUDWindow createCRUDWindow(Context context) {
        Archetypes archetypes = Archetypes.create((Collection)MessageArchetypes.MESSAGES, Act.class);
        return new MessagingCRUDWindow(archetypes, context, new HelpContext("foo", null));
    }

    private List<Act> getMessages(User fromUser, User toUser) {
        IArchetypeService service = this.getArchetypeService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{"act.userMessage"});
        Join to = root.join("to");
        to.on((Expression)builder.equal((Expression)to.get("entity"), (Object)toUser.getObjectReference()));
        query.where((Expression)builder.equal((Expression)root.get("from"), (Object)fromUser.getObjectReference()));
        return service.createQuery(query).getResultList();
    }
}

