/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.junit.Assert;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.print.BatchPrintDialog;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.workflow.FinancialWorkflowRunner;
import org.openvpms.web.workspace.workflow.checkout.CheckOutWorkflow;
import org.openvpms.web.workspace.workflow.checkout.CheckoutChargeEditor;
import org.openvpms.web.workspace.workflow.checkout.CheckoutEditInvoiceTask;
import org.openvpms.web.workspace.workflow.checkout.InvoiceViewerDialog;
import org.openvpms.web.workspace.workflow.checkout.PaymentEditTask;
import org.openvpms.web.workspace.workflow.checkout.PrintDocumentsTask;
import org.openvpms.web.workspace.workflow.checkout.Visit;
import org.openvpms.web.workspace.workflow.checkout.Visits;

class CheckoutWorkflowRunner
extends FinancialWorkflowRunner<CheckOutWorkflow> {
    private final Date endTime;
    private final String status;
    private Act act;

    public CheckoutWorkflowRunner(Act act, Party practice, Context context) {
        super(practice);
        context.setPractice(practice);
        this.act = act;
        this.endTime = act.getActivityEndTime();
        this.status = act.getStatus();
        this.setWorkflow(new TestWorkflow(act, context, new HelpContext("foo", null)));
    }

    public InvoiceViewerDialog getInvoiceViewerDialog() {
        return this.findDialog(InvoiceViewerDialog.class);
    }

    public void confirmPostInvoice() {
        this.confirm(Messages.get((String)"workflow.checkout.postinvoice.title"), "yes");
    }

    public FinancialAct getPayment() {
        return (FinancialAct)this.getContext().getObject("act.customerAccountPayment");
    }

    public void confirmPayment() {
        this.confirm(Messages.get((String)"workflow.payment.payaccount.title"), "yes");
    }

    public BigDecimal runToPayment(Party patient, User clinician) {
        BigDecimal amount = this.addInvoice(patient, false);
        this.confirmPostInvoice();
        this.checkInvoice("POSTED", amount, clinician);
        this.confirmPayment();
        return amount;
    }

    public void runToPrint(Party patient, User clinician, Entity till) {
        BigDecimal amount = this.runToPayment(patient, clinician);
        this.addPayment(till);
        this.checkPayment("POSTED", amount);
        Task task = this.getTask();
        Assert.assertTrue((boolean)(task instanceof PrintDocumentsTask));
    }

    public void runToCompletion(Party patient, User clinician, Entity till) {
        this.runToPrint(patient, clinician, till);
        this.print();
    }

    public void skipPayment() {
        this.confirm(Messages.get((String)"workflow.payment.payaccount.title"), "no");
    }

    public void addPayment(Entity till) {
        EditDialog dialog = this.addPaymentItem(till);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
    }

    public EditDialog addPaymentItem(Entity till) {
        EditDialog dialog = this.getPaymentEditDialog();
        CustomerPaymentEditor paymentEditor = (CustomerPaymentEditor)dialog.getEditor();
        paymentEditor.setTill(till);
        paymentEditor.getUnsavedItem("act.customerAccountPaymentCash");
        return dialog;
    }

    public void print() {
        Task task = this.getTask();
        Assert.assertTrue((boolean)(task instanceof PrintDocumentsTask));
        BatchPrintDialog print = ((PrintDocumentsTask)task).getPrintDialog();
        EchoTestHelper.fireDialogButton((PopupDialog)print, (String)"skip");
    }

    public void checkContext(Context context, Party customer, Party patient, Entity till, User clinician) {
        Assert.assertEquals((Object)patient, (Object)context.getPatient());
        Assert.assertEquals((Object)customer, (Object)context.getCustomer());
        Assert.assertEquals((Object)till, (Object)context.getTill());
        Assert.assertEquals((Object)clinician, (Object)context.getClinician());
    }

    public void checkComplete(boolean statusUpdated) {
        Assert.assertNull((Object)this.getTask());
        boolean isTask = this.act.isA("act.customerTask");
        if (isTask) {
            Assert.assertNull((Object)this.endTime);
        }
        this.act = this.get(this.act);
        if (statusUpdated) {
            this.checkVisitsCompleted();
            Assert.assertEquals((Object)"COMPLETED", (Object)this.act.getStatus());
            if (isTask) {
                Assert.assertNotNull((Object)this.act.getActivityEndTime());
            }
        } else {
            Assert.assertEquals((Object)this.status, (Object)this.act.getStatus());
            if (isTask) {
                Assert.assertNull((Object)this.act.getActivityEndTime());
            }
        }
    }

    public void checkAppointmentComplete(Act appointment) {
        appointment = this.get(appointment);
        Assert.assertNotNull((Object)appointment);
        Assert.assertEquals((Object)"COMPLETED", (Object)appointment.getStatus());
    }

    public void checkVisitsCompleted() {
        List<Act> visits = this.getVisits();
        Assert.assertFalse((boolean)visits.isEmpty());
        for (Act visit : visits) {
            Assert.assertEquals((Object)"COMPLETED", (Object)visit.getStatus());
            Assert.assertNotNull((Object)visit.getActivityEndTime());
            Assert.assertTrue((visit.getActivityStartTime().compareTo(visit.getActivityEndTime()) <= 0 ? 1 : 0) != 0);
        }
    }

    public List<Act> getVisits() {
        Visits visits = ((CheckOutWorkflow)this.getWorkflow()).getVisits();
        return IterableUtils.toList((Iterable)IterableUtils.transformedIterable((Iterable)visits, Visit::getEvent));
    }

    public FinancialAct checkPayment(String status, BigDecimal amount) {
        FinancialAct act = this.get(this.getPayment());
        Assert.assertEquals((Object)status, (Object)act.getStatus());
        TestHelper.checkEquals((BigDecimal)amount, (BigDecimal)act.getTotal());
        ActCalculator calc = new ActCalculator((ArchetypeService)ServiceHelper.getArchetypeService());
        BigDecimal itemTotal = calc.sum((Act)act, "items", "amount");
        TestHelper.checkEquals((BigDecimal)amount, (BigDecimal)itemTotal);
        return act;
    }

    public void checkPayment(String status, BigDecimal amount, Party location) {
        FinancialAct act = this.checkPayment(status, amount);
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        Assert.assertEquals((Object)location, (Object)bean.getTarget("location"));
    }

    private EditDialog getPaymentEditDialog() {
        Task task = this.getTask();
        Assert.assertTrue((boolean)(task instanceof PaymentEditTask));
        PaymentEditTask paymentTask = (PaymentEditTask)task;
        return paymentTask.getEditDialog();
    }

    private static class TestWorkflow
    extends CheckOutWorkflow {
        public TestWorkflow(Act act, Context context, HelpContext help) {
            super(act, context, help);
        }

        protected CheckoutEditInvoiceTask createChargeTask(Visits visits) {
            return new CheckoutEditInvoiceTask(visits){

                protected IMObjectEditor createEditor(IMObject object, TaskContext context) {
                    LayoutContext layout = 1.createProtectedLocationLayoutContext((TaskContext)context);
                    return new CheckoutChargeEditor((FinancialAct)object, this.getVisits(), layout, false);
                }
            };
        }
    }
}

