/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDateEditor;

public class RepeatOnDateEditorTestCase
extends AbstractRepeatExpressionTest {
    @Test
    public void testCreateWithStartTime() {
        Date startTime = TestHelper.getDatetime((String)"2015-01-02 09:30:00");
        RepeatOnDateEditor editor = new RepeatOnDateEditor(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertTrue((boolean)(expression instanceof CronRepeatExpression));
        CronRepeatExpression cron = (CronRepeatExpression)expression;
        Assert.assertEquals((Object)"9", (Object)cron.getHours());
        Assert.assertEquals((Object)"30", (Object)cron.getMinutes());
        Assert.assertTrue((boolean)cron.getDayOfMonth().singleDay());
        Assert.assertEquals((long)2L, (long)cron.getDayOfMonth().day());
        Assert.assertEquals((long)1L, (long)cron.getMonth().month());
        Assert.assertTrue((boolean)cron.getDayOfWeek().isAll());
        Assert.assertEquals((long)2015L, (long)cron.getYear().year());
        Assert.assertEquals((Object)"0 30 9 2 1 ? 2015/1", (Object)cron.getExpression());
        Date date1 = this.checkNext(startTime, (RepeatExpression)cron, "2016-01-02 09:30:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)cron, "2017-01-02 09:30:00");
        this.checkNext(date2, (RepeatExpression)cron, "2018-01-02 09:30:00");
    }

    @Test
    public void testCreateWithExpression() {
        CronRepeatExpression cron = this.parse("0 30 9 2 1 ? 2015/2");
        Assert.assertTrue((boolean)RepeatOnDateEditor.supports((CronRepeatExpression)cron));
        RepeatOnDateEditor editor = new RepeatOnDateEditor(cron);
        Date startTime = TestHelper.getDatetime((String)"2015-01-02 09:30:00");
        editor.setStartTime(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertEquals((Object)cron, (Object)expression);
        Date date1 = this.checkNext(startTime, expression, "2017-01-02 09:30:00");
        Date date2 = this.checkNext(date1, expression, "2019-01-02 09:30:00");
        this.checkNext(date2, expression, "2021-01-02 09:30:00");
    }
}

