/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.AppointmentSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testNewInstance() {
        Date start = DateRules.getToday();
        Date end = DateRules.getTomorrow();
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        Act appointment = ScheduleTestHelper.createAppointment((Date)start, (Date)end, (Entity)schedule);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        AppointmentEditor editor = new AppointmentEditor(appointment, null, (LayoutContext)context);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof AppointmentEditor));
    }

    @Test
    public void testGetEventTimes() {
        Date start = DateRules.getToday();
        Date end = DateRules.getTomorrow();
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.practiceFactory.createLocation());
        Act appointment = ScheduleTestHelper.createAppointment((Date)start, (Date)end, (Entity)schedule);
        AppointmentSeries series = new AppointmentSeries(appointment, this.getArchetypeService());
        series.setExpression(Repeats.daily());
        series.setCondition(Repeats.twice());
        series.save();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        AppointmentEditor editor1 = new AppointmentEditor(appointment, null, true, (LayoutContext)context);
        List times1 = editor1.getEventTimes();
        Assert.assertNotNull((Object)times1);
        Assert.assertEquals((long)3L, (long)times1.size());
        AppointmentEditor editor2 = new AppointmentEditor(appointment, null, false, (LayoutContext)context);
        List times2 = editor2.getEventTimes();
        Assert.assertNotNull((Object)times2);
        Assert.assertEquals((long)1L, (long)times2.size());
        Assert.assertEquals((long)appointment.getId(), (long)((Times)times2.get(0)).getId());
        Assert.assertEquals((Object)appointment.getActivityStartTime(), (Object)((Times)times2.get(0)).getStartTime());
        Assert.assertEquals((Object)appointment.getActivityEndTime(), (Object)((Times)times2.get(0)).getEndTime());
    }

    @Test
    public void testFactory() {
        Act appointment = (Act)this.create("act.customerAppointment", Act.class);
        IMObjectEditor editor = this.factory.create((IMObject)appointment, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof AppointmentEditor));
    }

    @Test
    public void testChangeCustomerAndPatient() {
        Act appointment = (Act)this.create("act.customerAppointment", Act.class);
        Entity type = this.schedulingFactory.createAppointmentType();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).addAppointmentType(type, 1, true).slotSize(15, DateUnits.MINUTES).build();
        Party customer1 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient((Party)customer1);
        Party customer2 = TestHelper.createCustomer();
        AppointmentEditor editor = this.createEditor(appointment);
        editor.setSchedule(schedule);
        editor.setAppointmentType(type);
        editor.setStartTime(DateRules.getToday());
        editor.setCustomer(customer1);
        Assert.assertTrue((boolean)editor.isValid());
        editor.setPatient(patient1);
        Assert.assertTrue((boolean)editor.isValid());
        editor.setCustomer(customer2);
        Assert.assertNull((Object)editor.getPatient());
        Assert.assertTrue((boolean)editor.isValid());
        editor.setPatient(patient1);
        Assert.assertEquals((Object)customer1, (Object)editor.getCustomer());
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testDefaultAppointmentReason() {
        for (Lookup lookup : this.getLookupService().getLookups(ScheduleArchetypes.VISIT_REASONS)) {
            if (!lookup.isDefaultLookup()) continue;
            lookup = (Lookup)this.get((IMObject)lookup);
            lookup.setDefaultLookup(false);
            this.save((IMObject)lookup);
        }
        Lookup checkup = this.lookupFactory.createLookup(ScheduleArchetypes.VISIT_REASON, "CHECKUP", true);
        Act appointment = (Act)this.create("act.customerAppointment", Act.class);
        Entity appointmentType1 = (Entity)this.schedulingFactory.newAppointmentType().reason("FOO").build();
        Entity appointmentType2 = this.schedulingFactory.createAppointmentType();
        Entity appointmentType3 = this.schedulingFactory.createAppointmentType();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).addAppointmentType(appointmentType1, 1, true).addAppointmentType(appointmentType2, 1, false).addAppointmentType(appointmentType3, 1, false).slotSize(15, DateUnits.MINUTES).build();
        AppointmentEditor editor = this.createEditor(appointment);
        Assert.assertNull((Object)editor.getAppointmentType());
        Assert.assertEquals((Object)"CHECKUP", (Object)editor.getReason());
        editor.setSchedule(schedule);
        editor.setAppointmentType(appointmentType1);
        Assert.assertEquals((Object)"FOO", (Object)editor.getReason());
        editor.setAppointmentType(appointmentType2);
        Assert.assertEquals((Object)"FOO", (Object)editor.getReason());
        editor.setReason(null);
        editor.setAppointmentType(appointmentType3);
        Assert.assertEquals((Object)"CHECKUP", (Object)editor.getReason());
        editor.setAppointmentType(appointmentType1);
        Assert.assertEquals((Object)"FOO", (Object)editor.getReason());
        editor.setReason(null);
        editor.setAppointmentType(appointmentType2);
        Assert.assertEquals((Object)"CHECKUP", (Object)editor.getReason());
        checkup.setDefaultLookup(false);
        this.save((IMObject)checkup);
        editor.setAppointmentType(appointmentType1);
        Assert.assertEquals((Object)"FOO", (Object)editor.getReason());
        editor.setAppointmentType(appointmentType2);
        Assert.assertEquals((Object)"FOO", (Object)editor.getReason());
    }

    @Test
    public void testCustomerPatientReadOnly() {
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).addAppointmentType(appointmentType, 1, true).slotSize(15, DateUnits.MINUTES).build();
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        Act appointment1 = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(DateRules.getToday())).customer(customer)).patient(patient)).schedule(schedule).appointmentType(appointmentType).status("PENDING")).build(false);
        AppointmentEditor editor1 = this.createEditor(appointment1);
        Assert.assertFalse((boolean)editor1.makeCustomerPatientReadOnly());
        ((TestAppointmentBuilder)this.schedulingFactory.updateAppointment(appointment1).status("CONFIRMED")).build();
        AppointmentEditor editor2 = this.createEditor(appointment1);
        Assert.assertFalse((boolean)editor2.makeCustomerPatientReadOnly());
        Act visit = (Act)((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).build();
        this.schedulingFactory.updateAppointment(appointment1).event(visit).build();
        AppointmentEditor editor3 = this.createEditor(appointment1);
        Assert.assertTrue((boolean)editor3.makeCustomerPatientReadOnly());
        Entity workList = this.schedulingFactory.createWorkList();
        Act task = (Act)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)this.schedulingFactory.newTask().status("PENDING")).startTime(new Date())).endTime(new Date())).taskType(this.schedulingFactory.createTaskType()).customer(customer)).workList(workList).build();
        Act appointment2 = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(DateRules.getToday())).customer(customer)).patient(patient)).schedule(schedule).appointmentType(appointmentType).status("CHECKED_IN")).build();
        AppointmentEditor editor4 = this.createEditor(appointment2);
        Assert.assertFalse((boolean)editor4.makeCustomerPatientReadOnly());
        this.schedulingFactory.updateAppointment(appointment2).task(task).build();
        AppointmentEditor editor5 = this.createEditor(appointment2);
        Assert.assertTrue((boolean)editor5.makeCustomerPatientReadOnly());
    }

    private AppointmentEditor createEditor(Act appointment) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        AppointmentEditor editor = new AppointmentEditor(appointment, null, (LayoutContext)context);
        editor.getComponent();
        return editor;
    }
}

