/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow;

import java.math.BigDecimal;
import org.junit.Assert;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;
import org.openvpms.web.workspace.patient.charge.VisitChargeItemEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditorDialog;
import org.openvpms.web.workspace.workflow.TestEditVisitTask;
import org.openvpms.web.workspace.workflow.TestVisitChargeEditor;
import org.openvpms.web.workspace.workflow.WorkflowRunner;

public abstract class FinancialWorkflowRunner<T extends WorkflowImpl>
extends WorkflowRunner<T> {
    private final Party practice;

    public FinancialWorkflowRunner(Party practice) {
        this.practice = practice;
    }

    public FinancialAct getInvoice() {
        return (FinancialAct)this.getContext().getObject("act.customerAccountChargesInvoice");
    }

    public EditDialog addInvoiceItem(Party patient, BigDecimal fixedPrice) {
        Product product = (Product)((TestServiceProductBuilder)new TestServiceProductBuilder((ArchetypeService)ServiceHelper.getArchetypeService()).fixedPrice(fixedPrice)).build();
        return this.addInvoiceItem(patient, product);
    }

    public EditDialog addInvoiceItem(Party patient, Product product) {
        EditIMObjectTask task = this.getEditTask();
        EditDialog dialog = task.getEditDialog();
        CustomerChargeActEditor editor = (CustomerChargeActEditor)dialog.getEditor();
        ChargeItemRelationshipCollectionEditor items = editor.getItems();
        CustomerChargeTestHelper.addItem(editor, patient, product, BigDecimal.ONE, items.getEditorQueue());
        return dialog;
    }

    public CustomerChargeActEditor getChargeEditor() {
        EditIMObjectTask task = this.getEditTask();
        EditDialog dialog = task.getEditDialog();
        return (CustomerChargeActEditor)dialog.getEditor();
    }

    public BigDecimal addInvoice(Party patient, boolean post) {
        BigDecimal fixedPrice = new BigDecimal("18.18");
        EditDialog dialog = this.addInvoiceItem(patient, fixedPrice);
        if (post) {
            CustomerChargeActEditor editor = (CustomerChargeActEditor)dialog.getEditor();
            editor.setStatus("POSTED");
        }
        this.fireDialogButton((PopupDialog)dialog, "ok");
        return this.getInvoice().getTotal();
    }

    public void checkInvoice(String status, BigDecimal amount, User clinician) {
        FinancialAct act = this.get(this.getInvoice());
        Assert.assertEquals((Object)act.getStatus(), (Object)status);
        TestHelper.checkEquals((BigDecimal)amount, (BigDecimal)act.getTotal());
        ActCalculator calc = new ActCalculator((ArchetypeService)ServiceHelper.getArchetypeService());
        BigDecimal itemTotal = calc.sum((Act)act, "items", "total");
        TestHelper.checkEquals((BigDecimal)amount, (BigDecimal)itemTotal);
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)act);
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
    }

    public CustomerChargeActItemEditor addVisitInvoiceItem(Party patient, BigDecimal fixedPrice) {
        Product product = (Product)((TestServiceProductBuilder)new TestServiceProductBuilder((ArchetypeService)ServiceHelper.getArchetypeService()).fixedPrice(fixedPrice)).build();
        return this.addVisitInvoiceItem(patient, product);
    }

    public VisitEditorDialog getVisitEditorDialog() {
        TestEditVisitTask task = (TestEditVisitTask)this.getTask();
        return task.getVisitDialog();
    }

    public VisitChargeItemEditor addVisitInvoiceItem(Party patient, Product product) {
        TestEditVisitTask task = (TestEditVisitTask)this.getTask();
        VisitEditorDialog dialog = task.getVisitDialog();
        VisitEditor visitEditor = dialog.getEditor();
        VisitChargeEditor editor = visitEditor.getChargeEditor();
        Assert.assertNotNull((Object)editor);
        return (VisitChargeItemEditor)CustomerChargeTestHelper.addItem((CustomerChargeActEditor)editor, patient, product, BigDecimal.ONE, task.getQueue());
    }

    public VisitChargeItemEditor getVisitItemEditor() {
        TestEditVisitTask task = (TestEditVisitTask)this.getTask();
        VisitEditorDialog dialog = task.getVisitDialog();
        VisitEditor visitEditor = dialog.getEditor();
        TestVisitChargeEditor editor = (TestVisitChargeEditor)visitEditor.getChargeEditor();
        Assert.assertNotNull((Object)editor);
        return (VisitChargeItemEditor)editor.getItems().getCurrentEditor();
    }

    protected Party getPractice() {
        return this.practice;
    }
}

