/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.vet;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.supplier.vet.VetResultSet;

public class VetResultSetTestCase
extends AbstractAppTest {
    @Test
    public void testResultSet() {
        Party practice = (Party)this.create("party.supplierVeterinaryPractice", Party.class);
        practice.setName("ZVetPractice");
        Party vet1 = this.createVet("ZC", practice);
        Party vet2 = this.createVet("ZA", practice);
        Party vet3 = this.createVet("ZB", practice);
        SortConstraint[] sort = new SortConstraint[]{Constraints.sort((String)"name")};
        VetResultSet set = new VetResultSet(Constraints.shortName((String)"party.supplierVeterinarian"), "*", false, sort, 20, true);
        this.checkOrder(set, vet2, vet3, vet1);
    }

    private void checkOrder(VetResultSet resultSet, Party ... expected) {
        int index = 0;
        ResultSetIterator iterator = new ResultSetIterator((ResultSet)resultSet);
        Assert.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            Party vet = expected[index];
            if (!vet.getObjectReference().equals((Object)set.getReference("entity.reference"))) continue;
            Assert.assertEquals((Object)vet.getName(), (Object)set.getString("entity.name"));
            Assert.assertEquals((Object)vet.getDescription(), (Object)set.getString("entity.description"));
            IMObjectBean bean = this.getBean((IMObject)vet);
            Entity practice = (Entity)bean.getSource("practices", Entity.class);
            Assert.assertNotNull((Object)practice);
            Assert.assertEquals((Object)practice.getName(), (Object)set.getString("practice.name"));
            if (++index != expected.length) continue;
            break;
        }
        Assert.assertEquals((long)expected.length, (long)index);
    }

    private Party createVet(String name, Party practice) {
        Party vet = (Party)this.create("party.supplierVeterinarian", Party.class);
        IMObjectBean bean = this.getBean((IMObject)vet);
        bean.setValue("firstName", (Object)"A");
        bean.setValue("lastName", (Object)name);
        bean.setValue("title", (Object)TestHelper.getLookup((String)"lookup.personTitle", (String)"MR").getCode());
        IMObjectBean practiceBean = this.getBean((IMObject)practice);
        practiceBean.addTarget("veterinarians", (IMObject)vet, "practices");
        this.save((IMObject[])new Party[]{vet, practice});
        return vet;
    }
}

