/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryItemVerifier;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryVerifier;
import org.openvpms.archetype.test.builder.supplier.delivery.TestReturnBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderItemBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.supplier.delivery.DeliveryEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class DeliveryEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    private Context context;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        Party practice = this.practiceFactory.getPractice();
        this.context.setPractice(practice);
    }

    @Test
    public void testFactory() {
        Party supplier = this.supplierFactory.createSupplier();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        IMObjectEditor editor1 = this.factory.create((IMObject)this.createDelivery(supplier, stockLocation), (LayoutContext)layoutContext);
        Assert.assertTrue((boolean)(editor1 instanceof DeliveryEditor));
        IMObjectEditor editor2 = this.factory.create((IMObject)this.createReturn(supplier, stockLocation), (LayoutContext)layoutContext);
        Assert.assertTrue((boolean)(editor2 instanceof DeliveryEditor));
    }

    @Test
    public void testNewInstance() {
        Party supplier = this.supplierFactory.createSupplier();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        FinancialAct delivery = this.createDelivery(supplier, stockLocation);
        DeliveryEditor editor = this.createEditor(delivery);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof DeliveryEditor));
        Assert.assertEquals((Object)delivery, (Object)newInstance.getObject());
    }

    @Test
    public void testCreateDeliveryFromOrder() {
        Party supplier = this.supplierFactory.createSupplier();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMerchandise();
        TestOrderBuilder builder = (TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).status("POSTED")).item().product(product1)).reorderCode("1")).reorderDescription("1 desc")).quantity(1)).packageSize(10)).packageUnits("BOX")).unitPrice(1)).add()).item().product(product2)).reorderCode("2")).packageUnits("EACH")).reorderDescription("2 desc")).quantity(2)).packageSize(1)).unitPrice(2)).add();
        FinancialAct order = (FinancialAct)builder.build();
        this.checkEquals(5, order.getTotal());
        FinancialAct delivery = this.createDelivery(supplier, stockLocation);
        DeliveryEditor editor = this.createEditor(delivery);
        List orderItems = builder.getItems();
        Assert.assertEquals((long)2L, (long)orderItems.size());
        for (FinancialAct orderItem : orderItems) {
            editor.createItem(orderItem);
        }
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        delivery = (FinancialAct)this.get((IMObject)delivery);
        TestDeliveryVerifier deliveryVerifier = new TestDeliveryVerifier((ArchetypeService)this.getArchetypeService());
        ((TestDeliveryVerifier)deliveryVerifier.initialise(order)).status("IN_PROGRESS");
        deliveryVerifier.verify((IMObject)delivery);
        List deliveryItems = this.getBean((IMObject)delivery).getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)2L, (long)deliveryItems.size());
        for (FinancialAct orderItem : orderItems) {
            TestDeliveryItemVerifier verifier = new TestDeliveryItemVerifier((ArchetypeService)this.getArchetypeService());
            verifier.initialise(orderItem);
            verifier.verify(deliveryItems);
        }
    }

    @Test
    public void testValidAfterSelection() {
        Party supplier = this.supplierFactory.createSupplier();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMerchandise();
        TestOrderBuilder builder = (TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).status("POSTED")).item().product(product1)).reorderCode("1")).reorderDescription("1 desc")).quantity(1)).packageSize(10)).packageUnits("BOX")).unitPrice(1)).add()).item().product(product2)).reorderCode("2")).packageUnits("EACH")).reorderDescription("2 desc")).quantity(2)).packageSize(1)).unitPrice(2)).add();
        builder.build();
        FinancialAct delivery = this.createDelivery(supplier, stockLocation);
        DeliveryEditor editor = this.createEditor(delivery);
        List orderItems = builder.getItems();
        Assert.assertEquals((long)2L, (long)orderItems.size());
        for (FinancialAct orderItem : orderItems) {
            editor.createItem(orderItem);
        }
        Table table = (Table)EchoTestHelper.findComponent((Component)editor.getItems().getComponent(), Table.class);
        EchoTestHelper.fireSelection((Table)table, (int)0);
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
    }

    private DeliveryEditor createEditor(FinancialAct delivery) {
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        DeliveryEditor editor = new DeliveryEditor(delivery, null, (LayoutContext)layoutContext);
        editor.getComponent();
        return editor;
    }

    private FinancialAct createDelivery(Party supplier, Party stockLocation) {
        return (FinancialAct)((TestDeliveryBuilder)((TestDeliveryBuilder)this.supplierFactory.newDelivery().supplier(supplier)).stockLocation(stockLocation)).build(false);
    }

    private FinancialAct createReturn(Party supplier, Party stockLocation) {
        return (FinancialAct)((TestReturnBuilder)((TestReturnBuilder)this.supplierFactory.newReturn().supplier(supplier)).stockLocation(stockLocation)).build(false);
    }
}

