/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import org.hibernate.validator.internal.util.Contracts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderItemBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.supplier.order.OrderCRUDWindow;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderCRUDWindowTestCase
extends AbstractAppTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party practice;
    private Context context;

    @Before
    public void setUp() {
        super.setUp();
        this.initErrorHandler(this.errors);
        this.practice = this.practiceFactory.getPractice();
        this.context = new LocalContext();
        this.context.setPractice(this.practice);
    }

    @Test
    public void testPost() {
        FinancialAct order = this.createOrder();
        TestOrderCRUDWindow window = this.createWindow();
        this.checkPost(window, order);
        Contracts.assertNotNull((Object)EchoTestHelper.findWindowPane(PrintDialog.class));
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testPostESCIOrder() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = (Party)this.supplierFactory.newSupplier().addESCIConfiguration(stockLocation).build();
        FinancialAct order = (FinancialAct)((TestOrderBuilder)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).item().product(this.productFactory.createMedication())).quantity(10)).add()).status("IN_PROGRESS")).build();
        TestOrderCRUDWindow window = this.createWindow();
        this.checkPost(window, order);
        Assert.assertTrue((boolean)window.orderSubmitted);
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(PrintDialog.class));
    }

    @Test
    public void testPostRestrictedOrder() {
        this.practiceFactory.updatePractice(this.practice).restrictOrdering(true).build();
        Product product = (Product)this.productFactory.newMedication().drugSchedule(true).build();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        FinancialAct order = (FinancialAct)((TestOrderBuilder)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).item().product(product)).quantity(10)).add()).status("IN_PROGRESS")).build();
        this.context.setUser(this.userFactory.createUser());
        TestOrderCRUDWindow window = this.createWindow();
        window.setObject((Act)order);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        EchoTestHelper.findMessageDialogAndFireButton(InformationDialog.class, (String)"Ordering Restricted", (String)"Finalising orders with restricted medication must be performed by a clinician.\n\nPlease have a clinician review and finalise this order.", (String)"ok");
        FinancialAct reloaded1 = (FinancialAct)this.get((IMObject)order);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reloaded1.getStatus());
        this.context.setUser(this.userFactory.createClinician());
        this.checkPost(window, order);
    }

    private void checkPost(OrderCRUDWindow window, FinancialAct order) {
        window.setObject((Act)order);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        String displayName = this.getDisplayName((IMObject)order);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName), (String)("Are you sure you want to Finalise the " + displayName + "?"), (String)"ok");
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)order);
        Assert.assertEquals((Object)"POSTED", (Object)reloaded.getStatus());
        Assert.assertEquals((Object)reloaded, (Object)window.getObject());
        Assert.assertEquals((long)reloaded.getVersion(), (long)((FinancialAct)window.getObject()).getVersion());
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private TestOrderCRUDWindow createWindow() {
        return new TestOrderCRUDWindow(this.context, new HelpContext("foo", null));
    }

    private FinancialAct createOrder() {
        return (FinancialAct)((TestOrderBuilder)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(this.supplierFactory.createSupplier())).stockLocation(this.practiceFactory.createStockLocation(new Party[0]))).item().product(this.productFactory.createMedication())).quantity(10)).add()).status("IN_PROGRESS")).build();
    }

    private static class TestOrderCRUDWindow
    extends OrderCRUDWindow {
        private boolean orderSubmitted;

        public TestOrderCRUDWindow(Context context, HelpContext help) {
            super(Archetypes.create((String)"act.supplierOrder", FinancialAct.class), context, help);
        }

        protected boolean submitOrder(FinancialAct act) {
            this.orderSubmitted = true;
            return true;
        }

        protected void scheduleCheckInbox(boolean delay) {
        }
    }
}

