/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.stock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.product.stock.StockExportQuery;

public class StockExportQueryTestCase
extends AbstractAppTest {
    private Party stockLocation;
    private StockExportQuery query;

    @Before
    public void setUp() {
        super.setUp();
        this.stockLocation = ProductTestHelper.createStockLocation();
        this.query = new StockExportQuery(this.stockLocation);
    }

    @Test
    public void testQuery() {
        Product product1 = this.createProduct("A");
        Product product2 = this.createProduct("B");
        Product product3 = this.createProduct("C");
        ProductTestHelper.setStockQuantity((Product)product1, (Party)this.stockLocation, (BigDecimal)BigDecimal.ONE);
        ProductTestHelper.setStockQuantity((Product)product2, (Party)this.stockLocation, (BigDecimal)BigDecimal.TEN);
        ProductTestHelper.setStockQuantity((Product)product3, (Party)this.stockLocation, (BigDecimal)BigDecimal.ZERO);
        List<StockData> results = this.getResults();
        Assert.assertEquals((long)3L, (long)results.size());
        this.checkStock(results.get(0), product1, this.stockLocation, BigDecimal.ONE);
        this.checkStock(results.get(1), product2, this.stockLocation, BigDecimal.TEN);
        this.checkStock(results.get(2), product3, this.stockLocation, BigDecimal.ZERO);
        Assert.assertEquals((long)3L, (long)this.query.query().getResults());
    }

    @Test
    public void testEmpty() {
        ResultSet set = this.query.query();
        Assert.assertFalse((boolean)set.hasNext());
        Assert.assertEquals((long)0L, (long)set.getResults());
    }

    @Test
    public void testQueryByProductType() {
        Entity productType = ProductTestHelper.createProductType((String)"Vaccinations");
        Product product1 = this.createProduct("A", productType);
        Product product2 = this.createProduct("B");
        Product product3 = this.createProduct("C", productType);
        ProductTestHelper.setStockQuantity((Product)product1, (Party)this.stockLocation, (BigDecimal)BigDecimal.ONE);
        ProductTestHelper.setStockQuantity((Product)product2, (Party)this.stockLocation, (BigDecimal)BigDecimal.TEN);
        ProductTestHelper.setStockQuantity((Product)product3, (Party)this.stockLocation, (BigDecimal)BigDecimal.ZERO);
        this.query.setProductType(productType);
        List<StockData> results = this.getResults();
        Assert.assertEquals((long)2L, (long)results.size());
        this.checkStock(results.get(0), product1, this.stockLocation, BigDecimal.ONE);
        this.checkStock(results.get(1), product3, this.stockLocation, BigDecimal.ZERO);
    }

    @Test
    public void testQueryByProductGroup() {
        Lookup group1 = TestHelper.getLookup((String)"lookup.productGroup", (String)"MERCHANDISE");
        Lookup group2 = TestHelper.getLookup((String)"lookup.productGroup", (String)"VACCINE");
        Product product1 = this.createProduct("A", group1);
        Product product2 = this.createProduct("B", group2);
        Product product3 = this.createProduct("C", group1);
        ProductTestHelper.setStockQuantity((Product)product1, (Party)this.stockLocation, (BigDecimal)BigDecimal.ONE);
        ProductTestHelper.setStockQuantity((Product)product2, (Party)this.stockLocation, (BigDecimal)BigDecimal.TEN);
        ProductTestHelper.setStockQuantity((Product)product3, (Party)this.stockLocation, (BigDecimal)BigDecimal.ZERO);
        this.query.setProductGroup(group1.getCode());
        List<StockData> results = this.getResults();
        Assert.assertEquals((long)2L, (long)results.size());
        this.checkStock(results.get(0), product1, this.stockLocation, BigDecimal.ONE);
        this.checkStock(results.get(1), product3, this.stockLocation, BigDecimal.ZERO);
    }

    @Test
    public void testQueryByIncomeType() {
        Lookup incomeType1 = TestHelper.getLookup((String)"lookup.productIncomeType", (String)"INCOME_1");
        Lookup incomeType2 = TestHelper.getLookup((String)"lookup.productIncomeType", (String)"INCOME_2");
        Product product1 = this.createProduct("A", incomeType1);
        Product product2 = this.createProduct("B", incomeType2);
        Product product3 = this.createProduct("C", incomeType1);
        ProductTestHelper.setStockQuantity((Product)product1, (Party)this.stockLocation, (BigDecimal)BigDecimal.ONE);
        ProductTestHelper.setStockQuantity((Product)product2, (Party)this.stockLocation, (BigDecimal)BigDecimal.TEN);
        ProductTestHelper.setStockQuantity((Product)product3, (Party)this.stockLocation, (BigDecimal)BigDecimal.ZERO);
        this.query.setIncomeType(incomeType1.getCode());
        List<StockData> results = this.getResults();
        Assert.assertEquals((long)2L, (long)results.size());
        this.checkStock(results.get(0), product1, this.stockLocation, BigDecimal.ONE);
        this.checkStock(results.get(1), product3, this.stockLocation, BigDecimal.ZERO);
    }

    private void checkStock(StockData stockData, Product product, Party stockLocation, BigDecimal quantity) {
        Assert.assertEquals((long)stockData.getStockLocationId(), (long)stockLocation.getId());
        Assert.assertEquals((Object)stockData.getStockLocationName(), (Object)stockLocation.getName());
        Assert.assertEquals((long)stockData.getProductId(), (long)product.getId());
        Assert.assertEquals((Object)stockData.getProductName(), (Object)product.getName());
        this.checkEquals(stockData.getQuantity(), quantity);
        this.checkEquals(stockData.getQuantity(), quantity);
    }

    private List<StockData> getResults() {
        ArrayList<StockData> results = new ArrayList<StockData>();
        ResultSetIterator iterator = new ResultSetIterator(this.query.query());
        while (iterator.hasNext()) {
            results.add((StockData)iterator.next());
        }
        return results;
    }

    private Product createProduct(String name) {
        Product product = TestHelper.createProduct();
        product.setName(name);
        this.save((IMObject)product);
        return product;
    }

    private Product createProduct(String name, Entity productType) {
        Product product = ProductTestHelper.createMedication((Entity)productType);
        product.setName(name);
        this.save((IMObject)product);
        return product;
    }

    private Product createProduct(String name, Lookup classification) {
        Product product = this.createProduct(name);
        product.addClassification(classification);
        this.save((IMObject)product);
        return product;
    }
}

