/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product.batch;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.product.ProductBatchResultSet;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;

public class ProductBatchResultSetTestCase
extends ArchetypeServiceTest {
    @Test
    public void testQueryOnExpiry() {
        Product product = TestHelper.createProduct();
        Date tomorrow = DateRules.getTomorrow();
        Date today = DateRules.getToday();
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product, (Date)today, (Party[])new Party[0]);
        Entity batch2 = ProductTestHelper.createBatch((String)"batch2", (Product)product, (Date)tomorrow, (Party[])new Party[0]);
        Entity batch3 = ProductTestHelper.createBatch((String)"batch3", (Product)product, null, (Party[])new Party[0]);
        this.checkExpiry(null, null, true, batch1, batch2, batch3);
        this.checkExpiry(tomorrow, null, false, batch1);
        this.checkExpiry(tomorrow, null, true, batch2, batch3);
        this.checkExpiry(null, tomorrow, true, batch1);
        this.checkExpiry(null, tomorrow, false, batch2, batch3);
        this.checkExpiry(today, DateRules.getNextDate((Date)tomorrow), true, batch1, batch2);
        this.checkExpiry(today, DateRules.getNextDate((Date)tomorrow), false, batch3);
    }

    @Test
    public void testQueryOnStockLocation() {
        Product product = TestHelper.createProduct();
        Party location1 = ProductTestHelper.createStockLocation();
        Party location2 = ProductTestHelper.createStockLocation();
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product, null, (Party[])new Party[]{location1});
        Entity batch2 = ProductTestHelper.createBatch((String)"batch2", (Product)product, null, (Party[])new Party[]{location2});
        Entity batch3 = ProductTestHelper.createBatch((String)"batch3", (Product)product, null, (Party[])new Party[0]);
        Entity batch4 = ProductTestHelper.createBatch((String)"batch4", (Product)product, null, (Party[])new Party[]{location1, location2});
        this.checkStockLocation(location1, null, true, batch1, batch3, batch4);
        this.checkStockLocation(location1, null, false, batch2);
        this.checkStockLocation(location2, null, true, batch2, batch3, batch4);
        this.checkStockLocation(location2, null, false, batch1);
        this.checkStockLocation(null, null, true, batch1, batch2, batch3, batch4);
    }

    @Test
    public void testQueryOnStockLocationForInactiveRelationships() {
        Product product = TestHelper.createProduct();
        Party location = ProductTestHelper.createStockLocation();
        Date date1 = DateRules.getToday();
        Date date2 = DateRules.getYesterday();
        Date date3 = DateRules.getPreviousDate((Date)date2);
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product, null, (Party[])new Party[0]);
        this.addStockLocation(batch1, location, date2);
        this.checkStockLocation(location, null, true, batch1);
        this.checkStockLocation(location, date1, false, batch1);
        this.checkStockLocation(location, date2, true, batch1);
        this.checkStockLocation(location, date3, true, batch1);
    }

    @Test
    public void testQueryOnManufacturer() {
        Product product = TestHelper.createProduct();
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product, null, (Party[])new Party[0]);
        Entity batch2 = ProductTestHelper.createBatch((String)"batch2", (Product)product, null, (Party[])new Party[0]);
        Party man1 = this.addManufacturer(batch1);
        this.addManufacturer(batch2);
        this.checkManufacturer(man1, true, batch1);
        this.checkManufacturer(man1, false, batch2);
    }

    @Test
    public void testSortOnName() {
        Product product = TestHelper.createProduct();
        Date expiry = DateRules.getTomorrow();
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product, (Date)expiry, (Party[])new Party[0]);
        Entity batch2 = ProductTestHelper.createBatch((String)"batch2", (Product)product, (Date)expiry, (Party[])new Party[0]);
        SortConstraint[] sort = new SortConstraint[]{Constraints.sort((String)"name")};
        ProductBatchResultSet set = new ProductBatchResultSet(Constraints.shortName((String)"entity.productBatch"), null, null, null, null, null, null, null, null, sort, 20);
        this.checkOrder(set, batch1, batch2);
    }

    @Test
    public void testSortOnExpiryDate() {
        Product product = TestHelper.createProduct();
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product, (Date)DateRules.getTomorrow(), (Party[])new Party[0]);
        Entity batch2 = ProductTestHelper.createBatch((String)"batch2", (Product)product, (Date)DateRules.getToday(), (Party[])new Party[0]);
        SortConstraint[] sort = new SortConstraint[]{new VirtualNodeSortConstraint("expiryDate", true)};
        ProductBatchResultSet set = new ProductBatchResultSet(Constraints.shortName((String)"entity.productBatch"), null, null, null, null, null, null, null, null, sort, 20);
        this.checkOrder(set, batch2, batch1);
    }

    @Test
    public void testSortOnProduct() {
        Product product1 = this.createProduct("Z Test Product B");
        Product product2 = this.createProduct("Z Test Product A");
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product1, (Date)DateRules.getTomorrow(), (Party[])new Party[0]);
        Entity batch2 = ProductTestHelper.createBatch((String)"batch2", (Product)product2, (Date)DateRules.getToday(), (Party[])new Party[0]);
        SortConstraint[] sort = new SortConstraint[]{Constraints.sort((String)"product", (boolean)true)};
        ProductBatchResultSet set = new ProductBatchResultSet(Constraints.shortName((String)"entity.productBatch"), null, null, null, null, null, null, null, null, sort, 20);
        this.checkOrder(set, batch2, batch1);
    }

    @Test
    public void testQueryOnValueExcludesInactive() {
        Product product1 = this.createProduct("Z Test Product A");
        Entity batch1 = ProductTestHelper.createBatch((String)"batch1", (Product)product1, (Date)DateRules.getTomorrow(), (Party[])new Party[0]);
        Entity batch2 = ProductTestHelper.createBatch((String)"batch2", (Product)product1, (Date)DateRules.getTomorrow(), (Party[])new Party[0]);
        ProductBatchResultSet set1 = new ProductBatchResultSet(null, product1, null, null, 20);
        this.checkBatches(set1, true, batch1, batch2);
        batch1.setActive(false);
        batch2.setActive(false);
        this.save((IMObject[])new Entity[]{batch1, batch2});
        ProductBatchResultSet set2 = new ProductBatchResultSet(null, product1, null, null, 20);
        this.checkBatches(set2, false, batch1, batch2);
    }

    private void checkOrder(ProductBatchResultSet set, Entity ... batches) {
        Entity next;
        int index = 0;
        ResultSetIterator iterator = new ResultSetIterator((ResultSet)set);
        while (iterator.hasNext() && (!(next = (Entity)iterator.next()).getName().equals(batches[index].getName()) || ++index != batches.length)) {
        }
        Assert.assertEquals((long)batches.length, (long)index);
    }

    private void addStockLocation(Entity batch, Party stockLocation, Date endTime) {
        IMObjectBean bean = this.getBean((IMObject)batch);
        EntityLink relationship = (EntityLink)bean.setTarget("stockLocations", (IMObject)stockLocation);
        relationship.setActiveEndTime(endTime);
        if (endTime != null) {
            relationship.setActiveStartTime(DateRules.getPreviousDate((Date)endTime));
        }
        bean.save();
    }

    private Product createProduct(String name) {
        Product product = TestHelper.createProduct();
        product.setName(name);
        this.save((IMObject)product);
        return product;
    }

    private Party addManufacturer(Entity batch) {
        Party result = (Party)this.create("party.supplierManufacturer", Party.class);
        result.setName("ZManufacturer-" + System.currentTimeMillis());
        IMObjectBean bean = this.getBean((IMObject)batch);
        bean.setTarget("manufacturer", (IMObject)result);
        this.save((IMObject[])new Entity[]{batch, result});
        return result;
    }

    private void checkExpiry(Date from, Date to, boolean include, Entity ... batches) {
        ProductBatchResultSet set = new ProductBatchResultSet(Constraints.shortName((String)"entity.productBatch"), null, null, null, from, to, null, null, null, null, 20);
        this.checkBatches(set, include, batches);
    }

    private void checkStockLocation(Party stockLocation, Date active, boolean include, Entity ... batches) {
        Reference location = stockLocation != null ? stockLocation.getObjectReference() : null;
        ProductBatchResultSet set = new ProductBatchResultSet(Constraints.shortName((String)"entity.productBatch"), null, null, null, null, null, location, active, null, null, 20);
        this.checkBatches(set, include, batches);
    }

    private void checkManufacturer(Party manufacturer, boolean include, Entity ... batches) {
        ProductBatchResultSet set = new ProductBatchResultSet(Constraints.shortName((String)"entity.productBatch"), null, null, null, null, null, null, null, manufacturer, null, 20);
        this.checkBatches(set, include, batches);
    }

    private void checkBatches(ProductBatchResultSet set, boolean include, Entity ... batches) {
        List objectRefs = QueryTestHelper.getObjectRefs((ResultSet)set);
        for (Entity object : batches) {
            if (include) {
                Assert.assertTrue((String)(object.getName() + " should be included"), (boolean)objectRefs.contains(object.getObjectReference()));
                continue;
            }
            Assert.assertFalse((String)(object.getName() + " should be excluded"), (boolean)objectRefs.contains(object.getObjectReference()));
        }
    }
}

