/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.DefaultEditorQueue;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.order.PharmacyTestHelper;
import org.openvpms.web.workspace.patient.charge.VisitChargeEditor;
import org.openvpms.web.workspace.patient.visit.VisitChargeCRUDWindow;
import org.openvpms.web.workspace.workflow.TestVisitChargeEditor;

public class VisitChargeCRUDWindowTestCase
extends AbstractAppTest {
    private Context context;
    private Party customer;
    private Party patient;
    private Act event;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = TestHelper.createCustomer();
        this.patient = TestHelper.createPatient((Party)this.customer);
        this.context = new LocalContext();
        this.context.setPractice(TestHelper.getPractice());
        this.context.setCustomer(this.customer);
        this.context.setPatient(this.patient);
        this.context.setUser(TestHelper.createUser());
        this.context.setLocation(TestHelper.createLocation());
        this.event = PatientTestHelper.createEvent((Party)this.patient);
    }

    @Test
    public void testReload() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        VisitChargeCRUDWindow window = new VisitChargeCRUDWindow(this.event, this.context, new HelpContext("foo", null));
        window.setObject(charge);
        Assert.assertTrue((boolean)window.save());
        FinancialAct copy = (FinancialAct)this.get((IMObject)charge);
        copy.setStatus("COMPLETED");
        this.save((IMObject)copy);
        VisitChargeEditor editor1 = window.getEditor();
        editor1.setClinician(TestHelper.createClinician());
        Assert.assertFalse((boolean)window.save());
        VisitChargeEditor editor2 = window.getEditor();
        Assert.assertNotNull((Object)editor2);
        Assert.assertNotEquals((Object)editor2, (Object)editor1);
        Assert.assertEquals((Object)"COMPLETED", (Object)editor2.getStatus());
        Assert.assertEquals((Object)"COMPLETED", (Object)((FinancialAct)window.getObject()).getStatus());
    }

    @Test
    public void testPostOutsideEditor() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        VisitChargeCRUDWindow window = new VisitChargeCRUDWindow(this.event, this.context, new HelpContext("foo", null));
        window.setObject(charge);
        Assert.assertTrue((boolean)window.save());
        FinancialAct copy = (FinancialAct)this.get((IMObject)charge);
        copy.setStatus("POSTED");
        this.save((IMObject)copy);
        window.getEditor().setClinician(TestHelper.createClinician());
        Assert.assertFalse((boolean)window.save());
        Assert.assertNull((Object)window.getEditor());
        Assert.assertEquals((Object)"POSTED", (Object)((FinancialAct)window.getObject()).getStatus());
    }

    @Test
    public void testReloadWithChargedOrders() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)charge);
        bean.setTarget("customer", (IMObject)this.customer);
        bean.save();
        Product product = TestHelper.createProduct();
        FinancialAct order = PharmacyTestHelper.createOrder(this.customer, this.patient, product, BigDecimal.ONE, null);
        DefaultEditorQueue queue = new DefaultEditorQueue(this.context);
        TestVisitChargeCRUDWindow window = new TestVisitChargeCRUDWindow(this.event, (EditorQueue)queue);
        window.setObject(charge);
        window.show();
        CustomerChargeTestHelper.checkSavePopup((EditorQueue)queue, "act.patientMedication", false);
        VisitChargeEditor editor1 = window.getEditor();
        Assert.assertEquals((long)1L, (long)editor1.getItems().getActs().size());
        FinancialAct copy = (FinancialAct)this.get((IMObject)charge);
        copy.setStatus("COMPLETED");
        this.save((IMObject)copy);
        Assert.assertFalse((boolean)window.save());
        order = (FinancialAct)this.get((IMObject)order);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)order.getStatus());
        VisitChargeEditor editor2 = window.getEditor();
        Assert.assertNotNull((Object)editor2);
        Assert.assertNotEquals((Object)editor2, (Object)editor1);
        Assert.assertEquals((Object)"COMPLETED", (Object)editor2.getStatus());
        Assert.assertEquals((long)0L, (long)editor2.getItems().getActs().size());
        editor2.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)window.save());
        order = (FinancialAct)this.get((IMObject)order);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)order.getStatus());
    }

    @Test
    public void testAutoSave() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        DefaultEditorQueue queue = new DefaultEditorQueue(this.context);
        TestVisitChargeCRUDWindow window = new TestVisitChargeCRUDWindow(this.event, (EditorQueue)queue);
        window.setObject(charge);
        window.show();
        TestVisitChargeEditor editor = window.getEditor();
        Assert.assertNotNull((Object)editor);
        CustomerChargeActItemEditor item1 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item1);
        Assert.assertTrue((boolean)editor.getObject().isNew());
        item1.setProduct(TestHelper.createProduct());
        item1.setQuantity(BigDecimal.TEN);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        CustomerChargeActItemEditor item2 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item2);
        Assert.assertTrue((boolean)editor.getObject().isNew());
        Assert.assertTrue((boolean)window.save());
        Product product2 = TestHelper.createProduct();
        item2.setProduct(product2);
        item2.setQuantity(BigDecimal.ONE);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        CustomerChargeActItemEditor item3 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item3);
        this.checkInvoice(editor, "IN_PROGRESS", 2);
        item3.setProduct(TestHelper.createProduct());
        item3.setQuantity(BigDecimal.TEN);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        item2.setProduct(null);
        CustomerChargeActItemEditor item4 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item4);
        item4.setProduct(TestHelper.createProduct());
        item4.setQuantity(BigDecimal.ONE);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        this.checkInvoice(editor, "IN_PROGRESS", 2);
        item2.setProduct(TestHelper.createProduct());
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor item5 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item5);
        this.checkInvoice(editor, "IN_PROGRESS", 4);
        item5.setProduct(TestHelper.createProduct());
        item5.setQuantity(BigDecimal.TEN);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientMedication", false);
        editor.setStatus("POSTED");
        CustomerChargeActItemEditor item6 = (CustomerChargeActItemEditor)editor.getItems().onAdd();
        Assert.assertNotNull((Object)item6);
        this.checkInvoice(editor, "IN_PROGRESS", 4);
        Assert.assertTrue((boolean)window.save());
        this.checkInvoice(editor, "POSTED", 5);
        Assert.assertEquals((long)4L, (long)window.getSaves());
        Assert.assertTrue((boolean)window.save());
        Assert.assertEquals((long)4L, (long)window.getSaves());
    }

    private void checkInvoice(VisitChargeEditor editor, String status, int items) {
        FinancialAct charge = (FinancialAct)this.get((IMObject)editor.getObject());
        Assert.assertNotNull((Object)charge);
        Assert.assertEquals((Object)status, (Object)charge.getStatus());
        IMObjectBean bean = this.getBean((IMObject)charge);
        Assert.assertEquals((long)items, (long)bean.getTargets("items").size());
    }

    private class TestVisitChargeCRUDWindow
    extends VisitChargeCRUDWindow {
        private final EditorQueue queue;
        private int saves;

        public TestVisitChargeCRUDWindow(Act event, EditorQueue queue) {
            super(event, VisitChargeCRUDWindowTestCase.this.context, new HelpContext("foo", null));
            this.queue = queue;
        }

        public TestVisitChargeEditor getEditor() {
            return (TestVisitChargeEditor)super.getEditor();
        }

        public int getSaves() {
            return this.saves;
        }

        protected boolean doSave() {
            ++this.saves;
            return super.doSave();
        }

        protected VisitChargeEditor createVisitChargeEditor(FinancialAct charge, Act event, LayoutContext context) {
            return new TestVisitChargeEditor(this.queue, charge, event, context);
        }
    }
}

