/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.investigation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.filetransfer.UploadSelect;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.laboratory.TestInvestigationTypeBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryTestBuilder;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.document.CompressedDocumentImpl;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.internal.report.ReportBuilderImpl;
import org.openvpms.laboratory.internal.report.ResultImpl;
import org.openvpms.laboratory.internal.report.ResultsImpl;
import org.openvpms.laboratory.internal.service.OrderValidationService;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.report.Report;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.laboratory.service.OrderValidationStatus;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.doc.VersionedDocumentActEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.patient.investigation.PatientInvestigationActEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class PatientInvestigationActEditorTestCase
extends VersionedDocumentActEditorTest<PatientInvestigationActEditor> {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private DomainService domainService;
    @Autowired
    private DocumentHandlers handlers;
    @Autowired
    private DocumentRules documentRules;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private LaboratoryServices laboratoryServices;
    private OrderValidationService validationService;

    public PatientInvestigationActEditorTestCase() {
        super(PatientInvestigationActEditor.class, "act.patientInvestigation");
    }

    @Before
    public void setUp() {
        super.setUp();
        this.laboratoryServices = (LaboratoryServices)Mockito.mock(LaboratoryServices.class);
        LaboratoryService service = (LaboratoryService)Mockito.mock(LaboratoryService.class);
        Mockito.when((Object)this.laboratoryServices.getService((Entity)ArgumentMatchers.any())).thenReturn((Object)service);
        this.validationService = new OrderValidationService(){

            public OrderValidationService.ValidationStatus validate(DocumentAct investigation) {
                return new OrderValidationService.ValidationStatus(null, OrderValidationStatus.valid());
            }
        };
    }

    @Test
    public void testDeleteInvestigationTypeFromProduct() {
        Entity type = this.laboratoryFactory.createInvestigationType();
        Entity test = this.laboratoryFactory.createTest(type);
        DocumentAct act = this.patientFactory.newInvestigation().investigationType(type).build(false);
        Product product = (Product)((TestServiceProductBuilder)this.productFactory.newService().addTests(new Entity[]{test})).build();
        PatientInvestigationActEditor editor = this.createInvestigationEditor(act);
        editor.setPatient(this.patientFactory.createPatient());
        editor.setInvestigationType(type);
        editor.addProduct(product);
        editor.setLocation(this.practiceFactory.createLocation());
        editor.save();
        IMObjectBean productBean = this.getBean((IMObject)product);
        Relationship relationship = productBean.removeTarget("tests", (IMObject)test);
        Assert.assertNotNull((Object)relationship);
        productBean.save();
        editor = this.createInvestigationEditor(act);
        editor.getProperty("description").setValue((Object)"Some notes to flag the editor as modified");
        Assert.assertTrue((boolean)editor.isModified());
        editor.save();
    }

    @Test
    public void testCanAddTest() {
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        Entity typeA = this.laboratoryFactory.createInvestigationType();
        Entity typeB = this.laboratoryFactory.createInvestigationType();
        Entity test1 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(true)).build();
        Entity test2 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(true)).build();
        Entity test3 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(false)).build();
        Entity test4 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeB)).group(true)).build();
        PatientInvestigationActEditor editor = this.createInvestigationEditor(act);
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        editor.setPatient(patient1);
        Assert.assertFalse((boolean)editor.canAddTest(patient1, test1));
        editor.setInvestigationType(typeA);
        Assert.assertTrue((boolean)editor.canAddTest(patient1, test1));
        editor.addTest(test1);
        Assert.assertFalse((boolean)editor.canAddTest(patient2, test1));
        Assert.assertFalse((boolean)editor.canAddTest(patient1, test1));
        Assert.assertTrue((boolean)editor.canAddTest(patient1, test2));
        Assert.assertFalse((boolean)editor.canAddTest(patient1, test3));
        Assert.assertFalse((boolean)editor.canAddTest(patient1, test4));
        test2.setActive(false);
        this.save((IMObject)test2);
        Assert.assertFalse((boolean)editor.canAddTest(patient1, test2));
    }

    @Test
    public void testDefaultDevice() {
        Party location = this.practiceFactory.createLocation();
        Entity laboratory = this.laboratoryFactory.createLaboratory(new Party[]{location});
        Entity typeA = this.laboratoryFactory.createInvestigationType(laboratory);
        Entity device1 = this.laboratoryFactory.createDevice(laboratory);
        Entity device2 = this.laboratoryFactory.createDevice(laboratory);
        device2.setActive(false);
        this.save((IMObject)device2);
        Entity typeB = (Entity)this.laboratoryFactory.newInvestigationType().laboratory(laboratory).addDevices(new Entity[]{device1, device2}).build();
        Entity test1 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(false)).useDevice(TestLaboratoryTestBuilder.UseDevice.YES).build();
        Entity test2 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeB)).group(false)).useDevice(TestLaboratoryTestBuilder.UseDevice.YES).build();
        Entity test3 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeB)).group(false)).useDevice(TestLaboratoryTestBuilder.UseDevice.OPTIONAL).build();
        Entity test4 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeB)).group(false)).useDevice(TestLaboratoryTestBuilder.UseDevice.NO).build();
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        PatientInvestigationActEditor editor = this.createInvestigationEditor(act);
        editor.setLocation(location);
        editor.setPatient(this.patientFactory.createPatient());
        editor.setInvestigationType(typeA);
        editor.addTest(test1);
        Assert.assertNull((Object)editor.getDevice());
        editor.setInvestigationType(typeB);
        Assert.assertEquals((long)0L, (long)editor.getTests().size());
        editor.addTest(test2);
        Assert.assertEquals((Object)device1, (Object)editor.getDevice());
        editor.removeTest(test2);
        Assert.assertEquals((long)0L, (long)editor.getTests().size());
        Assert.assertNull((Object)editor.getDevice());
        editor.addTest(test3);
        Assert.assertEquals((Object)device1, (Object)editor.getDevice());
        editor.removeTest(test3);
        editor.addTest(test4);
        Assert.assertNull((Object)editor.getDevice());
    }

    @Test
    public void testValidation() {
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Entity laboratory = this.laboratoryFactory.createLaboratory();
        Entity device1 = this.laboratoryFactory.createDevice(laboratory, new Party[]{location1, location2});
        Entity device2 = this.laboratoryFactory.createDevice(laboratory, new Party[]{location2});
        Entity typeA = (Entity)this.laboratoryFactory.newInvestigationType().laboratory(laboratory).addDevices(new Entity[]{device1, device2}).build();
        Entity typeB = this.laboratoryFactory.createInvestigationType();
        Entity test1 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(true)).useDevice(TestLaboratoryTestBuilder.UseDevice.YES).build();
        Entity test2 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(true)).build();
        Entity test3 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(false)).build();
        Entity test4 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeB)).group(true)).build();
        PatientInvestigationActEditor editor = this.createInvestigationEditor(act);
        editor.setPatient(this.patientFactory.createPatient());
        editor.setInvestigationType(null);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Investigation Type is required");
        editor.setInvestigationType(typeB);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setLocation(location1);
        editor.setInvestigationType(typeA);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)("A Test is required for " + laboratory.getName()));
        editor.setLocation(null);
        editor.addTest(test1);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Location is required");
        editor.setLocation(location1);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)("A Laboratory Device must be specified for " + test1.getName()));
        editor.setDevice(device1);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setDevice(device2);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)(device2.getName() + " cannot be used at " + location1.getName()));
        editor.removeTest(test1);
        editor.addTest(test2);
        editor.setDevice(device1);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)("Test " + test2.getName() + " cannot use a Laboratory Device"));
        editor.removeTest(test2);
        editor.addTest(test4);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)("Test " + test4.getName() + " is not provided by " + typeA.getName()));
        editor.removeTest(test4);
        editor.addTest(test1);
        editor.setInvestigationType(typeB);
        editor.addTest(test4);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setInvestigationType(typeA);
        editor.addTest(test2);
        editor.addTest(test3);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)(test3.getName() + " cannot be grouped with other tests"));
    }

    @Test
    public void testValidateLaboratoryWithNoLocationConfiguration() {
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Entity laboratory = this.laboratoryFactory.createLaboratory(new Party[]{location1});
        Entity type = this.laboratoryFactory.createInvestigationType(laboratory);
        Entity test = this.laboratoryFactory.createTest(type);
        PatientInvestigationActEditor editor = this.createInvestigationEditor(act);
        editor.setPatient(this.patientFactory.createPatient());
        editor.setLocation(location1);
        editor.setInvestigationType(type);
        editor.addTest(test);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setLocation(location2);
        editor.setInvestigationType(type);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)("Cannot order tests for " + type.getName() + ". There is no configuration for " + laboratory.getName() + " at " + location2.getName() + "."));
    }

    @Test
    public void testValidateStartEndTimes() {
        Party location = this.practiceFactory.createLocation();
        Entity laboratory = this.laboratoryFactory.createLaboratory(new Party[]{location});
        Entity typeA = this.laboratoryFactory.createInvestigationType(laboratory);
        Entity test1 = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(typeA)).group(false)).useDevice(TestLaboratoryTestBuilder.UseDevice.NO).build();
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        PatientInvestigationActEditor editor = this.createInvestigationEditor(act);
        editor.setLocation(location);
        editor.setPatient(this.patientFactory.createPatient());
        editor.setInvestigationType(typeA);
        editor.addTest(test1);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setStartTime(DateRules.getToday());
        editor.setEndTime(DateRules.getToday());
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setEndTime(DateRules.getTomorrow());
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setStartTime(DateRules.getTomorrow());
        editor.setEndTime(DateRules.getToday());
        EditorTestHelper.assertValid((Modifiable)editor);
    }

    @Test
    public void testMismatchLaboratoryOnInvestigationType() {
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        Party location = this.practiceFactory.createLocation();
        Entity laboratory1 = this.laboratoryFactory.createLaboratory();
        Entity laboratory2 = this.laboratoryFactory.createLaboratory();
        Entity investigationType = this.laboratoryFactory.createInvestigationType(laboratory1);
        Entity test = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(investigationType)).group(true)).build();
        PatientInvestigationActEditor editor1 = this.createInvestigationEditor(act);
        editor1.setLocation(location);
        editor1.setPatient(this.patientFactory.createPatient());
        editor1.setInvestigationType(investigationType);
        editor1.addTest(test);
        Assert.assertTrue((boolean)this.save((DocumentActEditor)editor1));
        IMObjectBean bean = this.getBean((IMObject)investigationType);
        bean.setTarget("laboratory", (IMObject)laboratory2);
        bean.save();
        PatientInvestigationActEditor editor2 = this.createInvestigationEditor(act);
        EditorTestHelper.assertInvalid((Modifiable)editor2, (String)("Expected Laboratory " + laboratory2.getName() + " for Investigation Type " + investigationType.getName() + " but Investigation has " + laboratory1.getName()));
    }

    @Test
    public void testMismatchLaboratoryOnDevice() {
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        Party location = this.practiceFactory.createLocation();
        Entity laboratory1 = this.laboratoryFactory.createLaboratory();
        Entity laboratory2 = this.laboratoryFactory.createLaboratory();
        Entity investigationType = this.laboratoryFactory.createInvestigationType(laboratory1);
        Entity device1 = this.laboratoryFactory.createDevice(laboratory1);
        Entity device2 = this.laboratoryFactory.createDevice(laboratory2);
        Entity test = (Entity)((TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.laboratoryFactory.newTest().investigationType(investigationType)).group(true)).useDevice(TestLaboratoryTestBuilder.UseDevice.YES).build();
        PatientInvestigationActEditor editor1 = this.createInvestigationEditor(act);
        editor1.setLocation(location);
        editor1.setPatient(this.patientFactory.createPatient());
        editor1.setInvestigationType(investigationType);
        editor1.addTest(test);
        editor1.setDevice(device1);
        Assert.assertTrue((boolean)this.save((DocumentActEditor)editor1));
        editor1.setDevice(device2);
        PatientInvestigationActEditor editor2 = this.createInvestigationEditor(act);
        EditorTestHelper.assertInvalid((Modifiable)editor2, (String)("Device " + device2.getName() + " is not supported by " + laboratory1.getName()));
    }

    @Test
    public void testUpload() throws IOException {
        DocumentAct act = this.createAct();
        PatientInvestigationActEditor editor = this.createEditor(act);
        Component component = editor.getComponent();
        Assert.assertFalse((boolean)editor.getProperty("protectedDocument").getBoolean());
        Assert.assertNull((Object)editor.getDocument());
        Document document = this.createDocument();
        EchoTestHelper.fireButton((Component)component, (String)"button.upload");
        UploadSelect select = (UploadSelect)this.findComponent(UploadSelect.class);
        select.fileUpload(new CompressedDocumentImpl((org.openvpms.component.model.document.Document)document, this.handlers).getContent(), document.getSize(), document.getMimeType(), document.getName());
        Assert.assertNotNull((Object)editor.getDocument());
        Assert.assertTrue((boolean)editor.getProperty("protectedDocument").getBoolean());
    }

    @Test
    public void testProtectedDocument() {
        DocumentAct act = this.createAct();
        PatientInvestigationActEditor editor = this.createEditor(act);
        editor.getComponent();
        Assert.assertFalse((boolean)editor.getProperty("protectedDocument").getBoolean());
        Document doc1 = this.createDocument();
        editor.setDocument((org.openvpms.component.model.document.Document)doc1);
        Assert.assertTrue((boolean)editor.getProperty("protectedDocument").getBoolean());
    }

    @Test
    public void testUpdateStatusOnAttachDocument() {
        DocumentAct act1 = this.createAct();
        act1.setStatus2("SENT");
        PatientInvestigationActEditor editor1 = this.createEditor(act1);
        editor1.getComponent();
        Document doc1 = this.createDocument();
        editor1.setDocument((org.openvpms.component.model.document.Document)doc1);
        Assert.assertEquals((Object)"RECEIVED", (Object)editor1.getOrderStatus());
        DocumentAct act2 = this.createAct();
        act2.setStatus2("PENDING");
        PatientInvestigationActEditor editor2 = this.createEditor(act2);
        editor2.getComponent();
        Document doc2 = this.createDocument();
        editor2.setDocument((org.openvpms.component.model.document.Document)doc2);
        Assert.assertEquals((Object)"PENDING", (Object)editor2.getOrderStatus());
    }

    @Test
    public void testDelete() {
        Party patient = this.patientFactory.createPatient();
        Entity laboratory = this.laboratoryFactory.createLaboratory();
        Party location = this.practiceFactory.createLocation();
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).laboratory(laboratory).location(location)).order(Order.Status.SUBMITTED.toString()).build();
        Act order = (Act)this.getBean((IMObject)investigation).getTarget("order", Act.class);
        Assert.assertNotNull((Object)order);
        ReportBuilderImpl builder = new ReportBuilderImpl(investigation, order, (ArchetypeService)this.getArchetypeService(), this.domainService, this.handlers, this.documentRules, this.transactionManager);
        Report report = builder.results("1").notes(RandomStringUtils.randomAlphanumeric((int)10000)).result("1").analyteName("a1").result(RandomStringUtils.randomAlphanumeric((int)10000)).image("foo.png", "image/png", (InputStream)new ByteArrayInputStream(new byte[10])).notes(RandomStringUtils.randomAlphanumeric((int)10000)).add().add().build();
        List resultsList = report.getResults();
        Assert.assertEquals((long)1L, (long)resultsList.size());
        ResultsImpl results = (ResultsImpl)resultsList.get(0);
        DocumentAct resultsNoteAct = this.getDocumentAct(results.getAct(), "longNotes");
        List items = results.getResults();
        Assert.assertEquals((long)1L, (long)items.size());
        ResultImpl item = (ResultImpl)items.get(0);
        DocumentAct resultAct = this.getDocumentAct(item.getAct(), "longResult");
        DocumentAct resultNotesAct = this.getDocumentAct(item.getAct(), "longNotes");
        DocumentAct image = this.getDocumentAct(item.getAct(), "image");
        PatientInvestigationActEditor editor = this.createEditor(investigation);
        this.delete((DocumentActEditor)editor);
        this.checkDeleted(resultsNoteAct);
        this.checkDeleted(resultAct);
        this.checkDeleted(resultNotesAct);
        this.checkDeleted(image);
    }

    @Test
    public void testDescriptionCopiedFromInvestigationType() {
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        Entity type1 = (Entity)((TestInvestigationTypeBuilder)this.laboratoryFactory.newInvestigationType().description("type 1")).build();
        Entity type2 = this.laboratoryFactory.createInvestigationType();
        Entity type3 = (Entity)((TestInvestigationTypeBuilder)this.laboratoryFactory.newInvestigationType().description("type 3")).build();
        Entity type4 = (Entity)((TestInvestigationTypeBuilder)this.laboratoryFactory.newInvestigationType().laboratory(this.laboratoryFactory.createLaboratory()).description("type 4")).build();
        PatientInvestigationActEditor editor = this.createEditor(act);
        editor.getComponent();
        Assert.assertNull((Object)act.getDescription());
        editor.setInvestigationType(type1);
        Assert.assertEquals((Object)"type 1", (Object)act.getDescription());
        editor.setInvestigationType(type2);
        Assert.assertNull((Object)act.getDescription());
        editor.setInvestigationType(type3);
        Assert.assertEquals((Object)"type 3", (Object)act.getDescription());
        Assert.assertTrue((boolean)this.save((DocumentActEditor)editor));
        act = (DocumentAct)this.get((IMObject)act);
        Assert.assertEquals((Object)"type 3", (Object)act.getDescription());
        editor.setInvestigationType(type4);
        editor.addTest(this.laboratoryFactory.createTest(type4));
        Assert.assertTrue((boolean)this.save((DocumentActEditor)editor));
        act = (DocumentAct)this.get((IMObject)act);
        Assert.assertNull((Object)act.getDescription());
    }

    protected DocumentAct createAct() {
        DocumentAct act = (DocumentAct)this.create("act.patientInvestigation", DocumentAct.class);
        Entity type = this.laboratoryFactory.createInvestigationType();
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("investigationType", (IMObject)type);
        return act;
    }

    protected PatientInvestigationActEditor createEditor(DocumentAct act) {
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        layout.setEdit(true);
        Context context = layout.getContext();
        context.setPatient(this.patientFactory.createPatient());
        context.setUser(this.userFactory.createUser());
        context.setLocation(this.practiceFactory.createLocation());
        return new PatientInvestigationActEditor(act, null, (LayoutContext)layout);
    }

    protected Document createDocument() {
        return this.createImage();
    }

    private DocumentAct getDocumentAct(Act parent, String node) {
        DocumentAct act = (DocumentAct)this.getBean((IMObject)parent).getTarget(node, DocumentAct.class);
        Assert.assertNotNull((Object)act);
        Assert.assertNotNull((Object)act.getDocument());
        return act;
    }

    private void checkDeleted(DocumentAct act) {
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNull((Object)this.get(act.getDocument()));
    }

    private PatientInvestigationActEditor createInvestigationEditor(DocumentAct act) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        PatientInvestigationActEditor editor = new PatientInvestigationActEditor(act, null, (LayoutContext)context){

            protected LaboratoryServices getLaboratoryServices() {
                return PatientInvestigationActEditorTestCase.this.laboratoryServices;
            }

            protected OrderValidationService getValidationService() {
                return PatientInvestigationActEditorTestCase.this.validationService;
            }
        };
        editor.getComponent();
        return editor;
    }
}

