/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.insurance.InsuranceTestHelper;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.ArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class ChargesTestCase
extends AbstractAppTest {
    @Autowired
    PlatformTransactionManager transactionManager;
    @Autowired
    CustomerAccountRules accountRules;
    private Party customer;
    private Party patient;
    private User clinician;
    private Party location;
    private Entity till;
    private InsuranceRules insuranceRules;
    private Context context;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = TestHelper.createCustomer();
        this.patient = TestHelper.createPatient((Party)this.customer);
        this.clinician = TestHelper.createClinician();
        this.location = TestHelper.createLocation();
        this.till = TestHelper.createTill();
        this.insuranceRules = new InsuranceRules((IArchetypeService)((ArchetypeRuleService)this.getArchetypeService()), this.transactionManager);
        this.context = new LocalContext();
        this.context.setPractice(TestHelper.getPractice());
        this.context.setLocation(TestHelper.createLocation());
        this.context.setUser(TestHelper.createUser());
        InsuranceTestHelper.createDiagnosis((String)"VENOM_328", (String)"Abcess", (String)"328");
    }

    @Test
    public void testCanClaimInvoice() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim));
        FinancialAct item1 = this.createInvoiceItem();
        FinancialAct item2 = this.createInvoiceItem();
        FinancialAct invoice = this.createInvoice("IN_PROGRESS", item1, item2);
        Assert.assertFalse((boolean)charges.canClaimInvoice(invoice));
        invoice.setStatus("ON_HOLD");
        Assert.assertFalse((boolean)charges.canClaimInvoice(invoice));
        invoice.setStatus("COMPLETED");
        Assert.assertFalse((boolean)charges.canClaimInvoice(invoice));
        invoice.setStatus("POSTED");
        Assert.assertFalse((boolean)charges.canClaimInvoice(invoice));
        this.save((IMObject)invoice);
        this.createPayment(invoice.getTotal());
        invoice = (FinancialAct)this.get((IMObject)invoice);
        Assert.assertTrue((boolean)charges.canClaimInvoice(invoice));
        Assert.assertFalse((boolean)charges.isReversed(invoice));
        this.accountRules.reverse(invoice, new Date());
        Assert.assertTrue((boolean)charges.isReversed(invoice));
        Assert.assertFalse((boolean)charges.canClaimInvoice(invoice));
    }

    @Test
    public void testCanClaimItem() {
        FinancialAct claim1 = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges1 = new Charges(this.createClaimContext(claim1));
        FinancialAct item1 = this.createInvoiceItem();
        FinancialAct item2 = this.createInvoiceItem();
        FinancialAct invoice = this.createInvoice("IN_PROGRESS", item1, item2);
        Assert.assertFalse((boolean)charges1.canClaimItem((Act)item1));
        Assert.assertFalse((boolean)charges1.canClaimItem((Act)item2));
        invoice.setStatus("POSTED");
        this.save((IMObject)invoice);
        Assert.assertFalse((boolean)charges1.canClaimItem((Act)item1));
        Assert.assertFalse((boolean)charges1.canClaimItem((Act)item2));
        this.createPayment(invoice.getTotal());
        Assert.assertFalse((boolean)charges1.canClaimItem((Act)item1));
        Assert.assertFalse((boolean)charges1.canClaimItem((Act)item2));
        Charges charges2 = new Charges(this.createClaimContext(claim1));
        Assert.assertTrue((boolean)charges2.canClaimItem((Act)item1));
        Assert.assertTrue((boolean)charges2.canClaimItem((Act)item2));
        charges2.add((Act)item1);
        Assert.assertFalse((boolean)charges2.canClaimItem((Act)item1));
        Assert.assertTrue((boolean)charges2.canClaimItem((Act)item2));
        charges2.add((Act)item2);
        Assert.assertFalse((boolean)charges2.canClaimItem((Act)item1));
        Assert.assertFalse((boolean)charges2.canClaimItem((Act)item2));
        charges2.remove((Act)item1);
        Assert.assertTrue((boolean)charges2.canClaimItem((Act)item1));
        Assert.assertFalse((boolean)charges2.canClaimItem((Act)item2));
        Act policy = InsuranceTestHelper.createPolicy((Party)this.customer, (Party)this.patient, (Party)InsuranceTestHelper.createInsurer((String)"Foo"), (String)"POL123456");
        this.save((IMObject)policy);
        FinancialAct claimItem1 = InsuranceTestHelper.createClaimItem((String)"VENOM_328", (Date)new Date(), (Date)new Date(), (FinancialAct[])new FinancialAct[]{item1});
        FinancialAct claim2 = InsuranceTestHelper.createClaim((Act)policy, (Party)this.location, (User)this.clinician, (User)this.clinician, (FinancialAct[])new FinancialAct[]{claimItem1});
        this.save((IMObject[])new FinancialAct[]{claim2, claimItem1, item1});
        Charges charges3 = new Charges(this.createClaimContext(claim2));
        Assert.assertFalse((boolean)charges3.canClaimItem((Act)item1));
        Assert.assertTrue((boolean)charges3.canClaimItem((Act)item2));
        claim2.setStatus("CANCELLED");
        this.save((IMObject)claim2);
        Assert.assertFalse((boolean)charges3.canClaimItem((Act)item1));
        Charges charges4 = new Charges(this.createClaimContext(claim2));
        Assert.assertTrue((boolean)charges4.canClaimItem((Act)item1));
    }

    @Test
    public void testIsPaid() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim));
        FinancialAct invoice = this.createInvoice("POSTED", this.createInvoiceItem());
        Assert.assertFalse((boolean)charges.isPaid(invoice));
        FinancialAct payment = this.createPayment(MathRules.divide((BigDecimal)invoice.getTotal(), (int)2, (int)2));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        Assert.assertFalse((boolean)charges.isPaid(invoice));
        this.createPayment(invoice.getTotal().subtract(payment.getTotal()));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        Assert.assertTrue((boolean)charges.isPaid(invoice));
    }

    @Test
    public void testIsReversed() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim));
        FinancialAct invoice = this.createInvoice("POSTED", this.createInvoiceItem());
        Assert.assertFalse((boolean)charges.isReversed(invoice));
        this.accountRules.reverse(invoice, new Date());
        Assert.assertTrue((boolean)charges.isReversed(invoice));
    }

    @Test
    public void testGetMatchesForNoChargesForPatient() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Party patient2 = TestHelper.createPatient();
        Charges charges = new Charges(this.createClaimContext(claim));
        FinancialAct invoice = this.createInvoice("POSTED", this.createInvoiceItem());
        this.createPayment(invoice.getTotal());
        invoice = (FinancialAct)this.get((IMObject)invoice);
        this.checkMatchesError(charges.getMatches(invoice, patient2), "There are no unclaimed items in this Invoice for " + patient2.getName() + ".");
    }

    @Test
    public void testGetMatchesForReversedInvoice() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim));
        FinancialAct invoice = this.createInvoice("POSTED", this.createInvoiceItem());
        this.createPayment(invoice.getTotal());
        invoice = (FinancialAct)this.get((IMObject)invoice);
        this.accountRules.reverse(invoice, new Date());
        this.checkMatchesError(charges.getMatches(invoice, this.patient), "This Invoice cannot be claimed as it has been reversed.");
    }

    @Test
    public void testGetMatchesForPartPaidInvoice() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim));
        FinancialAct invoice = this.createInvoice("POSTED", this.createInvoiceItem());
        this.createPayment(MathRules.divide((BigDecimal)invoice.getTotal(), (int)2, (int)2));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        this.checkMatchesError(charges.getMatches(invoice, this.patient), "This Invoice cannot be claimed as it is part paid.");
    }

    @Test
    public void testGetMatchesForClaimedItem() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim)){

            public boolean canClaim(Act item) {
                return false;
            }
        };
        FinancialAct item = this.createInvoiceItem();
        FinancialAct invoice = this.createInvoice("POSTED", item);
        this.createPayment(invoice.getTotal());
        invoice = (FinancialAct)this.get((IMObject)invoice);
        this.checkMatchesError(charges.getMatches(invoice, this.patient), "All items in this Invoice have been claimed.");
    }

    @Test
    public void testGetMatchesForUnpaidInvoiceWithNoGapClaimAvailable() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim));
        FinancialAct invoice = this.createInvoice("POSTED", this.createInvoiceItem());
        this.checkMatchesError(charges.getMatches(invoice, this.patient), "This Invoice cannot be claimed as it has not been paid.");
    }

    @Test
    public void testGetMatchesForUnpaidInvoiceWithGapClaimAvailable() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        Charges charges = new Charges(this.createClaimContext(claim)){

            public boolean isGapClaimAvailable() {
                return true;
            }
        };
        FinancialAct invoice = this.createInvoice("POSTED", this.createInvoiceItem());
        this.checkMatchesError(charges.getMatches(invoice, this.patient), "This Invoice cannot be claimed as it has not been paid.\n\nTo claim unpaid invoices, select Gap Claim\n\nNOTE: All invoices in a gap claim must be unpaid.");
    }

    @Test
    public void testGetMatchesForGapClaim() {
        FinancialAct claim = (FinancialAct)this.create("act.patientInsuranceClaim", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)claim);
        bean.setValue("gapClaim", (Object)true);
        Charges charges = new Charges(this.createClaimContext(claim)){

            public boolean isGapClaimAvailable() {
                return true;
            }
        };
        FinancialAct item = this.createInvoiceItem();
        FinancialAct invoice = this.createInvoice("POSTED", item);
        Charges.Matches matches = charges.getMatches(invoice, this.patient);
        Assert.assertEquals(Collections.singletonList(item), (Object)matches.getItems());
        this.createPayment(MathRules.divide((BigDecimal)invoice.getTotal(), (int)2, (int)2));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        Assert.assertEquals(Collections.singletonList(item), (Object)charges.getMatches(invoice, this.patient).getItems());
        this.createPayment(invoice.getTotal());
        invoice = (FinancialAct)this.get((IMObject)invoice);
        Assert.assertEquals(Collections.singletonList(item), (Object)charges.getMatches(invoice, this.patient).getItems());
    }

    private void checkMatchesError(Charges.Matches matches, String expected) {
        Assert.assertEquals((Object)expected, (Object)matches.getMessage());
        Assert.assertEquals((long)0L, (long)matches.getItems().size());
    }

    private ClaimContext createClaimContext(FinancialAct claim) {
        return new ClaimContext(claim, this.customer, this.patient, this.context.getPractice(), this.getArchetypeService(), this.insuranceRules, (InsuranceServices)Mockito.mock(InsuranceServices.class), (InsuranceFactory)Mockito.mock(InsuranceFactory.class));
    }

    private FinancialAct createPayment(BigDecimal total) {
        List payment = FinancialTestHelper.createPaymentCash((BigDecimal)total, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save(payment);
        return (FinancialAct)payment.get(0);
    }

    private FinancialAct createInvoice(String status, FinancialAct ... items) {
        List invoice = FinancialTestHelper.createChargesInvoice((Party)this.customer, (User)this.clinician, (String)status, (FinancialAct[])items);
        this.save(invoice);
        return (FinancialAct)invoice.get(0);
    }

    private FinancialAct createInvoiceItem() {
        BigDecimal discount = BigDecimal.ONE;
        BigDecimal tax = new BigDecimal("0.82");
        return this.createInvoiceItem(new Date(), TestHelper.createProduct(), BigDecimal.ONE, BigDecimal.TEN, discount, tax);
    }

    private FinancialAct createInvoiceItem(Date date, Product product, BigDecimal quantity, BigDecimal price, BigDecimal discount, BigDecimal tax) {
        return FinancialTestHelper.createInvoiceItem((Date)date, (Party)this.patient, (User)this.clinician, (Product)product, (BigDecimal)quantity, (BigDecimal)BigDecimal.ZERO, (BigDecimal)price, (BigDecimal)discount, (BigDecimal)tax);
    }
}

