/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.archetype.rules.laboratory.LaboratoryTestHelper;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.patient.history.TextSearch;
import org.springframework.beans.factory.annotation.Autowired;

public class TextSearchTestCase
extends ArchetypeServiceTest {
    private User clinician;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private static final String TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.";

    @Before
    public void setUp() {
        this.clinician = this.userFactory.createClinician("Jo", "Bloggs");
    }

    @Test
    public void testInvoiceItem() {
        Act act = (Act)this.create("act.customerAccountInvoiceItem", Act.class);
        Product product = this.createProduct("Z Aspirin");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("clinician", (IMObject)this.clinician);
        bean.setTarget("product", (IMObject)product);
        bean.setTarget("batch", (IMObject)this.createBatch(product));
        this.check(act, true, "aspirin", true, true);
        this.check(act, false, "vaccine", true, true);
        this.check(act, true, "123456789", true, true);
        this.check(act, false, "1234567890", true, true);
        this.check(act, false, "123456789", true, false);
        this.check(act, true, "Jo Bloggs", true, true);
        this.check(act, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testPatientClinicalAddendum() {
        Act act = (Act)this.create("act.patientClinicalAddendum", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("note", (Object)TEXT);
        bean.setTarget("clinician", (IMObject)this.clinician);
        this.check(act, true, "magna", true, true);
        this.check(act, false, "fido", true, true);
        this.check(act, true, "Jo Bloggs", true, true);
        this.check(act, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testPatientClinicalAddendumWithDocument() {
        DocumentAct note = (DocumentAct)this.create("act.patientClinicalAddendum", DocumentAct.class);
        note.setDocument(this.createDocument());
        this.check((Act)note, true, "long", true, true);
        this.check((Act)note, false, "fido", true, true);
    }

    @Test
    public void testPatientClinicalEvent() {
        Act act = (Act)this.create("act.patientClinicalEvent", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("reason", (Object)TestHelper.getLookup((String)"lookup.visitReason", (String)"CHECKUP").getCode());
        bean.setValue("title", (Object)"Annual health check");
        bean.setTarget("clinician", (IMObject)this.clinician);
        this.check(act, true, "Checkup", true, true);
        this.check(act, true, "health check", true, true);
        this.check(act, false, "surgery", true, true);
        this.check(act, true, "Jo Bloggs", true, true);
        this.check(act, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testPatientClinicalNote() {
        Act note = (Act)this.create("act.patientClinicalNote", Act.class);
        IMObjectBean bean = this.getBean((IMObject)note);
        bean.setValue("note", (Object)TEXT);
        bean.setTarget("clinician", (IMObject)this.clinician);
        this.check(note, true, "magna", true, true);
        this.check(note, false, "fido", true, true);
        this.check(note, true, "Jo Bloggs", true, true);
        this.check(note, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testPatientClinicalNoteWithDocument() {
        DocumentAct note = (DocumentAct)this.create("act.patientClinicalNote", DocumentAct.class);
        note.setDocument(this.createDocument());
        this.check((Act)note, true, "long", true, true);
        this.check((Act)note, false, "fido", true, true);
    }

    @Test
    public void testPatientClinicalProblem() {
        Act act = (Act)this.create("act.patientClinicalProblem", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("presentingComplaint", (Object)TestHelper.getLookup((String)"lookup.presentingComplaint", (String)"VOMITING").getCode());
        bean.setValue("reason", (Object)TestHelper.getLookup((String)"lookup.diagnosis", (String)"ABDOMINAL_INJURY").getCode());
        bean.setTarget("clinician", (IMObject)this.clinician);
        this.check(act, true, "vomiting", true, true);
        this.check(act, true, "injury", true, true);
        this.check(act, false, "surgery", true, true);
        this.check(act, true, "Jo Bloggs", true, true);
        this.check(act, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testAttachment() {
        this.checkAttachment("act.patientDocumentAttachment");
    }

    @Test
    public void testAttachmentVersion() {
        this.checkAttachment("act.patientDocumentAttachmentVersion");
    }

    @Test
    public void testForm() {
        DocumentAct act = (DocumentAct)this.create("act.patientDocumentForm", DocumentAct.class);
        Entity template = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").name("Z Certificate")).build();
        act.setDescription(TEXT);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("clinician", (IMObject)this.clinician);
        bean.setTarget("documentTemplate", (IMObject)template);
        bean.setTarget("product", (IMObject)this.createProduct("Z Vaccine"));
        this.check((Act)act, true, "magna", true, true);
        this.check((Act)act, true, "certificate", true, true);
        this.check((Act)act, true, "vaccine", true, true);
        this.check((Act)act, false, "vaccination", true, true);
        this.check((Act)act, true, "Jo Bloggs", true, true);
        this.check((Act)act, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testImage() {
        this.checkImage("act.patientDocumentImage");
    }

    @Test
    public void testImageVersion() {
        this.checkImage("act.patientDocumentImageVersion");
    }

    @Test
    public void testLetter() {
        this.checkLetter("act.patientDocumentLetter");
    }

    @Test
    public void testLetterVersion() {
        this.checkLetter("act.patientDocumentLetterVersion");
    }

    @Test
    public void testInvestigation() {
        this.checkInvestigation("act.patientInvestigation");
    }

    @Test
    public void testInvestigationVersion() {
        this.checkInvestigation("act.patientInvestigationVersion");
    }

    @Test
    public void testMedication() {
        Act act = (Act)this.create("act.patientMedication", Act.class);
        Product product = this.createProduct("Z Revolution");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("clinician", (IMObject)this.clinician);
        bean.setTarget("product", (IMObject)product);
        bean.setTarget("batch", (IMObject)this.createBatch(product));
        this.check(act, true, "revolution", true, true);
        this.check(act, false, "advocate", true, true);
        this.check(act, true, "123456789", true, true);
        this.check(act, false, "1234567890", true, true);
        this.check(act, false, "123456789", true, false);
        this.check(act, true, "Jo Bloggs", true, true);
        this.check(act, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testWeight() {
        Act act = (Act)this.create("act.patientWeight", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("weight", (Object)BigDecimal.TEN);
        bean.setTarget("clinician", (IMObject)this.clinician);
        this.check(act, true, "10 kilograms", true, true);
        this.check(act, false, "5", true, true);
        this.check(act, false, "kg", true, true);
        this.check(act, true, "Jo Bloggs", true, true);
        this.check(act, false, "Jo Bloggs", false, true);
    }

    @Test
    public void testEmail() {
        Act act = (Act)this.create("act.customerCommunicationEmail", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("description", (Object)"Yearly vaccination reminder");
        bean.setValue("from", (Object)"info@vetsrus.com");
        bean.setValue("address", (Object)"foo@bar.com");
        bean.setValue("cc", (Object)"foo@bar.org");
        bean.setValue("bcc", (Object)"reminders@vetsrus.com");
        bean.setValue("reason", (Object)TestHelper.getLookup((String)"lookup.customerCommunicationReason", (String)"A_REMINDER").getCode());
        bean.setValue("message", (Object)TEXT);
        bean.setValue("note", (Object)"a note");
        bean.setValue("document", (Object)this.createDocument());
        this.check(act, true, "yearly vaccination", true, true);
        this.check(act, true, "info@vetsrus.com", true, true);
        this.check(act, true, "foo@bar.com", true, true);
        this.check(act, true, "foo@bar.org", true, true);
        this.check(act, true, "reminders@vetsrus.com", true, true);
        this.check(act, true, "A Reminder", true, true);
        this.check(act, true, "magna", true, true);
        this.check(act, true, "a note", true, true);
        this.check(act, true, "long content", true, true);
    }

    @Test
    public void testCommunicationNote() {
        Act act = (Act)this.create("act.customerCommunicationNote", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("description", (Object)"Yearly vaccination reminder");
        bean.setValue("reason", (Object)TestHelper.getLookup((String)"lookup.customerCommunicationReason", (String)"A_REMINDER_2").getCode());
        bean.setValue("message", (Object)TEXT);
        bean.setValue("document", (Object)this.createDocument());
        this.check(act, true, "yearly vaccination", true, true);
        this.check(act, true, "A Reminder 2", true, true);
        this.check(act, true, "magna", true, true);
        this.check(act, true, "long content", true, true);
    }

    @Test
    public void testMail() {
        Act act = (Act)this.create("act.customerCommunicationMail", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("description", (Object)"Yearly vaccination reminder");
        bean.setValue("address", (Object)"12 Foo St");
        bean.setValue("reason", (Object)TestHelper.getLookup((String)"lookup.customerCommunicationReason", (String)"A_REMINDER_3").getCode());
        bean.setValue("message", (Object)TEXT);
        bean.setValue("note", (Object)"a note");
        TextDocumentHandler handler = new TextDocumentHandler((ArchetypeService)this.getArchetypeService());
        Document document = handler.create("mail.txt", "long content");
        this.save((IMObject)document);
        bean.setValue("document", (Object)document.getObjectReference());
        this.check(act, true, "yearly vaccination", true, true);
        this.check(act, true, "12 Foo St", true, true);
        this.check(act, true, "A Reminder 3", true, true);
        this.check(act, true, "magna", true, true);
        this.check(act, true, "a note", true, true);
        this.check(act, true, "long content", true, true);
    }

    @Test
    public void testPhone() {
        Act act = (Act)this.create("act.customerCommunicationPhone", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("description", (Object)"Yearly vaccination reminder");
        bean.setValue("address", (Object)"123456789");
        bean.setValue("reason", (Object)TestHelper.getLookup((String)"lookup.customerCommunicationReason", (String)"A_REMINDER_4").getCode());
        bean.setValue("message", (Object)TEXT);
        bean.setValue("note", (Object)"a note");
        bean.setValue("document", (Object)this.createDocument());
        this.check(act, true, "yearly vaccination", true, true);
        this.check(act, true, "123456789", true, true);
        this.check(act, true, "A Reminder 4", true, true);
        this.check(act, true, "magna", true, true);
        this.check(act, true, "a note", true, true);
        this.check(act, true, "long content", true, true);
    }

    @Test
    public void testSMS() {
        Act act = (Act)this.create("act.smsMessage", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("description", (Object)"Yearly vaccination reminder");
        bean.setValue("phone", (Object)"123456789");
        bean.setValue("reason", (Object)TestHelper.getLookup((String)"lookup.customerCommunicationReason", (String)"A_REMINDER_5").getCode());
        bean.setValue("message", (Object)TEXT);
        bean.setValue("note", (Object)"a note");
        this.check(act, true, "yearly vaccination", true, true);
        this.check(act, true, "123456789", true, true);
        this.check(act, true, "A Reminder 5", true, true);
        this.check(act, true, "magna", true, true);
        this.check(act, true, "a note", true, true);
    }

    private Reference createDocument() {
        TextDocumentHandler handler = new TextDocumentHandler((ArchetypeService)this.getArchetypeService());
        Document document = handler.create("context.txt", "long content");
        this.save((IMObject)document);
        return document.getObjectReference();
    }

    private Entity createBatch(Product product) {
        return ProductTestHelper.createBatch((String)"123456789", (Product)product, (Date)new Date(), (Party[])new Party[0]);
    }

    private Product createProduct(String name) {
        return (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().name(name)).build();
    }

    private void checkAttachment(String archetype) {
        DocumentAct act = (DocumentAct)this.create(archetype, DocumentAct.class);
        act.setDescription(TEXT);
        act.setFileName("Consent.pdf");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("clinician", (IMObject)this.clinician);
        this.check((Act)act, true, "magna", true, true);
        this.check((Act)act, true, "consent", true, true);
        this.check((Act)act, false, "vaccination", true, true);
        this.check((Act)act, true, "Jo Bloggs", true, true);
        this.check((Act)act, false, "Jo Bloggs", false, true);
    }

    private void checkImage(String archetype) {
        DocumentAct act = (DocumentAct)this.create(archetype, DocumentAct.class);
        act.setDescription(TEXT);
        act.setFileName("Image.pdf");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("clinician", (IMObject)this.clinician);
        this.check((Act)act, true, "magna", true, true);
        this.check((Act)act, true, "image.pdf", true, true);
        this.check((Act)act, false, "vaccination", true, true);
        this.check((Act)act, true, "Jo Bloggs", true, true);
        this.check((Act)act, false, "Jo Bloggs", false, true);
    }

    private void checkLetter(String archetype) {
        DocumentAct act = (DocumentAct)this.create(archetype, DocumentAct.class);
        act.setDescription(TEXT);
        act.setFileName("Consent.pdf");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("clinician", (IMObject)this.clinician);
        bean.setTarget("product", (IMObject)this.createProduct("Z Vaccine"));
        this.check((Act)act, true, "magna", true, true);
        this.check((Act)act, true, "consent", true, true);
        this.check((Act)act, true, "vaccine", true, true);
        this.check((Act)act, false, "vaccination", true, true);
        this.check((Act)act, true, "Jo Bloggs", true, true);
        this.check((Act)act, false, "Jo Bloggs", false, true);
    }

    private void checkInvestigation(String archetype) {
        Entity investigationType = LaboratoryTestHelper.createInvestigationType();
        investigationType.setName("Z Test");
        this.save((IMObject)investigationType);
        DocumentAct act = (DocumentAct)this.create(archetype, DocumentAct.class);
        act.setDescription(TEXT);
        act.setFileName("Biopsy.pdf");
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("id", (Object)123456);
        bean.setTarget("investigationType", (IMObject)investigationType);
        bean.setTarget("clinician", (IMObject)this.clinician);
        boolean hasProduct = bean.hasNode("product");
        if (hasProduct) {
            bean.setTarget("product", (IMObject)this.createProduct("Z Service"));
        }
        this.check((Act)act, true, "123456", true, true);
        this.check((Act)act, false, "1234567", true, true);
        this.check((Act)act, true, "magna", true, true);
        this.check((Act)act, true, "biopsy", true, true);
        this.check((Act)act, true, "test", true, true);
        if (hasProduct) {
            this.check((Act)act, true, "service", true, true);
        }
        this.check((Act)act, false, "vaccination", true, true);
        this.check((Act)act, true, "Jo Bloggs", true, true);
        this.check((Act)act, false, "Jo Bloggs", false, true);
    }

    private void check(Act act, boolean match, String text, boolean searchClinicians, boolean searchBatches) {
        IArchetypeService service = this.getArchetypeService();
        service.deriveValues((IMObject)act);
        TextSearch search = new TextSearch(text, searchClinicians, searchBatches, service);
        Assert.assertEquals((Object)match, (Object)search.test(act));
    }
}

