/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.PatientMedicalRecordLinker;

public class PatientMedicalRecordLinkerTestCase
extends AbstractAppTest {
    protected Party patient;

    @Test
    public void testLinkNote() {
        Act event = this.createEvent();
        Act note = this.createNote();
        this.link(event, note);
        event = (Act)this.get((IMObject)event);
        note = (Act)this.get((IMObject)note);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)note));
    }

    @Test
    public void testLinkProblem() {
        Act event = this.createEvent();
        Act problem = this.createProblem();
        Act note = this.createNote();
        IMObjectBean bean = this.getBean((IMObject)problem);
        bean.addTarget("items", (IMObject)note, "problem");
        this.save((IMObject[])new Act[]{problem, note});
        this.link(event, problem);
        event = (Act)this.get((IMObject)event);
        problem = (Act)this.get((IMObject)problem);
        note = (Act)this.get((IMObject)note);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)problem));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)note));
        IMObjectBean problemBean = this.getBean((IMObject)problem);
        Assert.assertTrue((boolean)problemBean.hasTarget("items", (IMObject)note));
    }

    @Before
    public void setUp() {
        super.setUp();
        this.patient = TestHelper.createPatient((boolean)true);
    }

    protected Act createEvent() {
        Act event = PatientTestHelper.createEvent((Party)this.patient, null);
        this.save((IMObject)event);
        return event;
    }

    protected Act createProblem() {
        return PatientTestHelper.createProblem((Date)new Date(), (Party)this.patient, (User)null, (Act[])new Act[0]);
    }

    protected Act createNote() {
        Act note = PatientTestHelper.createNote((Date)new Date(), (Party)this.patient);
        this.save((IMObject)note);
        return note;
    }

    protected void link(Act event, Act item) {
        PatientMedicalRecordLinker linker = new PatientMedicalRecordLinker(event, item);
        linker.run();
    }
}

