/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import org.junit.Assert;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.PaymentItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorPaymentItemEditor;

public class TestCustomerPaymentEditor
extends CustomerPaymentEditor {
    public TestCustomerPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
    }

    public TestPaymentItemRelationshipCollectionEditor getItems() {
        return (TestPaymentItemRelationshipCollectionEditor)super.getItems();
    }

    public void setPaymentProcessorService(PaymentProcessorService service) {
        this.getItems().setPaymentProcessorService(service);
    }

    public IMObjectEditor addItem(String archetype, Entity paymentProcessor) {
        return this.getItems().onArchetypeSelected(archetype, paymentProcessor);
    }

    public void delete(IMObject object) {
        this.getItems().delete(object);
    }

    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        return new TestPaymentItemRelationshipCollectionEditor(items, (Act)this.getObject(), this.getLayoutContext());
    }

    public static class TestPaymentItemRelationshipCollectionEditor
    extends PaymentItemRelationshipCollectionEditor {
        private PaymentProcessorService service;

        public TestPaymentItemRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
            super(property, act, context);
        }

        public void setPaymentProcessorService(PaymentProcessorService service) {
            this.service = service;
            for (IMObjectEditor editor : this.getEditors()) {
                if (!(editor instanceof TestPaymentProcessorPaymentItemEditor)) continue;
                ((TestPaymentProcessorPaymentItemEditor)editor).setService(service);
            }
        }

        public void delete(IMObject object) {
            Assert.assertTrue((boolean)this.getCurrentObjects().contains(object));
            this.edit(object);
            this.onDelete();
        }

        public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
            Object result;
            if (object.isA(new String[]{"act.customerAccountPaymentPP", "act.customerAccountRefundPP"})) {
                TestPaymentProcessorPaymentItemEditor editor = new TestPaymentProcessorPaymentItemEditor((FinancialAct)object, (FinancialAct)this.getObject(), context);
                editor.setService(this.service);
                this.initialise((IMObjectEditor)editor);
                result = editor;
            } else {
                result = super.createEditor(object, context);
            }
            return result;
        }
    }
}

