/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.object.BuiltObjects;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.i18n.Messages;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.paymentprocessor.exception.PaymentProcessorException;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.EFTPaymentItemEditor;
import org.openvpms.web.workspace.customer.payment.PaymentItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorTestHelper;
import org.openvpms.web.workspace.customer.payment.TestCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorService;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerPaymentEditorTestCase
extends AbstractAppTest {
    @Autowired
    private CustomerAccountRules rules;
    @Autowired
    private IMObjectEditorFactory editorFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPaymentProcessorFactory paymentProcessorFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testFactory() {
        FinancialAct payment = (FinancialAct)this.create("act.customerAccountPayment", FinancialAct.class);
        FinancialAct refund = (FinancialAct)this.create("act.customerAccountRefund", FinancialAct.class);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        IMObjectEditor editor1 = this.editorFactory.create((IMObject)payment, (LayoutContext)context);
        Assert.assertTrue((boolean)(editor1 instanceof CustomerPaymentEditor));
        Assert.assertTrue((boolean)(((CustomerPaymentEditor)editor1).getItems() instanceof PaymentItemRelationshipCollectionEditor));
        IMObjectEditor editor2 = this.editorFactory.create((IMObject)refund, (LayoutContext)context);
        Assert.assertTrue((boolean)(editor2 instanceof CustomerPaymentEditor));
        Assert.assertTrue((boolean)(((CustomerPaymentEditor)editor2).getItems() instanceof PaymentItemRelationshipCollectionEditor));
    }

    @Test
    public void testCannotChangeTill() {
        this.checkCannotChangeTill((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkCannotChangeTill((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testMakeSaveableAndPostOnCompletion() {
        this.checkMakeSaveableAndPostOnCompletion((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkMakeSaveableAndPostOnCompletion((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testMakeSaveableAndPostOnCompletionForPostedTransaction() {
        this.checkMakeSaveableAndPostOnCompletionForPostedTransaction((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkMakeSaveableAndPostOnCompletionForPostedTransaction((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testCanDeleteEFTItem() {
        this.checkCanDeleteEFTItem((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkCanDeleteEFTItem((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testCanDeletePaymentProcessorItem() {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        this.checkCanDeletePaymentProcessorItem(processor, (TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkCanDeletePaymentProcessorItem(processor, (TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testDeleteEFTItemWithIncompleteTransaction() {
        TestPaymentRefundBuilder[] builders;
        String message = "Cannot delete EFT. It has an outstanding EFTPOS transaction.";
        for (TestPaymentRefundBuilder builder : builders = new TestPaymentRefundBuilder[]{this.newPayment(), this.newRefund()}) {
            this.verifyDeletionOfEFTItemRejected(builder, "PENDING", message);
            this.verifyDeletionOfEFTItemRejected(builder, "IN_PROGRESS", message);
        }
    }

    @Test
    public void testDeleteApprovedEFTItem() {
        TestPaymentRefundBuilder[] builders;
        String message = "Cannot delete EFT. It has an approved EFTPOS transaction.";
        for (TestPaymentRefundBuilder builder : builders = new TestPaymentRefundBuilder[]{this.newPayment(), this.newRefund()}) {
            this.verifyDeletionOfEFTItemRejected(builder, "APPROVED", message);
        }
    }

    @Test
    public void testDeleteDeclinedErrorEFTItem() {
        TestPaymentRefundBuilder[] builders;
        for (TestPaymentRefundBuilder builder : builders = new TestPaymentRefundBuilder[]{this.newPayment(), this.newRefund()}) {
            this.verifyDeletionOfEFTItemAllowed(builder, "DECLINED");
            this.verifyDeletionOfEFTItemAllowed(builder, "ERROR");
        }
    }

    @Test
    public void testDeleteIncompletePaymentProcessorItem() {
        TestPaymentRefundBuilder[] builders;
        for (TestPaymentRefundBuilder builder : builders = new TestPaymentRefundBuilder[]{this.newPayment(), this.newRefund()}) {
            this.checkDeleteIncompletePaymentProcessorItem(builder, "PENDING");
            this.checkDeleteIncompletePaymentProcessorItem(builder, "IN_PROGRESS");
            this.checkDeleteIncompletePaymentProcessorItem(builder, "SUBMITTED");
        }
    }

    @Test
    public void testDeleteCompletedPaymentProcessorItem() {
        this.checkDeleteCompletedPaymentProcessorItem((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkDeleteCompletedPaymentProcessorItem((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testDeleteCancelledErrorPaymentProcessorItem() {
        TestPaymentRefundBuilder[] builders;
        for (TestPaymentRefundBuilder builder : builders = new TestPaymentRefundBuilder[]{this.newPayment(), this.newRefund()}) {
            this.checkDeleteCancelledErrorPaymentProcessorItem(builder, "CANCELLED");
            this.checkDeleteCancelledErrorPaymentProcessorItem(builder, "ERROR");
        }
    }

    @Test
    public void testIsEmptyOrOnlyHasTransactionItems() {
        this.checkIsEmptyOrOnlyHasTransactionItems((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkIsEmptyOrOnlyHasTransactionItems((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testProcessTransactions() {
        this.checkProcessTransactions((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkProcessTransactions((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testProcessTransactionFailure() {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        TestPaymentBuilder builder = (TestPaymentBuilder)this.newPayment().status("IN_PROGRESS");
        FinancialAct act = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)builder.paymentProcessor().processor(processor)).amount(10)).addTransaction("PENDING")).add()).build();
        String transactionArchetype = act.isA("act.customerAccountPayment") ? "act.paymentProcessorPayment" : "act.paymentProcessorRefund";
        FinancialAct transaction = (FinancialAct)builder.getBuiltObjects().getObject(transactionArchetype, FinancialAct.class);
        TestCustomerPaymentEditor editor = this.createEditor(act);
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        service.setSubmitCallback(txn -> {
            throw new PaymentProcessorException(Messages.create((String)"Submit failed"));
        });
        editor.setPaymentProcessorService(service);
        MutableBoolean called = new MutableBoolean(false);
        try {
            editor.processTransactions(() -> ((MutableBoolean)called).setTrue());
            Assert.fail((String)"Expected processTransactions() to fail");
        }
        catch (PaymentProcessorException expected) {
            Assert.assertEquals((Object)"Submit failed", (Object)expected.getMessage());
        }
        Assert.assertFalse((boolean)called.booleanValue());
        transaction = (FinancialAct)this.get((IMObject)transaction);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)transaction.getStatus());
    }

    @Test
    public void testSplitTransactionsUnsupportedForPaymentProcessorItem() {
        this.checkSplitTransactionsUnsupportedForPaymentProcessorItem((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkSplitTransactionsUnsupportedForPaymentProcessorItem((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testPaymentProcessorRefundMustCorrespondToPayment() {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)this.newPayment().status("POSTED")).paymentProcessor(processor, 10)).build();
        FinancialAct refund = this.rules.createPaymentProcessorReversal(payment);
        IMObjectBean bean = this.getBean((IMObject)refund);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        FinancialAct refundPP = (FinancialAct)items.get(0);
        refundPP.setTotal(BigDecimal.ONE);
        refund.setTotal(BigDecimal.ONE);
        this.save((IMObject[])new FinancialAct[]{refundPP, refund});
        TestCustomerPaymentEditor editor = this.createEditor(refund);
        editor.setPaymentProcessorService(new TestPaymentProcessorService(false));
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"The total must be $10.00");
    }

    @Test
    public void testCanEditEFTItemForActPostedDuringEdit() {
        Party customer = this.customerFactory.createCustomer();
        Entity till = this.practiceFactory.createTill();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(till)).eft(10).status("IN_PROGRESS")).build();
        this.checkCanEditEFTItemForActPostedDuringEdit(payment);
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(customer)).till(till)).eft(10).status("IN_PROGRESS")).build();
        this.checkCanEditEFTItemForActPostedDuringEdit(refund);
    }

    private void checkCannotChangeTill(TestPaymentRefundBuilder<?> builder) {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct act = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("PENDING", terminal)).add().build();
        TestCustomerPaymentEditor editor = this.createEditor(act);
        EditorTestHelper.assertValid((Modifiable)editor);
        editor.setTill(this.practiceFactory.createTill());
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Once an EFT transaction is in progress or has been approved, the till cannot be changed.");
    }

    private void checkMakeSaveableAndPostOnCompletion(TestPaymentRefundBuilder<?> builder) {
        FinancialAct payment = ((TestPaymentRefundBuilder)builder.status("POSTED")).build(false);
        TestCustomerPaymentEditor editor = this.createEditor(payment);
        Assert.assertEquals((Object)"POSTED", (Object)editor.getObject().getStatus());
        Assert.assertFalse((boolean)editor.postOnCompletion());
        Assert.assertTrue((boolean)editor.canChangeStatus());
        editor.makeSaveableAndPostOnCompletion();
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)editor.getObject().getStatus());
        Assert.assertTrue((boolean)editor.postOnCompletion());
        Assert.assertTrue((boolean)editor.canChangeStatus());
    }

    private void checkMakeSaveableAndPostOnCompletionForPostedTransaction(TestPaymentRefundBuilder<?> builder) {
        FinancialAct act = (FinancialAct)((TestPaymentRefundBuilder)builder.cash(10).status("POSTED")).build();
        TestCustomerPaymentEditor editor = this.createEditor(act);
        Assert.assertTrue((boolean)editor.isPosted());
        Assert.assertFalse((boolean)editor.canChangeStatus());
        try {
            editor.makeSaveableAndPostOnCompletion();
            Assert.fail((String)"Expected makeSaveableAndPostOnCompletion to throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void checkCanDeleteEFTItem(TestPaymentRefundBuilder<?> builder) {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        builder.status("IN_PROGRESS");
        FinancialAct act1 = (FinancialAct)((TestEFTItemBuilder)builder.eft().amount(10)).add().build();
        TestCustomerPaymentEditor editor1 = this.createEditor(act1);
        Assert.assertTrue((boolean)editor1.canDelete());
        FinancialAct act2 = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("PENDING", terminal)).add().build();
        TestCustomerPaymentEditor editor2 = this.createEditor(act2);
        Assert.assertFalse((boolean)editor2.canDelete());
        FinancialAct act3 = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("IN_PROGRESS", terminal)).add().build();
        TestCustomerPaymentEditor editor3 = this.createEditor(act3);
        Assert.assertFalse((boolean)editor3.canDelete());
        FinancialAct act4 = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("IN_PROGRESS", terminal)).add().build();
        TestCustomerPaymentEditor editor4 = this.createEditor(act4);
        Assert.assertFalse((boolean)editor4.canDelete());
        FinancialAct act5 = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("APPROVED", terminal)).add().build();
        TestCustomerPaymentEditor editor5 = this.createEditor(act5);
        Assert.assertFalse((boolean)editor5.canDelete());
        FinancialAct act6 = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("NO_TERMINAL", terminal)).add().build();
        TestCustomerPaymentEditor editor6 = this.createEditor(act6);
        Assert.assertTrue((boolean)editor6.canDelete());
        FinancialAct act7 = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("DECLINED", terminal)).add().build();
        TestCustomerPaymentEditor editor7 = this.createEditor(act7);
        Assert.assertTrue((boolean)editor7.canDelete());
    }

    private void checkCanDeletePaymentProcessorItem(Entity processor, TestPaymentRefundBuilder<?> builder) {
        builder.status("IN_PROGRESS");
        FinancialAct act1 = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).add().build();
        TestCustomerPaymentEditor editor1 = this.createEditor(act1);
        Assert.assertTrue((boolean)editor1.canDelete());
        FinancialAct act2 = (FinancialAct)((TestPaymentProcessorItemBuilder)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).amount(10)).addTransaction("PENDING").add().build();
        TestCustomerPaymentEditor editor2 = this.createEditor(act2);
        Assert.assertFalse((boolean)editor2.canDelete());
        FinancialAct act3 = (FinancialAct)((TestPaymentProcessorItemBuilder)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).amount(10)).addTransaction("IN_PROGRESS").add().build();
        TestCustomerPaymentEditor editor3 = this.createEditor(act3);
        Assert.assertFalse((boolean)editor3.canDelete());
        FinancialAct act4 = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).addTransaction("SUBMITTED").add().build();
        TestCustomerPaymentEditor editor4 = this.createEditor(act4);
        Assert.assertFalse((boolean)editor4.canDelete());
        FinancialAct act5 = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).addTransaction("COMPLETED").add().build();
        TestCustomerPaymentEditor editor5 = this.createEditor(act5);
        Assert.assertFalse((boolean)editor5.canDelete());
        FinancialAct act6 = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).addTransaction("CANCELLED").add().build();
        TestCustomerPaymentEditor editor6 = this.createEditor(act6);
        Assert.assertTrue((boolean)editor6.canDelete());
        FinancialAct act7 = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).addTransaction("ERROR").add().build();
        TestCustomerPaymentEditor editor7 = this.createEditor(act7);
        Assert.assertTrue((boolean)editor7.canDelete());
    }

    private void verifyDeletionOfEFTItemRejected(TestPaymentRefundBuilder<?> builder, String status, String message) {
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        builder.status("IN_PROGRESS");
        FinancialAct act = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction(status, terminal)).add().build();
        BuiltObjects objects = builder.getBuiltObjects();
        String itemArchetype = act.isA("act.customerAccountPayment") ? "act.customerAccountPaymentEFT" : "act.customerAccountRefundEFT";
        String transactionArchetype = act.isA("act.customerAccountPayment") ? "act.EFTPOSPayment" : "act.EFTPOSRefund";
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        List transactions = objects.getObjects(transactionArchetype, FinancialAct.class);
        Assert.assertEquals((long)3L, (long)transactions.size());
        FinancialAct transaction = this.getLatestTransaction(item);
        TestCustomerPaymentEditor editor = this.createEditor(act);
        editor.setPaymentProcessorService(service);
        editor.delete((IMObject)item);
        String title = "Delete EFTPOS?";
        EchoTestHelper.findMessageDialogAndFireButton(InformationDialog.class, (String)title, (String)message, (String)"ok");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNotNull((Object)this.get((IMObject)item));
        transaction = (FinancialAct)this.get((IMObject)transaction);
        Assert.assertEquals((Object)status, (Object)transaction.getStatus());
        transactions.forEach(t -> Assert.assertNotNull((Object)this.get((IMObject)t)));
    }

    private void verifyDeletionOfEFTItemAllowed(TestPaymentRefundBuilder<?> builder, String status) {
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        ((TestPaymentRefundBuilder)builder.status("IN_PROGRESS")).cash(10);
        FinancialAct act = (FinancialAct)((TestEFTItemBuilder)((TestEFTItemBuilder)((TestEFTItemBuilder)((TestEFTItemBuilder)builder.eft().amount(10)).addTransaction("DECLINED", terminal)).addTransaction("ERROR", terminal)).addTransaction(status, terminal)).add().build();
        BuiltObjects objects = builder.getBuiltObjects();
        String itemArchetype = act.isA("act.customerAccountPayment") ? "act.customerAccountPaymentEFT" : "act.customerAccountRefundEFT";
        String transactionArchetype = act.isA("act.customerAccountPayment") ? "act.EFTPOSPayment" : "act.EFTPOSRefund";
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        List transactions = objects.getObjects(transactionArchetype, FinancialAct.class);
        Assert.assertEquals((long)3L, (long)transactions.size());
        FinancialAct transaction = this.getLatestTransaction(item);
        TestCustomerPaymentEditor editor = this.createEditor(act);
        editor.setPaymentProcessorService(service);
        editor.delete((IMObject)item);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Delete EFT?", (String)"Are you sure you want to delete the EFT?", (String)"yes");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)item));
        transaction = (FinancialAct)this.get((IMObject)transaction);
        Assert.assertEquals((Object)status, (Object)transaction.getStatus());
        transactions.forEach(t -> Assert.assertNotNull((Object)this.get((IMObject)t)));
    }

    private void checkDeleteIncompletePaymentProcessorItem(TestPaymentRefundBuilder<?> builder, String status) {
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        ((TestPaymentRefundBuilder)builder.status("IN_PROGRESS")).cash(10);
        FinancialAct act = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).addTransaction("ERROR").addTransaction(status).add().build();
        BuiltObjects objects = builder.getBuiltObjects();
        String itemArchetype = act.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        String transactionArchetype = act.isA("act.customerAccountPayment") ? "act.paymentProcessorPayment" : "act.paymentProcessorRefund";
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        List transactions = objects.getObjects(transactionArchetype, FinancialAct.class);
        Assert.assertEquals((long)2L, (long)transactions.size());
        FinancialAct transaction = this.getLatestTransaction(item);
        TestCustomerPaymentEditor editor = this.createEditor(act);
        editor.setPaymentProcessorService(service);
        editor.delete((IMObject)item);
        String title = "Cancel " + processor.getName() + "?";
        String message = "The " + processor.getName() + " transaction needs to be cancelled before it can be deleted.\nContinue?";
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)title, (String)message, (String)"yes");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)item));
        transaction = (FinancialAct)this.get((IMObject)transaction);
        Assert.assertEquals((Object)"CANCELLED", (Object)transaction.getStatus());
        transactions.forEach(t -> Assert.assertNotNull((Object)this.get((IMObject)t)));
    }

    private void checkDeleteCompletedPaymentProcessorItem(TestPaymentRefundBuilder<?> builder) {
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        builder.status("IN_PROGRESS");
        FinancialAct act = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).addTransaction("CANCELLED").addTransaction("COMPLETED").add().build();
        BuiltObjects objects = builder.getBuiltObjects();
        String itemArchetype = act.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        String transactionArchetype = act.isA("act.customerAccountPayment") ? "act.paymentProcessorPayment" : "act.paymentProcessorRefund";
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        List transactions = objects.getObjects(transactionArchetype, FinancialAct.class);
        Assert.assertEquals((long)2L, (long)transactions.size());
        FinancialAct transaction = this.getLatestTransaction(item);
        TestCustomerPaymentEditor editor = this.createEditor(act);
        editor.setPaymentProcessorService(service);
        editor.delete((IMObject)item);
        String title = "Delete " + processor.getName() + "?";
        String message = "Cannot delete " + processor.getName() + ". It has a completed Payment Processor transaction.";
        EchoTestHelper.findMessageDialogAndFireButton(InformationDialog.class, (String)title, (String)message, (String)"ok");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNotNull((Object)this.get((IMObject)item));
        transaction = (FinancialAct)this.get((IMObject)transaction);
        Assert.assertEquals((Object)"COMPLETED", (Object)transaction.getStatus());
        transactions.forEach(t -> Assert.assertNotNull((Object)this.get((IMObject)t)));
    }

    private void checkDeleteCancelledErrorPaymentProcessorItem(TestPaymentRefundBuilder<?> builder, String status) {
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        builder.status("IN_PROGRESS");
        FinancialAct act = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.cash(10).paymentProcessor().processor(processor).amount(10)).addTransaction("ERROR").addTransaction(status).add().build();
        BuiltObjects objects = builder.getBuiltObjects();
        String itemArchetype = act.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        String transactionArchetype = act.isA("act.customerAccountPayment") ? "act.paymentProcessorPayment" : "act.paymentProcessorRefund";
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        List transactions = objects.getObjects(transactionArchetype, FinancialAct.class);
        Assert.assertEquals((long)2L, (long)transactions.size());
        FinancialAct transaction = this.getLatestTransaction(item);
        TestCustomerPaymentEditor editor = this.createEditor(act);
        editor.setPaymentProcessorService(service);
        editor.delete((IMObject)item);
        String title = "Delete " + this.getDisplayName(itemArchetype) + "?";
        String message = "Are you sure you want to delete the " + this.getDisplayName(itemArchetype) + "?";
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)title, (String)message, (String)"yes");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)item));
        transaction = (FinancialAct)this.get((IMObject)transaction);
        Assert.assertEquals((Object)status, (Object)transaction.getStatus());
        transactions.forEach(t -> Assert.assertNotNull((Object)this.get((IMObject)t)));
    }

    private void checkIsEmptyOrOnlyHasTransactionItems(TestPaymentRefundBuilder<?> builder) {
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct act1 = builder.build(false);
        this.checkIsEmptyOrOnlyHasTransactionItems(act1, true);
        FinancialAct act2 = (FinancialAct)builder.cash(10).build();
        this.checkIsEmptyOrOnlyHasTransactionItems(act2, false);
        FinancialAct act3 = (FinancialAct)builder.eft(10).build();
        this.checkIsEmptyOrOnlyHasTransactionItems(act3, true);
        FinancialAct act4 = (FinancialAct)builder.paymentProcessor(paymentProcessor, 10).build();
        this.checkIsEmptyOrOnlyHasTransactionItems(act4, true);
        FinancialAct act5 = (FinancialAct)builder.cash(10).paymentProcessor(paymentProcessor, 10).build();
        this.checkIsEmptyOrOnlyHasTransactionItems(act5, false);
    }

    private void checkProcessTransactions(TestPaymentRefundBuilder<?> builder) {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        builder.status("IN_PROGRESS");
        FinancialAct act = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(processor).amount(10)).addTransaction("PENDING").add().build();
        String transactionArchetype = act.isA("act.customerAccountPayment") ? "act.paymentProcessorPayment" : "act.paymentProcessorRefund";
        BuiltObjects objects = builder.getBuiltObjects();
        FinancialAct transaction = (FinancialAct)objects.getObject(transactionArchetype, FinancialAct.class);
        TestCustomerPaymentEditor editor = this.createEditor(act);
        editor.setPaymentProcessorService(new TestPaymentProcessorService());
        MutableInt called = new MutableInt(0);
        editor.processTransactions(() -> ((MutableInt)called).increment());
        Assert.assertEquals((long)0L, (long)called.intValue());
        PaymentProcessorTestHelper.checkPaymentProcessorStatusDialog(act, processor, null);
        Assert.assertEquals((long)1L, (long)called.intValue());
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)transaction);
        Assert.assertEquals((Object)"SUBMITTED", (Object)reloaded.getStatus());
    }

    private void checkSplitTransactionsUnsupportedForPaymentProcessorItem(TestPaymentRefundBuilder<?> builder) {
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct act = (FinancialAct)((TestPaymentRefundBuilder)builder.cash(10).paymentProcessor(paymentProcessor, 10).status("IN_PROGRESS")).build();
        TestCustomerPaymentEditor editor = this.createEditor(act);
        editor.setPaymentProcessorService(new TestPaymentProcessorService());
        String message = "Split " + (act.isA("act.customerAccountPayment") ? "payments" : "refunds") + " are not supported for " + paymentProcessor.getName() + ".";
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)message);
    }

    private FinancialAct getLatestTransaction(FinancialAct item) {
        IMObjectBean bean = this.getBean((IMObject)item);
        return (FinancialAct)bean.getTarget("transactions", FinancialAct.class, Policies.orderBySequence((boolean)false));
    }

    private void checkIsEmptyOrOnlyHasTransactionItems(FinancialAct act, boolean expected) {
        TestCustomerPaymentEditor editor = this.createEditor(act);
        Assert.assertEquals((Object)expected, (Object)editor.isEmptyOrOnlyHasTransactionItems());
    }

    private TestPaymentBuilder newPayment() {
        return (TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill());
    }

    private TestRefundBuilder newRefund() {
        return (TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill());
    }

    private void checkCanEditEFTItemForActPostedDuringEdit(FinancialAct act) {
        TestCustomerPaymentEditor editor1 = this.createEditor(act);
        Assert.assertFalse((boolean)editor1.isPosted());
        Assert.assertTrue((boolean)editor1.canChangeStatus());
        editor1.setStatus("POSTED");
        Assert.assertTrue((boolean)editor1.isPosted());
        Assert.assertTrue((boolean)editor1.canChangeStatus());
        boolean payment = act.isA("act.customerAccountPayment");
        String archetype = payment ? "act.customerAccountPaymentEFT" : "act.customerAccountRefundEFT";
        PaymentItemEditor itemEditor1 = editor1.addItem(archetype);
        Assert.assertTrue((boolean)(itemEditor1 instanceof EFTPaymentItemEditor));
        Editors editors = ((EFTPaymentItemEditor)itemEditor1).getEditors();
        if (payment) {
            Editor cashout = editors.getEditor("cashout");
            Assert.assertNotNull((Object)cashout);
        }
        Editor amount = editors.getEditor("amount");
        Assert.assertNotNull((Object)amount);
        itemEditor1.setAmount(BigDecimal.TEN);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        TestCustomerPaymentEditor editor2 = this.createEditor(act);
        Assert.assertTrue((boolean)editor2.isPosted());
        Assert.assertFalse((boolean)editor2.canChangeStatus());
        List eftItemEditors = editor2.getEFTItemEditors();
        Assert.assertEquals((long)2L, (long)eftItemEditors.size());
        for (EFTPaymentItemEditor editor : eftItemEditors) {
            Editors editors2 = editor.getEditors();
            if (payment) {
                Assert.assertNull((Object)editors2.getEditor("cashout"));
            }
            Assert.assertNull((Object)editors2.getEditor("amount"));
        }
    }

    private TestCustomerPaymentEditor createEditor(FinancialAct act) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        context.setEdit(true);
        TestCustomerPaymentEditor editor = new TestCustomerPaymentEditor(act, null, (LayoutContext)context);
        editor.setAddDefaultItem(false);
        editor.getComponent();
        return editor;
    }
}

