/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.credit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.payment.PaymentEditor;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.credit.AllocationDialog;
import org.openvpms.web.workspace.customer.credit.CreditActEditDialog;
import org.openvpms.web.workspace.customer.credit.GapClaimAllocation;
import org.openvpms.web.workspace.customer.credit.GapClaimAllocationDialog;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.patient.insurance.claim.TestGapInsuranceService;
import org.springframework.beans.factory.annotation.Autowired;

public class CreditActEditDialogTestCase
extends AbstractAppTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private User clinician;
    private Party location;
    private Entity till;
    private Context context;
    private Act policy;
    private TestGapInsuranceService insuranceService;

    @Before
    public void setUp() {
        Party practice = this.practiceFactory.getPractice();
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient();
        this.clinician = this.userFactory.createClinician();
        this.till = this.practiceFactory.createTill();
        this.location = (Party)this.practiceFactory.newLocation().tills(new Entity[]{this.till}).build();
        this.context = new LocalContext();
        this.context.setPractice(practice);
        this.context.setLocation(this.location);
        this.context.setTill(this.till);
        this.context.setClinician(this.clinician);
        this.context.setUser(this.clinician);
        this.context.setCustomer(this.customer);
        this.context.setPatient(this.patient);
        Party insurer = this.insuranceFactory.createInsurer("ZInsurer");
        this.policy = this.insuranceFactory.createPolicy(this.customer, this.patient, insurer, "12345");
        this.insuranceService = new TestGapInsuranceService();
        this.initErrorHandler(this.errors);
    }

    @Test
    public void testChangeAllocationToGapClaimsWithNoReceivedBenefit() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        List<FinancialAct> invoice2Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice2 = invoice2Acts.get(0);
        FinancialAct item2 = invoice2Acts.get(1);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.SUBMITTED);
        FinancialAct claim2 = this.createClaim(item2, Claim.Status.SUBMITTED);
        CreditActEditDialog editDialog = this.pay(BigDecimal.TEN);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1, invoice2);
        allocationDialog.swap(invoice1, invoice2);
        this.checkDebits(allocationDialog, invoice2, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)2L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, BigDecimal.ZERO);
        this.checkAllocation(claim2, allocations, BigDecimal.TEN);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim2.getId(), (long)claimAllocationDialog.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"The benefit amount for this Gap Claim has not been received.\n\nThe claim will be fully paid and the insurer will reimburse the customer.", (Object)claimAllocationDialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), BigDecimal.ZERO);
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice2), BigDecimal.TEN);
        this.checkAllocation((FinancialAct)this.get((IMObject)payment), BigDecimal.TEN);
        this.checkClaim(claim1, Claim.Status.SUBMITTED, null);
        this.checkClaim(claim2, Claim.Status.SUBMITTED, GapClaim.GapStatus.NOTIFIED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testPartialAllocationToUnsubmittedGapClaim() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.PENDING);
        BigDecimal five = BigDecimal.valueOf(5L);
        CreditActEditDialog editDialog = this.pay(five);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)1L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, five);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim1.getId(), (long)claimAllocationDialog.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"The benefit amount for this Gap Claim has not been received.\n\nThe customer may have to pay the full claim amount and be reimbursed by the insurer.", (Object)claimAllocationDialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), five);
        this.checkPayment((FinancialAct)this.get((IMObject)payment), five, five, this.till);
        this.checkAllocation((FinancialAct)this.get((IMObject)payment), five);
        this.checkClaim(claim1, Claim.Status.PENDING, null);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)0L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testAllocationToClaimEqualToGapAmount() {
        Entity gapBenefitTill = this.practiceFactory.createTill();
        this.practiceFactory.updateLocation(this.location).gapBenefitTill(gapBenefitTill).build();
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        BigDecimal five = BigDecimal.valueOf(5L);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.ACCEPTED, GapClaim.GapStatus.RECEIVED, five);
        CreditActEditDialog editDialog = this.pay(five);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)1L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, five);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim1.getId(), (long)claimAllocationDialog.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"By making this payment, the customer is accepting the benefit amount.", (Object)claimAllocationDialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), BigDecimal.TEN);
        this.checkPayment((FinancialAct)this.get((IMObject)payment), five, five, this.till);
        List adjustments = editDialog.getAdjustments();
        Assert.assertEquals((long)1L, (long)adjustments.size());
        this.checkAllocation((FinancialAct)this.get((IMObject)adjustments.get(0)), five);
        this.checkClaim(claim1, Claim.Status.ACCEPTED, GapClaim.GapStatus.NOTIFIED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testAllocationToClaimLessThanGapAmount() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        BigDecimal five = BigDecimal.valueOf(5L);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.ACCEPTED, GapClaim.GapStatus.RECEIVED, five);
        CreditActEditDialog editDialog = this.pay(BigDecimal.ONE);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)1L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, BigDecimal.ONE);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim1.getId(), (long)claimAllocationDialog.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"The customer must pay $4.00 more to receive the benefit amount.", (Object)claimAllocationDialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), BigDecimal.ONE);
        this.checkAllocation((FinancialAct)this.get((IMObject)payment), BigDecimal.ONE);
        Assert.assertEquals((long)0L, (long)editDialog.getAdjustments().size());
        this.checkClaim(claim1, Claim.Status.ACCEPTED, GapClaim.GapStatus.RECEIVED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)0L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testAllocationToClaimGreaterThanGapAmount() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        BigDecimal five = BigDecimal.valueOf(5L);
        BigDecimal six = BigDecimal.valueOf(6L);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.ACCEPTED, GapClaim.GapStatus.RECEIVED, five);
        CreditActEditDialog editDialog = this.pay(six);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)1L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, six);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim1.getId(), (long)claimAllocationDialog.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"By making this payment, the customer is declining the benefit amount.\n\nThe customer needs to pay a further $4.00 to be reimbursed by the insurer.", (Object)claimAllocationDialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), six);
        this.checkPayment((FinancialAct)this.get((IMObject)payment), six, six, this.till);
        Assert.assertEquals((long)0L, (long)editDialog.getAdjustments().size());
        this.checkClaim(claim1, Claim.Status.ACCEPTED, GapClaim.GapStatus.RECEIVED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)0L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testAllocationToClaimEqualToAmount() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        BigDecimal five = BigDecimal.valueOf(5L);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.ACCEPTED, GapClaim.GapStatus.RECEIVED, five);
        CreditActEditDialog editDialog = this.pay(BigDecimal.TEN);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)1L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, BigDecimal.TEN);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim1.getId(), (long)claimAllocationDialog.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"By making this payment, the customer is declining the benefit amount.", (Object)claimAllocationDialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), BigDecimal.TEN);
        this.checkAllocation((FinancialAct)this.get((IMObject)payment), BigDecimal.TEN);
        Assert.assertEquals((long)0L, (long)editDialog.getAdjustments().size());
        this.checkClaim(claim1, Claim.Status.ACCEPTED, GapClaim.GapStatus.NOTIFIED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testAllocationToMultipleClaims() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        List<FinancialAct> invoice2Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice2 = invoice2Acts.get(0);
        FinancialAct item2 = invoice2Acts.get(1);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.SUBMITTED);
        FinancialAct claim2 = this.createClaim(item2, Claim.Status.SUBMITTED);
        BigDecimal twenty = BigDecimal.valueOf(20L);
        CreditActEditDialog editDialog = this.pay(twenty);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1, invoice2);
        allocationDialog.swap(invoice1, invoice2);
        this.checkDebits(allocationDialog, invoice2, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)2L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, BigDecimal.TEN);
        this.checkAllocation(claim2, allocations, BigDecimal.TEN);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog1 = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((Object)"The benefit amount for this Gap Claim has not been received.\n\nThe claim will be fully paid and the insurer will reimburse the customer.", (Object)claimAllocationDialog1.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog1, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog2 = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((Object)"The benefit amount for this Gap Claim has not been received.\n\nThe claim will be fully paid and the insurer will reimburse the customer.", (Object)claimAllocationDialog2.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog2, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), BigDecimal.TEN);
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice2), BigDecimal.TEN);
        this.checkPayment((FinancialAct)this.get((IMObject)payment), twenty, twenty, this.till);
        this.checkClaim(claim1, Claim.Status.SUBMITTED, GapClaim.GapStatus.NOTIFIED);
        this.checkClaim(claim2, Claim.Status.SUBMITTED, GapClaim.GapStatus.NOTIFIED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)2L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testClaimUpdatedDuringPaymentAllocation() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        BigDecimal five = BigDecimal.valueOf(5L);
        FinancialAct claim1 = this.createClaim(item1, Claim.Status.SUBMITTED);
        CreditActEditDialog editDialog = this.pay(BigDecimal.TEN);
        FinancialAct payment = (FinancialAct)editDialog.getEditor().getObject();
        AllocationDialog allocationDialog = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog, invoice1);
        List allocations = allocationDialog.getGapClaimAllocations();
        Assert.assertEquals((long)1L, (long)allocations.size());
        this.checkAllocation(claim1, allocations, BigDecimal.TEN);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog, (String)"ok");
        claim1.setStatus(Claim.Status.ACCEPTED.toString());
        this.setGapStatus(claim1, GapClaim.GapStatus.RECEIVED, five);
        this.save((IMObject)claim1);
        GapClaimAllocationDialog claimAllocationDialog = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim1.getId(), (long)claimAllocationDialog.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"The benefit amount for this Gap Claim has not been received.\n\nThe claim will be fully paid and the insurer will reimburse the customer.", (Object)claimAllocationDialog.getMessage());
        Assert.assertTrue((boolean)this.errors.isEmpty());
        this.checkEquals(BigDecimal.TEN, payment.getTotal());
        this.checkEquals(BigDecimal.ZERO, payment.getAllocatedAmount());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog, (String)"ok");
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"The Payment could not be saved. It may have been changed by another user.\n\nYour changes have been reverted.", (Object)this.errors.get(0));
        this.checkEquals(BigDecimal.TEN, payment.getTotal());
        this.checkEquals(BigDecimal.ZERO, payment.getAllocatedAmount());
        this.errors.clear();
        this.pay(editDialog, five);
        AllocationDialog allocationDialog2 = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog2, invoice1);
        List allocations2 = allocationDialog2.getGapClaimAllocations();
        Assert.assertEquals((long)1L, (long)allocations2.size());
        this.checkAllocation(claim1, allocations2, five);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog2, (String)"ok");
        Entity gapBenefitTill = this.practiceFactory.createTill();
        GapClaimAllocationDialog claimAllocationDialog2 = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claim1.getId(), (long)claimAllocationDialog2.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"By making this payment, the customer is accepting the benefit amount.", (Object)claimAllocationDialog2.getMessage());
        Assert.assertNull((Object)claimAllocationDialog2.getAllocation().getTill());
        claimAllocationDialog2.setTill(gapBenefitTill);
        Assert.assertNotNull((Object)claimAllocationDialog2.getAllocation().getTill());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog2, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), BigDecimal.TEN);
        this.checkAllocation((FinancialAct)this.get((IMObject)payment), five);
        List adjustments = editDialog.getAdjustments();
        Assert.assertEquals((long)1L, (long)adjustments.size());
        this.checkPayment((FinancialAct)adjustments.get(0), five, five, gapBenefitTill);
        this.checkClaim(claim1, Claim.Status.ACCEPTED, GapClaim.GapStatus.NOTIFIED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    @Test
    public void testAllocationToPreSettledClaim() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        BigDecimal benefitAmount = BigDecimal.valueOf(5L);
        FinancialAct claimAct = this.createClaim(item1, Claim.Status.PRE_SETTLED, GapClaim.GapStatus.RECEIVED, benefitAmount);
        CreditActEditDialog editDialog = this.pay(BigDecimal.TEN);
        AllocationDialog allocationDialog1 = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog1, invoice1);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog1, (String)"ok");
        GapClaimAllocationDialog claimAllocationDialog1 = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        Assert.assertEquals((long)claimAct.getId(), (long)claimAllocationDialog1.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"This claim has been pre-settled, but the payment amount is greater than the gap.\n\nReduce the payment amount to $5.00, in order to settle this claim.", (Object)claimAllocationDialog1.getMessage());
        BigDecimal unpaid = claimAllocationDialog1.getAllocation().getUnpaidGap();
        this.checkEquals(5, unpaid);
        Assert.assertFalse((boolean)claimAllocationDialog1.getButtons().getButton("ok").isEnabled());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog1, (String)"cancel");
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog1, (String)"cancel");
        PaymentEditor editor = (PaymentEditor)editDialog.getEditor();
        FinancialAct payment = editor.getObject();
        editor.getCurrentItem().setAmount(unpaid);
        EchoTestHelper.fireDialogButton((PopupDialog)editDialog, (String)"ok");
        AllocationDialog allocationDialog2 = (AllocationDialog)this.findComponent(AllocationDialog.class);
        this.checkDebits(allocationDialog2, invoice1);
        EchoTestHelper.fireDialogButton((PopupDialog)allocationDialog2, (String)"ok");
        Entity gapBenefitTill = this.practiceFactory.createTill();
        GapClaimAllocationDialog claimAllocationDialog2 = (GapClaimAllocationDialog)this.findComponent(GapClaimAllocationDialog.class);
        claimAllocationDialog2.setTill(gapBenefitTill);
        Assert.assertEquals((long)claimAct.getId(), (long)claimAllocationDialog2.getAllocation().getClaim().getId());
        Assert.assertEquals((Object)"By making this payment, the customer is accepting the benefit amount.", (Object)claimAllocationDialog2.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)claimAllocationDialog2, (String)"ok");
        this.checkAllocation((FinancialAct)this.get((IMObject)invoice1), BigDecimal.TEN);
        this.checkPayment((FinancialAct)this.get((IMObject)payment), unpaid, unpaid, this.till);
        List adjustments = editDialog.getAdjustments();
        Assert.assertEquals((long)1L, (long)adjustments.size());
        this.checkAllocation((FinancialAct)this.get((IMObject)adjustments.get(0)), unpaid);
        this.checkClaim(claimAct, Claim.Status.SETTLED, GapClaim.GapStatus.NOTIFIED);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)1L, (long)this.insuranceService.getPaymentNotified());
    }

    private CreditActEditDialog pay(BigDecimal amount) {
        FinancialAct payment = (FinancialAct)this.create("act.customerAccountPayment", FinancialAct.class);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        CustomerPaymentEditor paymentEditor = new CustomerPaymentEditor(payment, null, (LayoutContext)layout);
        TestCreditActEditDialog editDialog = new TestCreditActEditDialog(paymentEditor);
        this.pay(editDialog, amount);
        return editDialog;
    }

    private void pay(CreditActEditDialog editDialog, BigDecimal amount) {
        CustomerPaymentEditor paymentEditor = (CustomerPaymentEditor)editDialog.getEditor();
        editDialog.show();
        PaymentItemEditor itemEditor = paymentEditor.getUnsavedItem();
        itemEditor.setAmount(amount);
        Assert.assertTrue((boolean)paymentEditor.isValid());
        EchoTestHelper.fireDialogButton((PopupDialog)editDialog, (String)"ok");
    }

    private void checkClaim(FinancialAct claim, Claim.Status status, GapClaim.GapStatus gapStatus) {
        claim = (FinancialAct)this.get((IMObject)claim);
        Assert.assertEquals((Object)status.toString(), (Object)claim.getStatus());
        if (gapStatus == null) {
            Assert.assertNull((Object)claim.getStatus2());
        } else {
            Assert.assertEquals((Object)gapStatus.toString(), (Object)claim.getStatus2());
        }
    }

    private void checkAllocation(FinancialAct claim, List<GapClaimAllocation> allocations, BigDecimal amount) {
        GapClaimAllocation result = null;
        for (GapClaimAllocation allocation : allocations) {
            if (claim.getId() != allocation.getClaim().getId()) continue;
            this.checkEquals(amount, allocation.getNewAllocation());
            result = allocation;
            break;
        }
        Assert.assertNotNull(result);
    }

    private void checkDebits(AllocationDialog dialog, FinancialAct ... debits) {
        List actual = dialog.getDebits();
        Assert.assertEquals(Arrays.asList(debits), (Object)actual);
    }

    private FinancialAct createClaim(FinancialAct invoiceItem, Claim.Status status) {
        return this.createClaim(invoiceItem, status, null, null);
    }

    private FinancialAct createClaim(FinancialAct invoiceItem, Claim.Status status, GapClaim.GapStatus gapStatus, BigDecimal benefitAmount) {
        TestClaimBuilder builder = this.insuranceFactory.newClaim().policy(this.policy).location(this.location).clinician(this.clinician).claimHandler(this.clinician).status(status.toString()).gapClaim(true).item(new FinancialAct[]{invoiceItem});
        if (gapStatus != null) {
            builder.gapStatus(gapStatus.toString()).benefitAmount(benefitAmount);
        }
        return (FinancialAct)builder.build();
    }

    private void setGapStatus(FinancialAct claim, GapClaim.GapStatus gapStatus, BigDecimal benefitAmount) {
        claim.setStatus2(gapStatus.toString());
        IMObjectBean bean = this.getBean((IMObject)claim);
        bean.setValue("benefitAmount", (Object)benefitAmount);
    }

    private List<FinancialAct> createInvoice(BigDecimal amount) {
        Product product = this.productFactory.createMedication();
        TestInvoiceBuilder builder = (TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customer)).status("POSTED")).item().patient(this.patient)).product(product)).quantity(1)).unitPrice(amount)).add();
        FinancialAct invoice = (FinancialAct)builder.build();
        FinancialAct item = (FinancialAct)builder.getItems().get(0);
        return Arrays.asList(invoice, item);
    }

    private void checkPayment(FinancialAct payment, BigDecimal total, BigDecimal allocated, Entity till) {
        Assert.assertTrue((boolean)payment.isA("act.customerAccountPayment"));
        this.checkEquals(total, payment.getTotal());
        this.checkEquals(allocated, payment.getAllocatedAmount());
        Assert.assertEquals((Object)"POSTED", (Object)payment.getStatus());
        IMObjectBean bean = this.getBean((IMObject)payment);
        Assert.assertEquals((Object)this.customer.getObjectReference(), (Object)bean.getTargetRef("customer"));
        Assert.assertEquals((Object)till.getObjectReference(), (Object)bean.getTargetRef("till"));
    }

    private void checkAllocation(FinancialAct act, BigDecimal amount) {
        this.checkEquals(amount, act.getAllocatedAmount());
    }

    private class TestCreditActEditDialog
    extends CreditActEditDialog {
        public TestCreditActEditDialog(CustomerPaymentEditor paymentEditor) {
            super((IMObjectEditor)paymentEditor, CreditActEditDialogTestCase.this.context);
        }

        protected InsuranceServices getInsuranceServices() {
            InsuranceServices insuranceServices = (InsuranceServices)Mockito.mock(InsuranceServices.class);
            Mockito.when((Object)insuranceServices.canSubmit((Party)Mockito.any())).thenReturn((Object)true);
            Mockito.when((Object)insuranceServices.getService((Party)Mockito.any())).thenReturn((Object)CreditActEditDialogTestCase.this.insuranceService);
            return insuranceServices;
        }
    }
}

